/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IFeedManagerConfigurer;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointHandler;
import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class FeedCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.team.feed.core";
    private static FeedCorePlugin fgDefault;
    private static final String FEED_PROVIDER_EXTENSION = "feedManagerConfigurer";
    private ExtensionPointManager fExtensionPointMgr;
    private List<String> fLoggedContext = new ArrayList<String>();

    public static FeedCorePlugin getDefault() {
        return fgDefault;
    }

    public FeedCorePlugin() {
        fgDefault = this;
    }

    private void loadContributions() {
        ExtensionPointHandler expHandler = new ExtensionPointHandler(this.fExtensionPointMgr, FEED_PROVIDER_EXTENSION, FEED_PROVIDER_EXTENSION){

            protected Object elementAdded(IConfigurationElement element) {
                try {
                    IFeedManagerConfigurer provider = (IFeedManagerConfigurer)element.createExecutableExtension("class");
                    provider.configure(FeedManager.getDefault());
                }
                catch (CoreException e) {
                    FeedCorePlugin.this.log(e.getMessage(), e);
                }
                return element;
            }

            protected void elementsRemoved(List removed) {
            }
        };
        expHandler.init();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fExtensionPointMgr = new ExtensionPointManager(this.getBundle());
        this.loadContributions();
    }

    public void stop(BundleContext context) throws Exception {
        fgDefault = null;
        FeedManager.shutdown();
        this.fExtensionPointMgr.dispose();
        ClientFeedUtils.getInstance().dispose();
        super.stop(context);
    }

    public void log(String message, Throwable x) {
        this.log(new Status(4, PLUGIN_ID, 4, message, x));
    }

    public void log(Throwable x) {
        this.log(new Status(4, PLUGIN_ID, 4, x.getLocalizedMessage(), x));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOnce(String context, Throwable x) {
        List<String> list = this.fLoggedContext;
        synchronized (list) {
            if (!this.fLoggedContext.contains(context)) {
                this.fLoggedContext.add(context);
                this.log(new Status(4, PLUGIN_ID, 4, x.getLocalizedMessage(), x));
            }
        }
    }

    public void log(Status status) {
        FoundationLog.log((IStatus)status);
    }
}

