/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.model.Channel;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelManager {
    private final HashSet<String> fSelectedChannels = new HashSet();
    private INewsListener fNewsListener;
    private final INewsManagerListener fNewsManagerListener = new INewsManagerListener(){

        public void channelAdded(ChannelEvent event) {
        }

        public void channelRemoved(ChannelEvent event) {
            ChannelManager.this.fSelectedChannels.remove(event.getChannel());
        }
    };

    public ChannelManager() {
        FeedManager.getDefault().addNewsManagerListener(this.fNewsManagerListener);
    }

    public void selectChannel(String channelUrl) {
        this.fSelectedChannels.add(channelUrl);
    }

    public void selectChannel(Channel channel) {
        this.fSelectedChannels.add(channel.getUrl());
        if (this.fNewsListener != null) {
            FeedManager.getDefault().addNewsListener(channel, this.fNewsListener);
        }
    }

    public boolean isChannelSelected(Channel channel) {
        return channel != null && this.fSelectedChannels.contains(channel.getUrl());
    }

    public boolean isChannelSelected(String url) {
        return this.fSelectedChannels.contains(url);
    }

    public void deselectChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        this.fSelectedChannels.remove(channel.getUrl());
        if (this.fNewsListener != null) {
            FeedManager.getDefault().removeNewsListener(channel, this.fNewsListener);
        }
    }

    public void deselectAllChannels() {
        this.dispose();
    }

    public HashSet<String> getSelectedChannelUrls() {
        return new HashSet<String>(this.fSelectedChannels);
    }

    public void setNewsListener(INewsListener newsListener) {
        if (this.fNewsListener != null) {
            this.dispose();
        }
        this.fNewsListener = newsListener;
        FeedManager newsManager = FeedManager.getDefault();
        Iterator<String> iterator = this.getSelectedChannelUrls().iterator();
        while (iterator.hasNext()) {
            Channel channel = newsManager.getChannel(iterator.next());
            if (channel == null) continue;
            newsManager.addNewsListener(channel, this.fNewsListener);
        }
    }

    public void dispose() {
        if (this.fSelectedChannels == null) {
            return;
        }
        FeedManager newsManager = FeedManager.getDefault();
        newsManager.removeNewsManagerListener(this.fNewsManagerListener);
        if (this.fNewsListener != null) {
            Iterator<String> iterator = this.getSelectedChannelUrls().iterator();
            while (iterator.hasNext()) {
                Channel channel = newsManager.getChannel(iterator.next());
                if (channel == null) continue;
                newsManager.removeNewsListener(channel, this.fNewsListener);
            }
        }
        this.fSelectedChannels.clear();
    }
}

