/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.transport.client.CertificateStore;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ValidatingX509TrustManager
implements X509TrustManager {
    private X509TrustManager baseTrustManager;
    private ICertificateValidator validator;
    private static CertificateStore sessionCerts;
    private static CertificateStore runtimeCerts;
    private static final String userTrustStoreLocation;
    private static final String userTrustStorePassword;

    static {
        String userHome = System.getProperty("user.home");
        userTrustStoreLocation = String.valueOf(userHome) + "/.jazzcerts".replace('/', File.separatorChar);
        userTrustStorePassword = "ibmrationaljazz";
    }

    private static synchronized void buildSessionTrustStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (sessionCerts == null) {
            sessionCerts = new CertificateStore();
        }
    }

    private static synchronized void buildRuntimeTrustStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (runtimeCerts != null) {
            return;
        }
        String javaHome = System.getProperty("java.home");
        String[] locations = new String[]{System.getProperty("javax.net.ssl.trustStore"), String.valueOf(javaHome) + "/lib/security/cacerts".replace('/', File.separatorChar), String.valueOf(javaHome) + "/lib/security/jssecacerts".replace('/', File.separatorChar), userTrustStoreLocation};
        String[] stringArray = new String[4];
        stringArray[0] = System.getProperty("javax.net.ssl.trustStorePassword");
        stringArray[3] = userTrustStorePassword;
        String[] passwords = stringArray;
        CertificateStore store = new CertificateStore();
        int i = 0;
        while (i < locations.length) {
            File f;
            if (locations[i] != null && locations[i].length() >= 1 && (f = new File(locations[i])).canRead()) {
                try {
                    store.loadCertificates(f, passwords[i]);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        runtimeCerts = store;
    }

    private void initializeBaseTrustManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManager[] managers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(runtimeCerts.getKeyStore());
        TrustManager[] trustManagerArray = managers = factory.getTrustManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager manager = trustManagerArray[n2];
            if (manager instanceof X509TrustManager) {
                this.baseTrustManager = (X509TrustManager)manager;
                break;
            }
            ++n2;
        }
        if (this.baseTrustManager == null) {
            throw new IllegalStateException("Couldn't find JRE's X509TrustManager");
        }
    }

    private synchronized void installCertificate(Certificate cert) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        File f = new File(userTrustStoreLocation);
        KeyStore ks = CertificateStore.load(f, userTrustStorePassword);
        ks.setCertificateEntry(CertificateStore.computeAlias(cert), cert);
        CertificateStore.store(ks, f, userTrustStorePassword);
    }

    public ValidatingX509TrustManager(ICertificateValidator validator) {
        this.validator = validator;
        try {
            if (sessionCerts == null) {
                ValidatingX509TrustManager.buildSessionTrustStore();
            }
            if (runtimeCerts == null) {
                ValidatingX509TrustManager.buildRuntimeTrustStore();
            }
            this.initializeBaseTrustManager();
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {}
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.baseTrustManager.getAcceptedIssuers();
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.baseTrustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate cert = chain[0];
        try {
            if (sessionCerts.containsCertificate(cert)) {
                return;
            }
        }
        catch (KeyStoreException keyStoreException) {}
        try {
            this.baseTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certEx) {
            if (this.validator == null) {
                throw certEx;
            }
            ICertificateValidator.Trust disposition = this.validator.validate(cert, certEx);
            switch (disposition) {
                case REJECT: {
                    throw certEx;
                }
                case ACCEPT_CONNECTION: {
                    return;
                }
                case ACCEPT_SESSION: {
                    try {
                        sessionCerts.enterCertificate(cert);
                    }
                    catch (KeyStoreException keyStoreException) {}
                    return;
                }
                case ACCEPT_PERMANENT: {
                    try {
                        sessionCerts.enterCertificate(cert);
                        this.installCertificate(cert);
                    }
                    catch (KeyStoreException keyStoreException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
        }
    }
}

