/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.transport.client.InterruptableSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class InterruptableSocketFactory
implements ProtocolSocketFactory {
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        this.doConnect(channel, host, port);
        return InterruptableSocket.newInterruptableSocket(channel.socket(), channel);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        this.doConnect(channel, host, port);
        return InterruptableSocket.newInterruptableSocket(socket, channel);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (params.isParameterSet("http.tcp.nodelay")) {
            socket.setTcpNoDelay(params.getTcpNoDelay());
        }
        if (params.isParameterSet("http.socket.sendbuffer")) {
            socket.setSendBufferSize(params.getSendBufferSize());
        }
        if (params.isParameterSet("http.socket.receivebuffer")) {
            socket.setReceiveBufferSize(params.getReceiveBufferSize());
        }
        if (params.isParameterSet("http.socket.timeout")) {
            socket.setSoTimeout(params.getSoTimeout());
        }
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        this.doConnect(channel, host, port);
        return InterruptableSocket.newInterruptableSocket(socket, channel);
    }

    protected void doConnect(SocketChannel channel, String remoteHost, int remotePort) throws IOException {
        channel.configureBlocking(true);
        Thread currentThread = Thread.currentThread();
        TeamServiceCallContextImpl.registerConnectingSocket((SocketChannel)channel, (Thread)currentThread);
        try {
            channel.connect(new InetSocketAddress(remoteHost, remotePort));
        }
        finally {
            TeamServiceCallContextImpl.unregisterConnectingSocket((Thread)currentThread);
        }
    }
}

