/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cds;

import com.ibm.cds.CDSBundleEntry;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class CDSBundleFile
extends BundleFile {
    private BundleFile wrapped;
    private URL url;
    private SharedClassURLHelper urlHelper;
    private boolean primed = false;

    public CDSBundleFile(BundleFile wrapped) {
        super(wrapped.getBaseFile());
        this.wrapped = wrapped;
        try {
            this.url = new URL("file", "", wrapped.getBaseFile().getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public CDSBundleFile(BundleFile bundleFile, SharedClassURLHelper urlHelper) {
        this(bundleFile);
        this.urlHelper = urlHelper;
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public boolean containsDir(String dir) {
        return this.wrapped.containsDir(dir);
    }

    public BundleEntry getEntry(String path) {
        if (!this.primed || !path.endsWith(".class")) {
            return this.wrapped.getEntry(path);
        }
        byte[] classbytes = this.getClassBytes(path.substring(0, path.length() - 6));
        if (classbytes == null) {
            return this.wrapped.getEntry(path);
        }
        return new CDSBundleEntry(path, classbytes, this.wrapped);
    }

    public Enumeration getEntryPaths(String path) {
        return this.wrapped.getEntryPaths(path);
    }

    public File getFile(String path, boolean nativeCode) {
        return this.wrapped.getFile(path, nativeCode);
    }

    public void open() throws IOException {
        this.wrapped.open();
    }

    URL getURL() {
        return this.url;
    }

    SharedClassURLHelper getURLHelper() {
        return this.urlHelper;
    }

    void setURLHelper(SharedClassURLHelper urlHelper) {
        this.urlHelper = urlHelper;
        this.primed = false;
    }

    void setPrimed(boolean primed) {
        this.primed = primed;
    }

    private byte[] getClassBytes(String name) {
        if (this.urlHelper == null || this.url == null) {
            return null;
        }
        return this.urlHelper.findSharedClass(this.url, name);
    }
}

