/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static ITeamRepository getTeamRepository(String string) {
        return RepositoryUtils.getTeamRepository(string, 0);
    }

    public static ITeamRepository getTeamRepository(String string, int n) {
        return TeamPlatform.getTeamRepositoryService().getTeamRepository(string, n);
    }

    public static ITeamRepository getTeamRepository(String string, UUID uUID) {
        return RepositoryUtils.getTeamRepository(string, 0, uUID);
    }

    public static ITeamRepository getTeamRepository(String string, int n, UUID uUID) {
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n2 = 0;
        while (n2 < iTeamRepositoryArray.length) {
            if (uUID.equals((Object)iTeamRepositoryArray[n2].getId())) {
                return iTeamRepositoryArray[n2];
            }
            ++n2;
        }
        ITeamRepository iTeamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(string, n);
        if (iTeamRepository != null && iTeamRepository.getId() == null) {
            try {
                iTeamRepository.setId(uUID);
            }
            catch (Exception exception) {}
        }
        return iTeamRepository;
    }

    public static void throwAppropriateException(String string, IStatus[] iStatusArray) throws FileSystemClientException {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, iStatusArray, string, null);
        if (multiStatus.isOK()) {
            return;
        }
        if (multiStatus.matches(4)) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
        if (multiStatus.matches(8)) {
            throw (Throwable)new OperationCanceledException();
        }
        throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
    }

    public static IContributorHandle getLoggedInContributor(ITeamRepository iTeamRepository) throws NotLoggedInException {
        IContributor iContributor = iTeamRepository.loggedInContributor();
        if (iContributor == null) {
            NotLoggedInException notLoggedInException = new NotLoggedInException(iTeamRepository.getRepositoryURI());
            notLoggedInException.setOrigin((Object)iTeamRepository);
            throw (Throwable)notLoggedInException;
        }
        return (IContributorHandle)iContributor;
    }
}

