/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;

public class PersistentFlag
implements IPersistentFlag {
    private boolean state = false;
    private File file;

    public PersistentFlag(File file) {
        this.file = file;
        this.state = file.exists();
    }

    public boolean setState(boolean bl) throws IOException {
        boolean bl2 = this.state;
        this.state = bl;
        if (bl) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
        return bl2;
    }

    private void writeTrue() throws IOException {
        this.ensureParents();
        if (!this.file.createNewFile()) {
            if (this.file.exists()) {
                return;
            }
            throw (Throwable)new IOException(NLS.bind((String)Messages.PersistentFlag_0, (Object[])new Object[]{this.file.getAbsolutePath()}));
        }
    }

    private void writeFalse() throws IOException {
        this.ensureParents();
        if (!this.file.delete() && this.file.exists()) {
            throw (Throwable)new IOException(NLS.bind((String)Messages.PersistentFlag_1, (Object[])new Object[]{this.file.getAbsolutePath()}));
        }
    }

    private void ensureParents() throws IOException {
        File file = this.file.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public String toString() {
        return String.valueOf(this.file.getAbsolutePath()) + " (" + this.state + ')';
    }
}

