/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$IIgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils$1;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils$2;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils$3;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils$4;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils$IIgnoredForRuleController;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class IgnoreUtils {
    public static void findIgnoresForEvent(IIgnoreEvent iIgnoreEvent, IgnoreUtils$IIgnoredForRuleController ignoreUtils$IIgnoredForRuleController) throws FileSystemClientException {
        Exception[] exceptionArray = new Exception[1];
        IIgnoreManager iIgnoreManager = null;
        try {
            iIgnoreManager = (IIgnoreManager)iIgnoreEvent.getEventSource();
        }
        catch (ClassCastException classCastException) {
            throw (Throwable)new IllegalStateException("Could not cast an ignore event to be an IIgnoreManager", classCastException);
        }
        IIgnoreManager iIgnoreManager2 = iIgnoreManager;
        for (IShareable iShareable : iIgnoreEvent.getRoots()) {
            iShareable.accept((IShareableVisitor)new IgnoreUtils$1(exceptionArray, iIgnoreEvent, ignoreUtils$IIgnoredForRuleController, iIgnoreManager2), Integer.MAX_VALUE, true, (ISchedulingRule)iShareable.getAdapter(ISchedulingRule.class), null);
        }
    }

    public static void findIgnoresForRules(Collection collection, Collection collection2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(collection, new IgnoreUtils$2(collection2), iProgressMonitor);
    }

    public static void findIgnoresForRules(Collection collection, boolean bl, Collection collection2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(collection, bl, new IgnoreUtils$3(collection2, bl), iProgressMonitor);
    }

    public static void findIgnoresForRules(Collection collection, IgnoreUtils$IIgnoredForRuleController ignoreUtils$IIgnoredForRuleController, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IgnoreUtils.findIgnoresForRules(collection, false, ignoreUtils$IIgnoredForRuleController, iProgressMonitor);
    }

    public static void findIgnoresForRules(Collection collection, boolean bl, IgnoreUtils$IIgnoredForRuleController ignoreUtils$IIgnoredForRuleController, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException("rules may not be null");
        }
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : collection) {
            List list = iIgnoreProvider$IIgnoreRule.getEffectiveFrom();
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.beginTask(Messages.IgnoreUtils_0, list.size());
            for (IShareable iShareable : list) {
                subMonitor2.setTaskName(NLS.bind((String)Messages.IgnoreUtils_1, (Object[])new Object[]{iShareable.getLocalFullPath().toString()}));
                iShareable.accept((IShareableVisitor)new IgnoreUtils$4(fileSystemClientExceptionArray, iIgnoreProvider$IIgnoreRule, ignoreUtils$IIgnoredForRuleController), Integer.MAX_VALUE, true, null, (IProgressMonitor)subMonitor2.newChild(1));
            }
            if (fileSystemClientExceptionArray[0] == null) continue;
            throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
        }
    }

    public static void removeContainedRules(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IgnoreRule ignoreRule = (IgnoreRule)iterator.next();
            IShareable iShareable = ignoreRule.getFile();
            boolean bl = false;
            for (IgnoreRule ignoreRule2 : list) {
                if (!IgnoreUtils.ruleOccludes(ignoreRule2, iShareable)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private static boolean ruleOccludes(IgnoreRule ignoreRule, IShareable iShareable) {
        for (IShareable iShareable2 : ignoreRule.getEffectiveFrom()) {
            IPath iPath;
            IPath iPath2 = iShareable2.getLocalFullPath();
            if (!iPath2.isPrefixOf(iPath = iShareable.getLocalFullPath())) continue;
            int n = iPath2.segmentCount();
            while (n < iPath.segmentCount()) {
                IPath iPath3 = iPath.removeLastSegments(iPath.segmentCount() - n);
                if (ignoreRule.shouldBeIgnored(iPath3)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static HashSet extractRulesFromReasons(List list) {
        HashSet hashSet = new HashSet();
        for (IIgnoreManager$IIgnoreReason iIgnoreManager$IIgnoreReason : list) {
            hashSet.addAll(iIgnoreManager$IIgnoreReason.getRules());
        }
        return hashSet;
    }

    public static String describeRule(IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule) {
        return iIgnoreProvider$IIgnoreRule.getShortDescription();
    }

    public static boolean ignoredDueTo(IIgnoreProvider iIgnoreProvider, IShareable iShareable) throws FileSystemClientException {
        IIgnoreManager$IIgnoreReason iIgnoreManager$IIgnoreReason = SharingManager.getInstance().getIgnoreManager().findIgnoreReasons(iShareable, null);
        if (iIgnoreManager$IIgnoreReason == null) {
            return false;
        }
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : iIgnoreManager$IIgnoreReason.getRules()) {
            if (iIgnoreProvider$IIgnoreRule.getProvider().equals(iIgnoreProvider)) continue;
            return false;
        }
        return true;
    }
}

