/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ConnectionDescriptor {
    public final String uri;
    public final UUID id;
    public final IContextHandle connectionHandle;
    private ITeamRepository repo;
    private IConnection connection;

    public ConnectionDescriptor(UUID uUID, String string, IContextHandle iContextHandle) {
        if (uUID == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!(iContextHandle instanceof IWorkspaceHandle) && !(iContextHandle instanceof IBaselineHandle)) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.uri = string;
        this.id = uUID;
        this.connectionHandle = iContextHandle;
    }

    public ConnectionDescriptor(IConnection iConnection) {
        if (!(iConnection instanceof IWorkspaceConnection) && !(iConnection instanceof IBaselineConnection)) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.repo = iConnection.teamRepository();
        this.uri = this.repo.getRepositoryURI();
        this.id = this.repo.getId();
        this.connection = iConnection;
        this.connectionHandle = iConnection.getContextHandle();
    }

    public ITeamRepository getTeamRepository() {
        if (this.repo == null) {
            this.repo = RepositoryUtils.getTeamRepository(this.uri, this.id);
        }
        return this.repo;
    }

    public IConnection getConnection(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        if (this.connection == null) {
            IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
            if (this.connectionHandle instanceof IWorkspaceHandle) {
                this.connection = (IConnection)iWorkspaceManager.getWorkspaceConnection((IWorkspaceHandle)this.connectionHandle, (IProgressMonitor)subMonitor);
            } else if (this.connectionHandle instanceof IBaselineHandle) {
                this.connection = (IConnection)iWorkspaceManager.getBaselineConnection((IBaselineHandle)this.connectionHandle, (IProgressMonitor)subMonitor);
            }
        }
        subMonitor.done();
        return this.connection;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.connectionHandle == null ? 0 : this.connectionHandle.getItemId().hashCode());
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)object;
        if (this.connectionHandle == null ? connectionDescriptor.connectionHandle != null : !this.connectionHandle.sameItemId((IItemHandle)connectionDescriptor.connectionHandle)) {
            return false;
        }
        return !(this.id == null ? connectionDescriptor.id != null : !this.id.equals((Object)connectionDescriptor.id));
    }
}

