/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConfigurationDescriptor
extends ConnectionDescriptor {
    public final IComponentHandle componentHandle;
    private IConfiguration configuration;

    public ConfigurationDescriptor(UUID uUID, String string, IContextHandle iContextHandle, IComponentHandle iComponentHandle) {
        super(uUID, string, iContextHandle);
        this.componentHandle = iComponentHandle;
    }

    public ConfigurationDescriptor(IConnection iConnection, IComponentHandle iComponentHandle) {
        super(iConnection);
        this.componentHandle = iComponentHandle;
    }

    public ConfigurationDescriptor(IBaselineConnection iBaselineConnection) {
        super((IConnection)iBaselineConnection);
        this.componentHandle = iBaselineConnection.getComponent();
        this.configuration = iBaselineConnection.configuration();
    }

    public IConfiguration getConfiguration(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.configuration == null) {
            IConnection iConnection = this.getConnection(iProgressMonitor);
            if (iConnection instanceof IWorkspaceConnection) {
                this.configuration = ((IWorkspaceConnection)iConnection).configuration(this.componentHandle);
            } else if (iConnection instanceof IBaselineConnection) {
                this.configuration = ((IBaselineConnection)iConnection).configuration();
            }
        }
        return this.configuration;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.componentHandle == null ? 0 : this.componentHandle.getItemId().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)object;
        return !(this.componentHandle == null ? configurationDescriptor.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)configurationDescriptor.componentHandle));
    }

    public boolean sameConfiguration(ConfigurationDescriptor configurationDescriptor) {
        if (this == configurationDescriptor) {
            return true;
        }
        if (this.componentHandle == null ? configurationDescriptor.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)configurationDescriptor.componentHandle)) {
            return false;
        }
        if (this.connectionHandle == null ? configurationDescriptor.connectionHandle != null : !this.connectionHandle.sameItemId((IItemHandle)configurationDescriptor.connectionHandle)) {
            return false;
        }
        return !(this.id == null ? configurationDescriptor.id != null : !this.id.equals((Object)configurationDescriptor.id));
    }
}

