/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtil {
    private static char[] LINE_SEPARATOR = System.getProperty("line.separator").toCharArray();

    public static ITeamRepository getTeamRepository(String repositoryUrl) {
        return RepositoryUtils.getTeamRepository(repositoryUrl);
    }

    public static IWorkspaceHandle createWorkspaceHandle(ITeamRepository repo, String itemId) {
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IComponentHandle createComponentHandle(ITeamRepository repo, String itemId) {
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IChangeSetHandle createChangeSetHandle(ITeamRepository repo, String itemId) {
        return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IBaselineSetHandle getBaselineSet(ITeamRepository repo, String itemId) {
        return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IFolderHandle createFolderHandle(ITeamRepository repo, String itemId) {
        return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static List<? extends IItemHandle> createHandles(IItemType itemType, String repositoryUrl, String[] itemIds) {
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>();
        if (itemIds != null) {
            ITeamRepository repo = CommonUtil.getTeamRepository(repositoryUrl);
            String[] stringArray = itemIds;
            int n = itemIds.length;
            int n2 = 0;
            while (n2 < n) {
                String itemId = stringArray[n2];
                handles.add(itemType.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null));
                ++n2;
            }
        }
        return handles;
    }

    public static String getErrorMessage(FileSystemClientException e) {
        StringBuffer errorMsg = new StringBuffer();
        IStatus status = e.getStatus();
        if (status != null) {
            CommonUtil.appendStatus(errorMsg, status, 0);
        }
        if (status != null && status.getException() != null && !((Object)((Object)e)).equals(status.getException())) {
            CommonUtil.appendException(errorMsg, status.getException());
        }
        return errorMsg.toString();
    }

    private static void appendException(final StringBuffer errorMsg, Throwable e) {
        Writer errorBuffer = new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                errorMsg.append(cbuf, off, len);
            }
        };
        errorMsg.append(LINE_SEPARATOR);
        e.printStackTrace(new PrintWriter(errorBuffer));
        errorMsg.append(LINE_SEPARATOR);
    }

    private static void appendStatus(StringBuffer errorMsg, IStatus status, int level) {
        int i = 0;
        while (i < level) {
            errorMsg.append("    ");
            ++i;
        }
        errorMsg.append(status.getMessage()).append(LINE_SEPARATOR);
        if (status.isMultiStatus()) {
            int nextLevel = level + 1;
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                CommonUtil.appendStatus(errorMsg, childStatus, nextLevel);
                ++n2;
            }
        }
    }
}

