/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class OperationRequest {
    private final IWorkspaceConnection workspace;
    private IChangeHistorySyncReport syncReport;
    private List baselines;
    private List changeSets;
    private final List components;

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, List list) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.workspace = iWorkspaceConnection;
        this.changeSets = list;
        this.components = Collections.EMPTY_LIST;
        this.baselines = Collections.EMPTY_LIST;
        this.syncReport = null;
    }

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2) {
        this(iWorkspaceConnection, iChangeHistorySyncReport, list, list2, Collections.EMPTY_LIST);
    }

    public OperationRequest(IWorkspaceConnection iWorkspaceConnection, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2, List list3) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list3 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iChangeHistorySyncReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.syncReport = iChangeHistorySyncReport;
        this.baselines = list;
        this.workspace = iWorkspaceConnection;
        this.changeSets = list2;
        this.components = list3;
    }

    public void clearChanges(IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<IChangeSet> arrayList;
        List list;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        if (this.changeSets.size() > 0) {
            list = this.workspace.teamRepository().itemManager().fetchPartialItems(this.changeSets, 0, (Collection)Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), (IProgressMonitor)subMonitor.newChild(5));
            arrayList = new ArrayList<IChangeSet>();
            for (IChangeSet iChangeSet : list) {
                if (iChangeSet.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                arrayList.add(iChangeSet);
            }
            this.changeSets = arrayList;
        }
        if (this.baselines.size() > 0) {
            list = this.workspace.teamRepository().itemManager().fetchPartialItems(this.baselines, 0, (Collection)Collections.singletonList(IBaseline.COMPONENT_PROPERTY), (IProgressMonitor)subMonitor.newChild(5));
            arrayList = new ArrayList();
            for (IChangeSet iChangeSet : list) {
                if (iChangeSet.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                arrayList.add(iChangeSet);
            }
            this.baselines = arrayList;
        }
    }

    public Collection getAffectedConfigurations(List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        List list2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        if (!this.changeSets.isEmpty()) {
            list2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
            }
        }
        if (!this.baselines.isEmpty()) {
            list2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : list2) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, iChangeSet.getComponent()));
            }
        }
        if (!this.components.isEmpty()) {
            list2 = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.components, 0, (IProgressMonitor)subMonitor.newChild(50));
            list.addAll(list2);
            for (IChangeSet iChangeSet : this.components) {
                hashSet.add(new ConfigurationDescriptor((IConnection)this.workspace, (IComponentHandle)iChangeSet));
            }
        }
        return hashSet;
    }

    public List getAffectedComponents(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Collection collection = this.getAffectedConfigurations(new ArrayList(), iProgressMonitor);
        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>(collection.size());
        for (ConfigurationDescriptor configurationDescriptor : collection) {
            arrayList.add(configurationDescriptor.componentHandle);
        }
        return arrayList;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IChangeHistorySyncReport getSyncReport() {
        return this.syncReport;
    }

    public List getBaselines() {
        return this.baselines;
    }

    public List getChangeSets() {
        return this.changeSets;
    }

    public List getComponents() {
        return this.components;
    }

    public void setReport(IChangeHistorySyncReport iChangeHistorySyncReport) {
        this.syncReport = iChangeHistorySyncReport;
    }
}

