/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalFileSystemUpdateOperation
extends UpdateOperation {
    private final IPath fileSystemRoot;

    public LocalFileSystemUpdateOperation(IWorkspaceConnection iWorkspaceConnection, List list, IPath iPath, int n, UpdateDilemmaHandler updateDilemmaHandler) {
        this(iWorkspaceConnection, list, Collections.EMPTY_LIST, iPath, n, updateDilemmaHandler);
    }

    public LocalFileSystemUpdateOperation(IWorkspaceConnection iWorkspaceConnection, List list, List list2, IPath iPath, int n, UpdateDilemmaHandler updateDilemmaHandler) {
        super(iWorkspaceConnection, list, list2, n, updateDilemmaHandler);
        this.fileSystemRoot = iPath;
    }

    protected void loadFileArea(IWorkspaceConnection iWorkspaceConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        LocalFileSystemUpdateMutator localFileSystemUpdateMutator = new LocalFileSystemUpdateMutator((IConnection)iWorkspaceConnection, collection, collection2, fileAreaUpdateReport, this.fileSystemRoot, this.getDilemmaHandler());
        localFileSystemUpdateMutator.run(iProgressMonitor);
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getCopyFileArea(this.fileSystemRoot);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(this.getAffectedConfigurations());
        try {
            super.execute(iProgressMonitor);
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }
}

