/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Collision;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadOverlap;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.load.ShareableToLoad;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation$1;
import com.ibm.team.filesystem.client.internal.operations.LoadRequest;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest$InvalidLoadRequestReason;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public abstract class LoadOperation
extends FileSystemOperation
implements ILoadOperation {
    private HashMap requestsByConnection;
    private ISynchronizationInfo synchronizationInfo;
    private final LoadDilemmaHandler dilemmaHandler;
    private HashMap sharesToRemove = new HashMap();
    private HashMap treesToLoad;
    HashMap collisions;
    HashMap newItems;
    ArrayList loadOverLaps;
    ArrayList sharesOutOfSync;
    ArrayList invalidLoadRequests;
    HashMap configurationsToTrack;

    public LoadOperation(LoadDilemmaHandler loadDilemmaHandler) {
        super(loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler);
        this.dilemmaHandler = loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler;
        this.requestsByConnection = new HashMap();
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.configurationsToTrack = new HashMap();
    }

    public void requestLoad(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, Collection collection) {
        this.validateRequestToLoad((IConnection)iWorkspaceConnection, iComponentHandle, collection);
        this.recordRequestToLoad((IConnection)iWorkspaceConnection, iComponentHandle, collection);
    }

    public void requestLoad(IBaselineConnection iBaselineConnection, Collection collection) {
        this.validateRequestToLoad((IConnection)iBaselineConnection, iBaselineConnection.getComponent(), collection);
        this.recordRequestToLoad((IConnection)iBaselineConnection, iBaselineConnection.getComponent(), collection);
    }

    public void requestLoad(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ILoadRule iLoadRule : collection) {
            this.recordRequestToLoad((IConnection)iLoadRule.getWorkspaceConnection(), iLoadRule.getComponent(), iLoadRule.getFoldersToLoad((IProgressMonitor)subMonitor.newChild(1)));
        }
    }

    private void validateRequestToLoad(IConnection iConnection, IComponentHandle iComponentHandle, Collection collection) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IFolderHandle iFolderHandle : collection) {
            if (iFolderHandle != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
    }

    private void recordRequestToLoad(IConnection iConnection, IComponentHandle iComponentHandle, Collection collection) {
        ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iConnection, iComponentHandle);
        if (collection.isEmpty()) {
            HashSet<ConfigurationDescriptor> hashSet = (HashSet<ConfigurationDescriptor>)this.configurationsToTrack.get(iConnection);
            if (hashSet == null) {
                hashSet = new HashSet<ConfigurationDescriptor>();
                this.configurationsToTrack.put(iConnection, hashSet);
            }
            hashSet.add(configurationDescriptor);
        } else {
            HashSet<LoadRequest> hashSet;
            HashMap hashMap = (HashMap)this.requestsByConnection.get(iConnection);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.requestsByConnection.put(iConnection, hashMap);
            }
            if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor)) == null) {
                hashSet = new HashSet<LoadRequest>();
                hashMap.put(configurationDescriptor, hashSet);
            }
            for (IFolderHandle iFolderHandle : collection) {
                LoadRequest loadRequest = new LoadRequest(iConnection, iComponentHandle, iFolderHandle, false);
                hashSet.add(loadRequest);
            }
        }
    }

    public void requestReLoad(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        if (collection == null || collection.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            if (iShare != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            HashSet<LoadRequest> hashSet;
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
            IConnection iConnection = configurationDescriptor.getConnection((IProgressMonitor)subMonitor.newChild(1));
            HashMap<ConfigurationDescriptor, HashSet<LoadRequest>> hashMap = (HashMap<ConfigurationDescriptor, HashSet<LoadRequest>>)this.requestsByConnection.get(iConnection);
            if (hashMap == null) {
                hashMap = new HashMap<ConfigurationDescriptor, HashSet<LoadRequest>>();
                this.requestsByConnection.put(iConnection, hashMap);
            }
            if ((hashSet = (HashSet<LoadRequest>)hashMap.get(configurationDescriptor)) == null) {
                hashSet = new HashSet<LoadRequest>();
                hashMap.put(configurationDescriptor, hashSet);
            }
            hashSet.add(new LoadRequest(iConnection, iSharingDescriptor.getComponent(), iSharingDescriptor.getRootFolder(), true));
        }
    }

    public Collection getLoadRequests() {
        ArrayList arrayList = new ArrayList();
        for (HashMap hashMap : this.requestsByConnection.values()) {
            for (Set set : hashMap.values()) {
                arrayList.addAll(set);
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getLoadOverlaps() {
        return Collections.unmodifiableCollection(this.loadOverLaps);
    }

    public Collection getInvalidLoadRequests() {
        return Collections.unmodifiableCollection(this.invalidLoadRequests);
    }

    public void evaluateLoadRequests(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        HashMap hashMap = new HashMap();
        this.getElementsToLoad(hashMap, (IProgressMonitor)subMonitor.newChild(90));
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!hashMap.isEmpty()) {
            LoadOperation$1 loadOperation$1 = new LoadOperation$1(this);
            IVerifyInSyncOperation iVerifyInSyncOperation = this.getVerifyInSyncOperation(loadOperation$1);
            for (Map.Entry entry : hashMap.entrySet()) {
                iVerifyInSyncOperation.addToVerify((IConnection)entry.getValue(), (IShare)entry.getKey());
            }
            iVerifyInSyncOperation.run((IProgressMonitor)subMonitor.newChild(10));
        }
        subMonitor.done();
    }

    public void removeLoadRequests(Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (ILoadRequest iLoadRequest : collection) {
            Set set;
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iLoadRequest.getConnection(), iLoadRequest.getComponent());
            HashMap hashMap = (HashMap)this.requestsByConnection.get(iLoadRequest.getConnection());
            if (hashMap == null || (set = (Set)hashMap.get(configurationDescriptor)) == null) continue;
            set.remove(iLoadRequest);
            if (!set.isEmpty()) continue;
            hashMap.remove(configurationDescriptor);
            if (!hashMap.isEmpty()) continue;
            this.requestsByConnection.remove(iLoadRequest.getConnection());
        }
    }

    public Collection getSharesToBeRemoved() {
        return this.sharesToRemove.values();
    }

    public Collection getCollisions() {
        return Collections.unmodifiableCollection(this.collisions.values());
    }

    public Collection getNewSharesToLoad() {
        return Collections.unmodifiableCollection(this.newItems.values());
    }

    public Collection getSharesOutOfSync() {
        return Collections.unmodifiableCollection(this.sharesOutOfSync);
    }

    public Collection getConfigurationsToTrack() {
        HashSet hashSet = new HashSet();
        for (HashSet hashSet2 : this.configurationsToTrack.values()) {
            hashSet.addAll(hashSet2);
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public void removeConfigurationTrackingRequests(Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        block0: for (ConfigurationDescriptor configurationDescriptor : collection) {
            HashSet hashSet = (HashSet)this.configurationsToTrack.get(configurationDescriptor.connectionHandle.getItemId());
            if (hashSet == null) continue;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ConfigurationDescriptor configurationDescriptor2 = (ConfigurationDescriptor)iterator.next();
                if (!configurationDescriptor2.sameConfiguration(configurationDescriptor)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public void setSychronizationInfo(ISynchronizationInfo iSynchronizationInfo) {
        this.synchronizationInfo = iSynchronizationInfo;
    }

    protected final void doLoad(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
        ISchedulingRule iSchedulingRule = CopyFileAreaLockUtil.getCopyFileAreaLock(copyFileAreaStore, this.getAffectedConfigurations(), (IProgressMonitor)subMonitor.newChild(1));
        try {
            try {
                this.evaluateLoadRequests((IProgressMonitor)subMonitor.newChild(3));
                this.notifyDilemmaHandler((IProgressMonitor)subMonitor.newChild(1));
                this.trackComponents((IProgressMonitor)subMonitor.newChild(1));
                this.removeShares((IProgressMonitor)subMonitor.newChild(10));
                this.load((IProgressMonitor)subMonitor.newChild(83));
            }
            finally {
                copyFileAreaStore.sync();
            }
        }
        finally {
            copyFileAreaStore.release(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    protected final Collection getAffectedConfigurations() {
        HashSet hashSet = new HashSet();
        for (Cloneable cloneable : this.requestsByConnection.values()) {
            hashSet.addAll(cloneable.keySet());
        }
        for (Cloneable cloneable : this.configurationsToTrack.values()) {
            hashSet.addAll((Collection)((Object)cloneable));
        }
        return hashSet;
    }

    protected void notifyDilemmaHandler(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object3;
        int n;
        Object object22;
        int n2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + this.requestsByConnection.size()));
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!this.loadOverLaps.isEmpty()) {
            n2 = this.dilemmaHandler.overlappingLoadRequests(Collections.unmodifiableCollection(this.loadOverLaps));
            if (n2 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            if (n2 != 0) {
                object22 = new IStatus[this.loadOverLaps.size()];
                n = 0;
                for (Object object3 : this.loadOverLaps) {
                    String string = "";
                    if (!object3.getOverlappingShares().isEmpty()) {
                        string = NLS.bind((String)Messages.LoadOperation_1, (Object)PathUtils.getString(object3.getFolderPath()), (Object)object3.getOverlappingShares().size());
                    }
                    if (!object3.getOverlappingFolders().isEmpty()) {
                        string = NLS.bind((String)Messages.LoadOperation_2, (Object)PathUtils.getString(object3.getFolderPath()), (Object)object3.getOverlappingFolders().size());
                    }
                    object22[n] = new FileSystemStatus(4, string);
                    ++n;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_3, null);
                this.handleErrors(new IStatus[]{object3});
            }
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (!this.newItems.isEmpty()) {
            n2 = this.dilemmaHandler.newItemsToLoad(Collections.unmodifiableCollection(this.newItems.values()));
            if (n2 == 0) {
                for (Object object22 : this.newItems.values()) {
                    if (object22.willLoad()) continue;
                    this.treesToLoad.remove(object22.getLoadLocation().getShareName());
                }
            } else {
                if (n2 == 1) {
                    throw (Throwable)new OperationCanceledException();
                }
                object22 = new IStatus[this.newItems.size()];
                n = 0;
                for (Object object3 : this.newItems.values()) {
                    object22[n] = new FileSystemStatus(2, object3.getShareable().getLocalFullPath() + Messages.LoadOperation_4);
                    ++n;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_5, null);
                this.handleErrors(new IStatus[]{object3});
            }
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (this.collisions.size() > 0 || this.sharesToRemove.size() > 0) {
            n2 = this.dilemmaHandler.collision(Collections.unmodifiableCollection(this.collisions.values()), Collections.unmodifiableCollection(this.sharesToRemove.values()), Collections.unmodifiableCollection(this.sharesOutOfSync));
            if (n2 == 0) {
                object22 = this.collisions.values().toArray(new ICollision[this.collisions.size()]);
                int n3 = 0;
                while (n3 < ((Object)object22).length) {
                    object3 = (LoadLocation)object22[n3].getLoadLocation();
                    if (object3 != null) {
                        this.treesToLoad.put(((LoadLocation)object3).getShareName(), object3);
                    }
                    ++n3;
                }
            } else if (n2 != 1) {
                object22 = new IStatus[this.collisions.size() + this.sharesToRemove.size()];
                int n4 = 0;
                object3 = this.collisions.values().iterator();
                while (object3.hasNext()) {
                    object22[n4] = ((ICollision)object3.next()).getStatus();
                    ++n4;
                }
                for (Object object3 : this.sharesToRemove.values()) {
                    object22[n4] = new FileSystemStatus(2, NLS.bind((String)Messages.LoadOperation_0, (Object)object3.getShareableLocalPath()));
                    ++n4;
                }
                object3 = new MultiStatus("com.ibm.team.filesystem.client", 2, (IStatus[])object22, Messages.LoadOperation_7, null);
                this.handleErrors(new IStatus[]{object3});
            } else {
                throw (Throwable)new OperationCanceledException();
            }
        }
        if (subMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        if (this.invalidLoadRequests.size() > 0 && (n2 = this.dilemmaHandler.invalidLoadRequest(Collections.unmodifiableCollection(this.invalidLoadRequests))) != 0) {
            if (n2 == 1) {
                throw (Throwable)new OperationCanceledException();
            }
            object22 = new IStatus[this.invalidLoadRequests.size()];
            int n5 = 0;
            for (Object object3 : this.invalidLoadRequests) {
                object22[n5] = ((InvalidLoadRequest)object3).getStatus();
                ++n5;
            }
            object3 = new MultiStatus("com.ibm.team.filesystem.client", 4, (IStatus[])object22, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadRequests.size()), null);
            this.handleErrors(new IStatus[]{object3});
        }
        subMonitor.done();
    }

    protected abstract IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler var1);

    protected boolean maintainShareInfo() {
        return true;
    }

    private void removeShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.sharesToRemove.size());
        for (IRemovedShare iRemovedShare : this.sharesToRemove.values()) {
            Shareable shareable = (Shareable)iRemovedShare.getShareable();
            subMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_8, (Object)shareable.getLocalFullPath().toString()));
            if (iRemovedShare.isToBeDeleted()) {
                this.deleteShare(shareable, (IProgressMonitor)subMonitor.newChild(1));
            } else {
                shareable.unshare(null);
                subMonitor.worked(1);
            }
            if (!subMonitor.isCanceled()) continue;
            throw (Throwable)new OperationCanceledException();
        }
        subMonitor.done();
    }

    private void trackComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.configurationsToTrack.size() * 1));
        CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
        for (HashSet hashSet : this.configurationsToTrack.values()) {
            Object object;
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(hashSet.size() + 2);
            ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>(hashSet.size());
            IConnection iConnection = null;
            for (Object object2 : hashSet) {
                if (iConnection == null) {
                    iConnection = ((ConnectionDescriptor)object2).getConnection((IProgressMonitor)subMonitor2.newChild(1));
                }
                if (((ConfigurationDescriptor)object2).componentHandle.hasFullState()) {
                    object = new LoadedConfigurationDescriptor(iConnection, (IComponent)((ConfigurationDescriptor)object2).componentHandle);
                    copyFileAreaStore.componentLoaded((LoadedConfigurationDescriptor)object, (IProgressMonitor)subMonitor2.newChild(1));
                    continue;
                }
                arrayList.add(((ConfigurationDescriptor)object2).componentHandle);
            }
            if (!arrayList.isEmpty() && iConnection != null) {
                Object object2;
                object2 = iConnection.teamRepository().itemManager().fetchCompleteItems((List)arrayList, 0, (IProgressMonitor)subMonitor2.newChild(1));
                object = object2.iterator();
                while (object.hasNext()) {
                    IComponent iComponent = (IComponent)object.next();
                    LoadedConfigurationDescriptor loadedConfigurationDescriptor = new LoadedConfigurationDescriptor(iConnection, iComponent);
                    copyFileAreaStore.componentLoaded(loadedConfigurationDescriptor, (IProgressMonitor)subMonitor2.newChild(1));
                }
            }
            subMonitor2.done();
        }
        subMonitor.done();
    }

    protected void load(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.treesToLoad.size() * 3));
        subMonitor.setTaskName(Messages.LoadOperation_9);
        subMonitor.beginTask(Messages.LoadOperation_10, this.treesToLoad.size() * 3);
        HashMap<ConfigurationDescriptor, ArrayList<Object>> hashMap = new HashMap<ConfigurationDescriptor, ArrayList<Object>>();
        for (Object object : this.treesToLoad.values()) {
            ArrayList arrayList = (ArrayList)hashMap.get(((LoadLocation)object).getDescriptor());
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(((LoadLocation)object).getDescriptor(), arrayList);
            }
            arrayList.add(object);
        }
        int n = 1;
        for (Object object : hashMap.values()) {
            ILoadLocation iLoadLocation;
            LoadLocation loadLocation = (LoadLocation)((ArrayList)object).get(0);
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, ((ArrayList)object).size() * 2);
            IFileSystemManager iFileSystemManager = (IFileSystemManager)loadLocation.getDescriptor().getTeamRepository().getClientLibrary(IFileSystemManager.class);
            IConnection iConnection = loadLocation.getDescriptor().getConnection(null);
            FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)iFileSystemManager).getFileSystemService();
            subProgressMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_11, (Object[])new Object[]{iConnection.getName(), loadLocation.getComponent().getName(), n, hashMap.size()}));
            subMonitor.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)loadLocation.getComponent().getName()));
            IVersionableHandle[] iVersionableHandleArray = new IVersionableHandle[((ArrayList)object).size()];
            ArrayList<String[]> arrayList = new ArrayList<String[]>(((ArrayList)object).size());
            int n2 = 0;
            Object object2 = ((ArrayList)object).iterator();
            while (object2.hasNext()) {
                iLoadLocation = (ILoadLocation)object2.next();
                iVersionableHandleArray[n2] = ((LoadLocation)iLoadLocation).getFolder();
                arrayList.add(new String[]{iLoadLocation.getShareName()});
                ++n2;
            }
            iLoadLocation = fileSystemServiceProxy.getFileTreeByVersionable(iConnection, (IComponentHandle)loadLocation.getComponent(), iVersionableHandleArray, -1, true, this.synchronizationInfo, (IProgressMonitor)subMonitor.newChild(((ArrayList)object).size()));
            object2 = this.getLoadMutator(iConnection, (IComponentHandle)loadLocation.getComponent(), Arrays.asList(iVersionableHandleArray), arrayList, (LoadTree)iLoadLocation, this.dilemmaHandler);
            try {
                ((FileSystemOperation)object2).run((IProgressMonitor)subProgressMonitor);
            }
            finally {
                subProgressMonitor.done();
            }
            if (subMonitor.isCanceled()) {
                throw (Throwable)new OperationCanceledException();
            }
            ++n;
        }
        subMonitor.setTaskName(Messages.LoadOperation_13);
        subMonitor.done();
    }

    /*
     * WARNING - void declaration
     */
    private void getElementsToLoad(HashMap hashMap, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object322;
        Cloneable cloneable3;
        ArrayList<Object> arrayList;
        HashSet hashSet;
        IConnection iConnection;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 * (this.requestsByConnection.size() + this.configurationsToTrack.size())));
        subMonitor.setTaskName(Messages.LoadOperation_14);
        HashMap hashMap2 = this.organizeShares();
        HashMap<UUID, IComponent> hashMap3 = new HashMap<UUID, IComponent>();
        for (Map.Entry entry : this.configurationsToTrack.entrySet()) {
            iConnection = (IConnection)entry.getKey();
            hashSet = (HashSet)entry.getValue();
            arrayList = new ArrayList<Object>(hashSet.size());
            cloneable3 = new ArrayList(hashSet.size());
            for (Object object322 : hashSet) {
                cloneable2 = (HashMap)hashMap2.get(object322);
                if (cloneable2 == null) continue;
                cloneable = new ArrayList();
                for (IShare iShare : ((HashMap)cloneable2).values()) {
                    ((ArrayList)cloneable).add(iShare.getSharingDescriptor().getRootFolder());
                }
                arrayList.add(((ConfigurationDescriptor)object322).componentHandle);
                ((ArrayList)cloneable3).add(cloneable);
            }
            object322 = this.fetchCompleteItems(iConnection, arrayList, (ArrayList)cloneable3, subMonitor.newChild(100));
            for (Object object42 : hashSet) {
                cloneable = (HashMap)hashMap2.get(object42);
                if (cloneable == null) continue;
                Map map = (Map)object322.get(((ConfigurationDescriptor)object42).componentHandle.getItemId());
                if (map == null) {
                    Map map2 = Collections.EMPTY_MAP;
                }
                for (Map.Entry entry22 : ((HashMap)cloneable).entrySet()) {
                    void var16_20;
                    if (var16_20.get(entry22.getKey()) != null) continue;
                    object = (IShare)entry22.getValue();
                    this.sharesToRemove.put(object.getPath().toString(), new RemovedShare((IShare)object));
                }
            }
        }
        for (Map.Entry entry : this.requestsByConnection.entrySet()) {
            Object object2;
            Object object33;
            Object object4;
            Object object5;
            Object object62;
            Object object72;
            Object object82;
            Object object92;
            HashMap hashMap4;
            IComponent iComponent;
            Map.Entry entry22;
            Object object42;
            iConnection = subMonitor.newChild(100);
            hashSet = (IConnection)entry.getKey();
            arrayList = new ArrayList(((HashMap)entry.getValue()).size());
            cloneable3 = new HashMap();
            object322 = new HashMap();
            object42 = new ArrayList();
            cloneable2 = new ArrayList<IComponentHandle>();
            cloneable = new ArrayList();
            for (Map.Entry entry3 : ((HashMap)entry.getValue()).entrySet()) {
                iComponent = (ConfigurationDescriptor)entry3.getKey();
                cloneable2.add(iComponent.componentHandle);
                object = new ArrayList();
                ((ArrayList)cloneable).add(object);
                hashMap4 = new HashMap();
                ((HashMap)cloneable3).put(iComponent, hashMap4);
                for (Object object92 : (Set)entry3.getValue()) {
                    if (!hashMap3.containsKey(((LoadRequest)object92).getComponent().getItemId())) {
                        ((ArrayList)object42).add(((LoadRequest)object92).getComponent());
                    }
                    ((ArrayList)object).add(((LoadRequest)object92).getFolderToLoad());
                    hashMap4.put(((LoadRequest)object92).getFolderToLoad().getItemId(), object92);
                }
                object92 = (HashMap)hashMap2.get(iComponent);
                if (object92 == null) continue;
                for (Object object82 : ((HashMap)object92).values()) {
                    object72 = object82.getSharingDescriptor();
                    object62 = (LoadRequest)hashMap4.get(object72.getRootFolder().getItemId());
                    if (object62 != null) {
                        object62.setReloadRequest(true);
                        continue;
                    }
                    ((ArrayList)object).add(object72.getRootFolder());
                }
            }
            Map map = this.fetchCompleteItems((IConnection)hashSet, (ArrayList)cloneable2, (ArrayList)cloneable, iConnection.newChild(40));
            for (Map.Entry entry22 : ((HashMap)entry.getValue()).entrySet()) {
                object = (ConfigurationDescriptor)entry22.getKey();
                hashMap4 = (HashMap)((HashMap)cloneable3).get(object);
                object92 = (HashMap)hashMap2.get(object);
                object82 = (Map)map.get(((ConfigurationDescriptor)object).componentHandle.getItemId());
                if (object82 == null) continue;
                object5 = new HashMap();
                for (Object object72 : object82.values()) {
                    if (object72 == null) continue;
                    ((HashMap)object5).put(object72.getItemId(), object72);
                }
                ((HashMap)object322).put(object, object5);
                object72 = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
                object72.setContext(hashSet.getContextHandle());
                object72.setComponent(((ConfigurationDescriptor)object).componentHandle);
                int n = 0;
                for (Map.Entry entry4 : object82.entrySet()) {
                    Iterator iterator;
                    Object object10;
                    object4 = (UUID)entry4.getKey();
                    if (entry4.getValue() == null) {
                        object33 = (LoadRequest)hashMap4.get(object4);
                        if (object33 != null) {
                            hashMap4.remove(object4);
                            if (((LoadRequest)object33).isReloadRequest()) {
                                object10 = (IShare)((HashMap)object92).get(object4);
                                this.sharesToRemove.put(object10.getPath().toString(), new RemovedShare((IShare)object10));
                            } else {
                                object10 = new FileSystemStatus(2, Messages.LoadOperation_16);
                                iterator = new InvalidLoadRequest((ILoadRequest)object33, IInvalidLoadRequest$InvalidLoadRequestReason.NonExistantFolder, (IStatus)object10);
                                this.invalidLoadRequests.add(iterator);
                            }
                        } else {
                            object10 = (IShare)((HashMap)object92).get(object4);
                            this.sharesToRemove.put(object10.getPath().toString(), new RemovedShare((IShare)object10));
                        }
                    } else {
                        object33 = (IFolder)entry4.getValue();
                        object10 = new Path(object33.getName());
                        if (object10.segmentCount() != 1) {
                            iterator = (LoadRequest)hashMap4.get(object4);
                            hashMap4.remove(object4);
                            object2 = new FileSystemStatus(4, NLS.bind((String)Messages.LoadOperation_17, (Object)object33.getName()));
                            InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest((ILoadRequest)((Object)iterator), IInvalidLoadRequest$InvalidLoadRequestReason.InvalidProjectName, (IStatus)object2);
                            this.invalidLoadRequests.add(invalidLoadRequest);
                        } else {
                            object72.getGroup().add(object33);
                        }
                    }
                    ++n;
                }
                if (object72.getGroup().size() <= 1) continue;
                arrayList.add(object72);
            }
            if (!((ArrayList)object42).isEmpty()) {
                entry22 = hashSet.teamRepository().itemManager().fetchCompleteItems((List)object42, 0, (IProgressMonitor)iConnection.newChild(10));
                object = entry22.iterator();
                while (object.hasNext()) {
                    iComponent = (IComponent)object.next();
                    hashMap3.put(iComponent.getItemId(), iComponent);
                }
            }
            if (!arrayList.isEmpty()) {
                entry22 = (FileSystemManager)FileSystemCore.getFileSystemManager(hashSet.teamRepository());
                iComponent = ((FileSystemManager)((Object)entry22)).getFileSystemService();
                object = iComponent.detectOverlap(arrayList, null, (IProgressMonitor)iConnection.newChild(40));
                object92 = object.iterator();
                while (object92.hasNext()) {
                    hashMap4 = (OverlapResponse)object92.next();
                    object82 = new ConfigurationDescriptor((IConnection)hashSet, hashMap4.getComponent());
                    object5 = (HashMap)((HashMap)cloneable3).get(object82);
                    if (object5 == null) continue;
                    object72 = new HashMap();
                    for (Object object62 : hashMap4.getAncestorReports()) {
                        Iterator<Object> iterator = object62.getNameItemPairs();
                        ((HashMap)object72).put(((INameItemPair)iterator.get(iterator.size() - 1)).getItem().getItemId(), object62);
                    }
                    object62 = new HashMap();
                    for (OverlapDescription overlapDescription : hashMap4.getOverlapDescriptions()) {
                        object4 = overlapDescription.getElement();
                        for (Object object33 : overlapDescription.getOverlappedChildren()) {
                            this.recordOverlap((HashMap)object62, (IVersionableHandle)object4, (IVersionableHandle)object33);
                            this.recordOverlap((HashMap)object62, (IVersionableHandle)object33, (IVersionableHandle)object4);
                        }
                    }
                    for (Map.Entry entry5 : object62.entrySet()) {
                        object4 = (LoadRequest)((HashMap)object5).get(entry5.getKey());
                        if (object4 == null) continue;
                        ((HashMap)object5).remove(entry5.getKey());
                        object33 = new LoadOverlap((IConnection)hashSet, hashMap4.getComponent(), (IAncestorReport)((HashMap)object72).get(entry5.getKey()));
                        this.loadOverLaps.add(object33);
                        for (Object object10 : (Collection)entry5.getValue()) {
                            object2 = (HashMap)hashMap2.get(object82);
                            if (object2 != null && ((HashMap)object2).get(object10.getItemId()) != null) {
                                ((LoadOverlap)object33).addOverlappingShare((IShare)((HashMap)object2).get(object10.getItemId()));
                            }
                            ((LoadOverlap)object33).addOverlappingFolder((IAncestorReport)((HashMap)object72).get(object10.getItemId()));
                        }
                    }
                }
            }
            iConnection.setWorkRemaining(((HashMap)cloneable3).size());
            for (Map.Entry entry22 : ((HashMap)cloneable3).entrySet()) {
                object = (ConfigurationDescriptor)entry22.getKey();
                hashMap4 = iConnection.newChild(1);
                hashMap4.setWorkRemaining(((HashMap)entry22.getValue()).size());
                object82 = ((HashMap)entry22.getValue()).values().iterator();
                while (object82.hasNext()) {
                    object92 = (LoadRequest)object82.next();
                    object5 = (IFolder)((HashMap)((HashMap)object322).get(object)).get(((LoadRequest)object92).getFolderToLoad().getItemId());
                    if (object5 == null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    object72 = new LoadLocation((ConfigurationDescriptor)object, (IComponent)hashMap3.get(((LoadRequest)object92).getComponent().getItemId()), object5.getName(), ((LoadRequest)object92).getFolderToLoad());
                    this.checkForCollision((LoadLocation)object72, object5.getName(), hashMap, (IProgressMonitor)hashMap4.newChild(1));
                }
            }
        }
    }

    private Map fetchCompleteItems(IConnection iConnection, ArrayList arrayList, ArrayList arrayList2, SubMonitor subMonitor) throws TeamRepositoryException {
        HashMap<UUID, HashMap<UUID, IFolder>> hashMap;
        if (iConnection instanceof IWorkspaceConnection) {
            hashMap = ((IWorkspaceConnection)iConnection).configuration().fetchCompleteItems((List)arrayList, (List)arrayList2, (IProgressMonitor)subMonitor.newChild(10));
        } else {
            IConfiguration iConfiguration = ((IBaselineConnection)iConnection).configuration();
            if (arrayList.size() != 1) {
                throw (Throwable)new IllegalStateException("There should be just 1 component in a baseline connection");
            }
            List list = (List)arrayList2.get(0);
            List list2 = iConfiguration.fetchCompleteItems(list, (IProgressMonitor)subMonitor.newChild(10));
            Iterator iterator = list2.iterator();
            HashMap<UUID, IFolder> hashMap2 = new HashMap<UUID, IFolder>();
            hashMap = new HashMap<UUID, HashMap<UUID, IFolder>>(1);
            hashMap.put(iConfiguration.component().getItemId(), hashMap2);
            for (IVersionableHandle iVersionableHandle : list) {
                IFolder iFolder = (IFolder)iterator.next();
                hashMap2.put(iVersionableHandle.getItemId(), iFolder);
            }
        }
        return hashMap;
    }

    private void recordOverlap(HashMap hashMap, IVersionableHandle iVersionableHandle, IVersionableHandle iVersionableHandle2) {
        ArrayList<IVersionableHandle> arrayList = (ArrayList<IVersionableHandle>)hashMap.get(iVersionableHandle.getItemId());
        if (arrayList == null) {
            arrayList = new ArrayList<IVersionableHandle>();
            hashMap.put(iVersionableHandle.getItemId(), arrayList);
        }
        arrayList.add(iVersionableHandle2);
    }

    private HashMap organizeShares() throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> hashMap = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>>();
        IShare[] iShareArray = this.getAllShares();
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShare iShare = iShareArray[n2];
            if (iShare.getSharingDescriptor() != null) {
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
                HashMap<UUID, IShare> hashMap2 = (HashMap<UUID, IShare>)hashMap.get(configurationDescriptor);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<UUID, IShare>();
                    hashMap.put(configurationDescriptor, hashMap2);
                }
                hashMap2.put(iSharingDescriptor.getRootFolder().getItemId(), iShare);
            }
            ++n2;
        }
        return hashMap;
    }

    private void checkForCollision(LoadLocation loadLocation, String string, HashMap hashMap, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        Object object;
        Object object2;
        ICollision iCollision = this.checkForOverwrite(loadLocation, string);
        if (iCollision != null && iCollision.collidedWithExistingContent() && (object2 = iCollision.getShareable().getShare()) != null && (object = object2.getSharingDescriptor()).getConnectionHandle().sameItemId((IItemHandle)loadLocation.getDescriptor().connectionHandle) && object.getComponent().sameItemId((IItemHandle)loadLocation.getDescriptor().componentHandle)) {
            hashMap.put(object2, loadLocation.getDescriptor().getConnection(iProgressMonitor));
        }
        if (this.collisions.containsKey(string)) {
            object2 = (ICollision)this.collisions.get(string);
            object2.getLocations().add(loadLocation);
        } else if (this.treesToLoad.containsKey(string)) {
            object2 = new Collision(this.getShareable(string), loadLocation, false);
            object = (ILoadLocation)this.treesToLoad.remove(string);
            this.newItems.remove(string);
            ((Collision)object2).getLocations().add(object);
            this.collisions.put(string, object2);
        } else {
            object2 = this.checkForOverwrite(loadLocation, string);
            if (object2 != null) {
                this.collisions.put(string, object2);
            } else {
                this.treesToLoad.put(string, loadLocation);
                this.newItems.put(string, new ShareableToLoad(this.getShareable(string), loadLocation));
            }
        }
    }

    protected abstract FileSystemOperation getLoadMutator(IConnection var1, IComponentHandle var2, Collection var3, Collection var4, LoadTree var5, LoadDilemmaHandler var6) throws TeamRepositoryException;

    protected abstract IShareable getShareable(String var1);

    protected abstract boolean existsOnMirror(String var1);

    protected abstract void deleteShare(IShareable var1, IProgressMonitor var2) throws FileSystemClientException;

    protected abstract IShare[] getAllShares() throws FileSystemClientException;

    private ICollision checkForOverwrite(LoadLocation loadLocation, String string) throws TeamRepositoryException {
        if (this.existsOnMirror(string)) {
            IShareable iShareable = this.getShareable(string);
            return new Collision(iShareable, loadLocation, true);
        }
        return null;
    }

    protected abstract CopyFileAreaStore getCopyFileArea();
}

