/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreateBaselineOperation
extends ChangeHistoryChangeSetsOperation
implements ICreateBaselineOperation {
    private Map<ConfigurationDescriptor, CreateBaselineRequest> requests = new HashMap<ConfigurationDescriptor, CreateBaselineRequest>();
    private List<IBaselineConnection> baselines = new ArrayList<IBaselineConnection>();
    private CreateBaselineDilemmaHandler problemHandler;

    protected CreateBaselineOperation(CreateBaselineDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void createBaselineRequest(IWorkspaceConnection workspace, IComponentHandle componentHandle, String name, String comment) {
        if (workspace == null) {
            throw new IllegalArgumentException("missing workspace");
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException("missing component");
        }
        CreateBaselineRequest request = new CreateBaselineRequest();
        request.workspace = workspace;
        request.componentHandle = componentHandle;
        request.name = name;
        request.comment = comment;
        this.requests.put(new ConfigurationDescriptor((IConnection)workspace, componentHandle), request);
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CreateBaselineOperation_0, (int)(10 + 30 * this.requests.size()));
        ArrayList determinants = new ArrayList();
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        affectedConfigurations.addAll((Collection)this.requests.keySet());
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
            for (CreateBaselineRequest request : this.requests.values()) {
                this.baselines.add(request.workspace.createBaseline(request.componentHandle, request.name, request.comment, (IProgressMonitor)monitor.newChild(30)));
                this.checkCancelled((IProgressMonitor)monitor);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void runPreConditions(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = this.getVerifyOperation(this.problemHandler);
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify(configurationDescriptor.getConnection(null), configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)monitor.newChild(50));
        }
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, (IProgressMonitor)monitor.newChild(50));
        ArrayList<ConfigurationDescriptor> conflictedConfigurations = new ArrayList<ConfigurationDescriptor>();
        for (Map.Entry entry : this.requests.entrySet()) {
            CreateBaselineRequest request = (CreateBaselineRequest)entry.getValue();
            if (request.workspace.conflictReport(request.componentHandle).conflicts().isEmpty()) continue;
            conflictedConfigurations.add((ConfigurationDescriptor)entry.getKey());
        }
        if (!conflictedConfigurations.isEmpty()) {
            int n = this.problemHandler.conflictedConfigurations(conflictedConfigurations);
            if (n == 1) {
                throw new OperationCanceledException();
            }
            if (n == 0) {
                for (ConfigurationDescriptor configurationToSkip : conflictedConfigurations) {
                    this.requests.remove(configurationToSkip);
                }
            } else {
                throw new TeamRepositoryException(Messages.CreateBaselineOperation_1);
            }
        }
    }

    @Override
    public Collection<IBaselineConnection> getBaselinesCreated() {
        return this.baselines;
    }

    protected abstract IVerifyInSyncOperation getVerifyOperation(OutOfSyncDilemmaHandler var1);

    private class CreateBaselineRequest {
        IWorkspaceConnection workspace;
        IComponentHandle componentHandle;
        public String name;
        public String comment;

        private CreateBaselineRequest() {
        }
    }
}

