/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AcceptOperation$1;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AcceptOperation
extends FileSystemOperation
implements IAcceptOperation {
    private boolean preflight;
    ArrayList acceptRequests;
    private final AcceptDilemmaHandler problemHandler;

    public AcceptOperation(AcceptDilemmaHandler acceptDilemmaHandler) {
        super(acceptDilemmaHandler == null ? AcceptDilemmaHandler.getDefault() : acceptDilemmaHandler);
        this.problemHandler = acceptDilemmaHandler == null ? AcceptDilemmaHandler.getDefault() : acceptDilemmaHandler;
        this.acceptRequests = new ArrayList();
        this.preflight = false;
    }

    public void setPreflight(boolean bl) {
        this.preflight = bl;
    }

    public boolean isPreflightOnly() {
        return this.preflight;
    }

    public void acceptChangeSets(IWorkspaceConnection iWorkspaceConnection, List list) {
        this.acceptRequests.add(new OperationRequest(iWorkspaceConnection, list));
    }

    public void acceptCombined(IWorkspaceConnection iWorkspaceConnection, IChangeHistorySyncReport iChangeHistorySyncReport, List list, List list2) {
        this.acceptRequests.add(new OperationRequest(iWorkspaceConnection, iChangeHistorySyncReport, list, list2));
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.AcceptOperation_0, (int)(10 * this.acceptRequests.size()));
        ArrayList arrayList = new ArrayList();
        Collection collection = this.getAffectedConfigurations(this.acceptRequests, arrayList, (IProgressMonitor)subMonitor.newChild(this.acceptRequests.size()));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireWrite(collection, (Collection)arrayList);
        try {
            try {
                Object object3;
                Object object2;
                if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                    object2 = this.getVerifyOperation(this.problemHandler);
                    for (Object object3 : collection) {
                        object2.addToVerify(object3.getConnection(null), object3.componentHandle);
                    }
                    object2.run((IProgressMonitor)subMonitor.newChild(this.acceptRequests.size()));
                }
                object2 = new HashMap();
                object3 = null;
                for (Object object4 : this.acceptRequests) {
                    block22: {
                        if (!((OperationRequest)object4).getChangeSets().isEmpty() || !((OperationRequest)object4).getBaselines().isEmpty()) {
                            int n;
                            IUpdateReport iUpdateReport;
                            if (((OperationRequest)object4).getSyncReport() == null) {
                                try {
                                    int n2 = this.preflight ? 1 : 0;
                                    iUpdateReport = ((OperationRequest)object4).getWorkspace().accept(n2, ((OperationRequest)object4).getChangeSets(), (IProgressMonitor)subMonitor.newChild(4));
                                    this.holdUpdateReport((OperationRequest)object4, iUpdateReport, (HashMap)object2);
                                    break block22;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {
                                    n = this.problemHandler.acceptChangeSetsProblem(((OperationRequest)object4).getWorkspace(), ((OperationRequest)object4).getChangeSets(), teamRepositoryException);
                                    if (n == 1) {
                                        throw (Throwable)new OperationCanceledException();
                                    }
                                    if (n != 0) {
                                        object3 = teamRepositoryException;
                                        break;
                                    }
                                    break block22;
                                }
                            }
                            try {
                                iUpdateReport = ((OperationRequest)object4).getWorkspace().accept(this.preflight ? 1 : 0, ((OperationRequest)object4).getSyncReport(), ((OperationRequest)object4).getBaselines(), ((OperationRequest)object4).getChangeSets(), (IProgressMonitor)subMonitor.newChild(4));
                                this.holdUpdateReport((OperationRequest)object4, iUpdateReport, (HashMap)object2);
                            }
                            catch (TeamRepositoryException teamRepositoryException) {
                                n = this.problemHandler.acceptCombinedProblem(((OperationRequest)object4).getWorkspace(), ((OperationRequest)object4).getSyncReport(), ((OperationRequest)object4).getBaselines(), ((OperationRequest)object4).getChangeSets(), teamRepositoryException);
                                if (n == 1) {
                                    throw (Throwable)new OperationCanceledException();
                                }
                                if (n == 0) break block22;
                                object3 = teamRepositoryException;
                                break;
                            }
                        }
                    }
                    this.checkCancelled((IProgressMonitor)subMonitor);
                }
                if (!this.preflight) {
                    Object object4;
                    object4 = new AcceptOperation$1(this, (HashMap)object2);
                    this.runWithinFileSystemLock((IRunnableWithProgress)object4, (IProgressMonitor)subMonitor);
                }
                if (object3 != null) {
                    throw (Throwable)object3;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof TeamRepositoryException) {
                    throw throwable;
                }
                if (throwable instanceof FileSystemClientException) {
                    throw throwable;
                }
                throw (Throwable)new TeamRepositoryException(Messages.AcceptOperation_1, throwable);
            }
            catch (InterruptedException interruptedException) {
                throw (Throwable)new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    private void holdUpdateReport(OperationRequest operationRequest, IUpdateReport iUpdateReport, HashMap hashMap) {
        ArrayList<IUpdateReport> arrayList = (ArrayList<IUpdateReport>)hashMap.get(operationRequest.getWorkspace());
        if (arrayList == null) {
            arrayList = new ArrayList<IUpdateReport>();
            hashMap.put(operationRequest.getWorkspace(), arrayList);
        }
        arrayList.add(iUpdateReport);
    }

    protected void runWithinFileSystemLock(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iRunnableWithProgress.run(iProgressMonitor);
    }

    protected abstract UpdateOperation getUpdateOperation(IWorkspaceConnection var1, List var2, int var3, UpdateDilemmaHandler var4);

    protected abstract IVerifyInSyncOperation getVerifyOperation(OutOfSyncDilemmaHandler var1);

    static /* synthetic */ AcceptDilemmaHandler access$0(AcceptOperation acceptOperation) {
        return acceptOperation.problemHandler;
    }
}

