/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.osgi.util.NLS;

public class ContextNameUtil {
    public static String getContextName(IBaselineConnection baseline) {
        return ContextNameUtil.getContextName(baseline.getResolvedBaseline());
    }

    public static String getContextName(IBaseline baseline) {
        String name = baseline.getName();
        String id = "" + baseline.getId();
        if (name.length() > 0) {
            return NLS.bind((String)Messages.BaselineWrapper_baselineLabelFormat, (Object)id, (Object)name);
        }
        return id;
    }

    public static String getContextName(ITeamRepository repository) {
        return NLS.bind((String)Messages.ContextNameUtil_0, (Object)repository.getName());
    }

    public static String getContextName(IWorkspaceConnection workspace, IComponent component) {
        String componentName = component == null ? Messages.ContextNameUtil_4 : component.getName();
        return ContextNameUtil.getContextName(workspace, componentName);
    }

    public static String getContextName(IWorkspaceConnection workspace, String componentName) {
        if (workspace.isStream()) {
            return ContextNameUtil.getStreamContextName(workspace.getName(), componentName);
        }
        return ContextNameUtil.getWorkspaceContextName(workspace.getName(), componentName);
    }

    public static String getContextName(ISharingDescriptor descr) {
        if (descr.associatedWithWorkspace()) {
            return ContextNameUtil.getWorkspaceContextName(descr.getConnectionName(), descr.getComponentName());
        }
        return ContextNameUtil.getBaselineContextName(descr.getConnectionName());
    }

    public static String getStreamContextName(String workspaceName, String componentName) {
        return NLS.bind((String)Messages.ContextNameUtil_1, (Object)workspaceName, (Object)componentName);
    }

    public static String getWorkspaceContextName(String workspaceName, String componentName) {
        return NLS.bind((String)Messages.ContextNameUtil_2, (Object)workspaceName, (Object)componentName);
    }

    public static String getBaselineContextName(String baselineName) {
        return NLS.bind((String)Messages.ContextNameUtil_3, (Object)baselineName);
    }

    public static String getContextName(IConnection connection, IComponent component) {
        if (connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection wc = (IWorkspaceConnection)connection;
            return ContextNameUtil.getContextName(wc, component);
        }
        if (connection instanceof IBaselineConnection) {
            IBaselineConnection bc = (IBaselineConnection)connection;
            return ContextNameUtil.getContextName(bc);
        }
        throw new IllegalArgumentException("Unknown connection type");
    }
}

