/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemNamespace {
    private static ItemNamespace lastCreated;
    private static Object lastCreatedMutex;
    private static SoftValueMap<ItemNamespace, IItemContext> contextCache;

    static {
        lastCreatedMutex = new Object();
        contextCache = new SoftValueMap();
    }

    protected ItemNamespace() {
    }

    public abstract ITeamRepository getRepository();

    public abstract ItemId<IComponent> fetchComponentId(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract boolean hasConnection();

    public abstract IConnection getConnection(IProgressMonitor var1) throws TeamRepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ItemNamespace commonNamespace(ItemNamespace namespace) {
        Object object = lastCreatedMutex;
        synchronized (object) {
            ItemNamespace existing = lastCreated;
            if (existing == null || !namespace.equals(existing)) {
                existing = namespace;
            }
            lastCreated = existing;
            return existing;
        }
    }

    public abstract IContextHandle getContextHandle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IItemContext getContext(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext result;
        SoftValueMap<ItemNamespace, IItemContext> softValueMap = contextCache;
        synchronized (softValueMap) {
            result = (IItemContext)contextCache.get((Object)this);
            if (result != null) {
                return result;
            }
        }
        result = this.createContext(monitor);
        softValueMap = contextCache;
        synchronized (softValueMap) {
            contextCache.put((Object)this, (Object)result);
        }
        return result;
    }

    protected abstract IItemContext createContext(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract boolean hasVersionableTree();

    public abstract boolean handlesVersionables();

    public abstract boolean handlesAuditables();

    public abstract boolean handlesSimpleItems();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static ItemNamespace getNamespace(ITeamRepository repository, IContextHandle connectionHandle, IComponentHandle component) {
        if (connectionHandle instanceof IWorkspaceHandle) {
            return WorkspaceNamespace.create(repository, (IWorkspaceHandle)connectionHandle, component);
        }
        if (connectionHandle instanceof IBaselineHandle) {
            IBaselineHandle bh = (IBaselineHandle)connectionHandle;
            return BaselineNamespace.create(repository, bh);
        }
        throw new IllegalArgumentException("Unknown connection type in IComparableItem (this method is only prepared to deal with workspace and baseline connections");
    }

    public static ItemNamespace getNamespace(IConnection connection, IComponentHandle component) {
        if (connection instanceof IWorkspaceConnection) {
            return WorkspaceNamespace.create((IWorkspaceConnection)connection, component);
        }
        if (connection instanceof IBaselineConnection) {
            IBaselineConnection bc = (IBaselineConnection)connection;
            return BaselineNamespace.create(bc);
        }
        throw new IllegalArgumentException("Unknown connection type in IComparableItem (this method is only prepared to deal with workspace and baseline connections");
    }

    public boolean isEmpty() {
        return false;
    }
}

