/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree$IChangeType;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$1;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$DateRecord;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker$LocalChangesComputer;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class LocalChangeTracker {
    public static final Object CHANGES_COMPUTER_JOB_FAMILY = Messages.LocalChangeTracker_0;
    private static final long DELAY = 200000000L;
    private static final long DELAY_MS = 200L;
    private LocalChangeNotifier notifier;
    private LocalChangeContext context;
    private LocalChangeNode changeTree = new LocalChangeNode(null, null);
    private IVersionableTree versionableTree;
    private LocalChangeTracker$LocalChangesComputer computeChangesjob;
    private Map localChanges = new HashMap();
    private HashMap needDates = new HashMap();
    private final IPath copyFileAreaRoot;

    private static void setCounterpart(LocalMoveFrom localMoveFrom, LocalMoveTo localMoveTo) {
        localMoveFrom.setCounterpart(localMoveTo);
        localMoveTo.setCounterpart(localMoveFrom);
    }

    private static void setNode(LocalChangeNode localChangeNode, LocalChange localChange) {
        localChange.setNode(localChangeNode);
        localChangeNode.addChange(localChange);
    }

    public LocalChangeTracker(IPath iPath, IVersionableTree iVersionableTree, LocalChangeNotifier localChangeNotifier, LocalChangeContext localChangeContext, ISchedulingRule iSchedulingRule) {
        this.notifier = localChangeNotifier;
        this.context = localChangeContext;
        this.versionableTree = iVersionableTree;
        this.computeChangesjob = new LocalChangeTracker$LocalChangesComputer(this, iSchedulingRule);
        this.copyFileAreaRoot = iPath;
        this.computeChangesjob.requestRefresh();
    }

    public synchronized void cancelChanges(ILocalChange[] iLocalChangeArray) {
        ILocalChange[] iLocalChangeArray2 = this.forgetChanges(iLocalChangeArray);
        this.notifier.changesCanceled(this.context, iLocalChangeArray2);
    }

    public synchronized void cancelChanges(IShareable iShareable) {
        ILocalChange[] iLocalChangeArray = this.forgetChanges(iShareable);
        this.notifier.changesCanceled(this.context, iLocalChangeArray);
    }

    private void changeCanceled(LocalChange localChange) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeCanceled(this.context, localChange);
        }
    }

    private void changeOccurred(LocalChange localChange) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeOccurred(this.context, localChange);
        }
    }

    public synchronized void confirmChanges(ILocalChange[] iLocalChangeArray) {
        ILocalChange[] iLocalChangeArray2 = this.forgetChanges(iLocalChangeArray);
        this.notifier.changesConfirmed(this.context, iLocalChangeArray2);
    }

    private ILocalChange[] forgetChanges(ILocalChange[] iLocalChangeArray) {
        ArrayList<LocalChange> arrayList = new ArrayList<LocalChange>();
        int n = 0;
        while (n < iLocalChangeArray.length) {
            if (!iLocalChangeArray[n].isCanceled()) {
                LocalChange localChange = (LocalChange)iLocalChangeArray[n];
                arrayList.add(localChange);
                localChange.cancel();
                localChange.getNode().removeChange(localChange);
                this.localChanges.remove(localChange.getItemId());
            }
            ++n;
        }
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    private ILocalChange[] forgetChanges(IShareable iShareable) {
        LocalChangeNode localChangeNode = this.changeTree.getNode(iShareable.getLocalFullPath(), false);
        if (localChangeNode == null) {
            return new ILocalChange[0];
        }
        ArrayList arrayList = new ArrayList();
        localChangeNode.collect(arrayList);
        for (LocalChange localChange : arrayList) {
            localChange.cancel();
            this.localChanges.remove(localChange.getItemId());
        }
        this.clear(localChangeNode);
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    public synchronized ILocalChange getPendingChange(IVersionableHandle iVersionableHandle) {
        if (iVersionableHandle == null) {
            return NoOpChange.NO_OP;
        }
        LocalChange localChange = (LocalChange)this.localChanges.get(iVersionableHandle.getItemId());
        if (localChange == null) {
            return NoOpChange.NO_OP;
        }
        localChange.setWild();
        return localChange;
    }

    public ILocalChange[] getPendingChanges() {
        return this.getPendingChanges(false);
    }

    public synchronized ILocalChange[] getPendingChanges(boolean bl) {
        ILocalChange[] iLocalChangeArray;
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray = this.getPendingChanges(this.changeTree, bl);
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            ((LocalChange)iLocalChange).setWild();
            ++n2;
        }
        return iLocalChangeArray;
    }

    public synchronized ILocalChange[] getPendingChanges(IPath iPath, boolean bl) {
        ILocalChange[] iLocalChangeArray;
        LocalChangeNode localChangeNode = this.changeTree.getNode(iPath, false);
        if (localChangeNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray = this.getPendingChanges(localChangeNode, bl);
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            ((LocalChange)iLocalChange).setWild();
            ++n2;
        }
        return iLocalChangeArray;
    }

    public synchronized ILocalChange[] getPendingChangesAt(IPath iPath) {
        LocalChange[] localChangeArray;
        LocalChangeNode localChangeNode = this.changeTree.getNode(iPath, false);
        if (localChangeNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        LocalChange[] localChangeArray2 = localChangeArray = localChangeNode.getChanges().toArray(new LocalChange[localChangeNode.getChanges().size()]);
        int n = localChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalChange localChange = localChangeArray2[n2];
            localChange.setWild();
            ++n2;
        }
        return localChangeArray;
    }

    private ILocalChange[] getPendingChanges(LocalChangeNode localChangeNode, boolean bl) {
        Assert.isNotNull((Object)localChangeNode);
        ArrayList arrayList = new ArrayList();
        localChangeNode.collect(arrayList);
        if (bl) {
            for (LocalChange localChange : arrayList) {
                this.localChanges.remove(localChange.getItemId());
                localChange.cancel();
            }
            this.clear(localChangeNode);
        }
        return arrayList.toArray(new ILocalChange[arrayList.size()]);
    }

    public void trackFileAddition(IPath iPath, IFolderHandle iFolderHandle, IShareable iShareable, IProgressMonitor iProgressMonitor) {
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException(Messages.LocalChangeTracker_4);
        }
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.LocalChangeTracker_5, (Object)iPath));
        }
        if (iShareable != null && this.shouldTrackerIgnore(iShareable, null)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IVersionableHandle iVersionableHandle = this.versionableTree.getVersionableHandle(iPath);
        if (iVersionableHandle != null) {
            Assert.isTrue((iVersionableHandle.getItemType() == IFileItem.ITEM_TYPE ? 1 : 0) != 0);
        } else {
            iVersionableHandle = this.versionableTree.getDeletedVersionable(iFolderHandle, iPath.lastSegment(), (IProgressMonitor)subMonitor.newChild(50));
            if (iVersionableHandle == null || iVersionableHandle.getItemType() != IFileItem.ITEM_TYPE) {
                this.versionableTree.createVersionable(iPath, IFileItem.ITEM_TYPE, (IProgressMonitor)subMonitor.newChild(50));
            } else {
                this.versionableTree.restoreVersionable(iPath, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(50));
            }
        }
        subMonitor.done();
    }

    public void trackFileChange(IPath iPath, IFileItemHandle iFileItemHandle, IShareable iShareable) {
        Assert.isNotNull((Object)iPath);
        if (iShareable != null && this.shouldTrackerIgnore(iShareable, null)) {
            return;
        }
        if (iFileItemHandle == null) {
            Assert.isTrue((boolean)false, (String)(String.valueOf(iPath.toString()) + " cannot be null"));
        }
        this.versionableTree.trackFileChange((IVersionableHandle)iFileItemHandle, iPath);
    }

    public boolean shouldTrackerIgnore(IShareable iShareable, IProgressMonitor iProgressMonitor) {
        if (iShareable == null) {
            throw (Throwable)new IllegalArgumentException(Messages.LocalChangeTracker_7);
        }
        if (!iShareable.shouldBeIgnored()) {
            return false;
        }
        if (SharingManager.getInstance().getItemInfo(iShareable) != null) {
            return false;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            IFolderHandle iFolderHandle = (IFolderHandle)this.versionableTree.getVersionableHandle(iShareable.getLocalFullPath().removeLastSegments(1));
            IVersionableHandle iVersionableHandle = this.versionableTree.getDeletedVersionable(iFolderHandle, iShareable.getLocalFullPath().lastSegment(), null);
            boolean bl = iVersionableHandle == null;
            return bl;
        }
        finally {
            subMonitor.done();
        }
    }

    public void trackFileDeletion(IPath iPath, IFileItemHandle iFileItemHandle, IFolderHandle iFolderHandle, IShareable iShareable) {
    }

    public void trackFolderAddition(IPath iPath, IFolderHandle iFolderHandle, IShareable iShareable, IProgressMonitor iProgressMonitor) {
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException(Messages.LocalChangeTracker_8);
        }
        if (iFolderHandle == null) {
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.LocalChangeTracker_9, (Object)iPath));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IVersionableHandle iVersionableHandle = this.versionableTree.getVersionableHandle(iPath);
        if (iVersionableHandle != null) {
            Assert.isTrue((iVersionableHandle.getItemType() == IFolder.ITEM_TYPE ? 1 : 0) != 0);
        } else {
            iVersionableHandle = this.versionableTree.getDeletedVersionable(iFolderHandle, iPath.lastSegment(), (IProgressMonitor)subMonitor.newChild(50));
            if (iVersionableHandle == null || iVersionableHandle.getItemType() != IFolder.ITEM_TYPE) {
                this.versionableTree.createVersionable(iPath, IFolder.ITEM_TYPE, (IProgressMonitor)subMonitor.newChild(50));
            } else {
                this.versionableTree.restoreVersionable(iPath, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(50));
            }
        }
        subMonitor.done();
    }

    public void trackFolderDeletion(IPath iPath, IFolderHandle iFolderHandle, IFolderHandle iFolderHandle2, IShareable iShareable) {
    }

    public void trackMove(IPath iPath, IPath iPath2, IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle, IFolderHandle iFolderHandle2, IShareable iShareable) {
    }

    public void trackDeletion(IPath iPath, IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle, IShareable iShareable) throws FileSystemClientException {
        if (iVersionableHandle instanceof IFileItemHandle) {
            this.trackFileDeletion(iPath, (IFileItemHandle)iVersionableHandle, iFolderHandle, iShareable);
        } else if (iVersionableHandle instanceof IFolderHandle) {
            this.trackFolderDeletion(iPath, (IFolderHandle)iVersionableHandle, iFolderHandle, iShareable);
        } else {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalChangeTracker_10, (Object)iVersionableHandle.getClass().getSimpleName()))));
        }
    }

    public void trackAddition(IPath iPath, IFolderHandle iFolderHandle, Shareable shareable, IProgressMonitor iProgressMonitor) {
        if (shareable.getFileStorage().isFolder()) {
            this.trackFolderAddition(iPath, iFolderHandle, shareable, iProgressMonitor);
        } else {
            this.trackFileAddition(iPath, iFolderHandle, shareable, iProgressMonitor);
        }
    }

    private void clear(LocalChangeNode localChangeNode) {
        localChangeNode.prune();
    }

    public void syncChanges() {
        this.computeChangesjob.rejoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPendingChanges() throws FileSystemClientException {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<Object> arrayList;
        SharingManager sharingManager = SharingManager.getInstance();
        HashMap hashMap = new HashMap();
        while (true) {
            arrayList = this.needDates;
            synchronized (arrayList) {
                if (this.needDates.isEmpty()) {
                    break;
                }
                Iterator iterator = this.needDates.entrySet().iterator();
                object5 = iterator.next();
                iterator.remove();
            }
            arrayList = (LocalChangeTracker$DateRecord)object5.getKey();
            long l = (Long)object5.getValue();
            object4 = sharingManager.findShareable(this.copyFileAreaRoot, ((LocalChangeTracker$DateRecord)((Object)arrayList)).versionable, ((LocalChangeTracker$DateRecord)((Object)arrayList)).component, ((LocalChangeTracker$DateRecord)((Object)arrayList)).connection, null);
            if (object4 == null) continue;
            long l2 = ((Shareable)object4).getFileStorage().getLocalTimeStamp();
            if (l2 != l) {
                if (l2 >= l) continue;
                hashMap.put(arrayList, l);
                continue;
            }
            object3 = sharingManager.getItemInfo((IShareable)object4);
            Assert.isNotNull((Object)object3);
            Assert.isNotNull((Object)((FileItemInfo)object3).getHash());
            FileItemInfo fileItemInfo = new FileItemInfo(((FileItemInfo)object3).getVersionableHandle(), ((Shareable)object4).getFileStorage().getModificationStamp(), ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), ((FileItemInfo)object3).getHash(), ((FileItemInfo)object3).getContentLength(), ((FileItemInfo)object3).getOriginalLineDelimiter(), ((FileItemInfo)object3).getLineDelimiter(), ((FileItemInfo)object3).getOriginalContentType(), ((FileItemInfo)object3).getContentType(), ((FileItemInfo)object3).getStoredContentId(), ((FileItemInfo)object3).getStoredDeltaPredecessor(), ((FileItemInfo)object3).getStoredSize(), ((FileItemInfo)object3).getStoredEncoding(), ((FileItemInfo)object3).getStoredChecksum(), ((FileItemInfo)object3).getStoredNumLineDelimiters(), ((FileItemInfo)object3).isExecutable(), ((FileItemInfo)object3).isOriginalExecutable());
            SharingManager.getInstance().setItemInfo((IShareable)object4, fileItemInfo, null);
        }
        object5 = this.needDates;
        synchronized (object5) {
            this.needDates.putAll(hashMap);
        }
        object5 = this.versionableTree.getChangedItems();
        arrayList = new ArrayList<Object>(object5.size());
        HashSet<UUID> hashSet = new HashSet<UUID>();
        object4 = object5.iterator();
        block13: while (object4.hasNext()) {
            object22 = (IVersionableTree$IChangeType)object4.next();
            switch (object22.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    if (object22.getItem() instanceof IFolderHandle) {
                        arrayList.add(new LocalFolderDeletion(this.context, object22.getCurrentPath(), object22.getOriginalPath(), (IFolderHandle)object22.getItem(), object22.getPreviousParent()));
                    } else {
                        arrayList.add(new LocalFileDeletion(this.context, object22.getCurrentPath(), object22.getOriginalPath(), (IFileItemHandle)object22.getItem(), object22.getPreviousParent()));
                    }
                    hashSet.add(object22.getItem().getItemId());
                    break;
                }
                case 3: {
                    int n = 0;
                    if (object22.isContentChange()) {
                        n = 1;
                    }
                    if (object22.isFlagChange()) {
                        n |= 0x20;
                    }
                    object = new LocalMoveFrom(this.context, object22.getCurrentMovedFromPath(), object22.getOriginalPath(), object22.getItem(), object22.getPreviousParent(), n);
                    object3 = new LocalMoveTo(this.context, object22.getCurrentPath(), object22.getItem(), object22.getCurrentParent(), n);
                    LocalChangeTracker.setCounterpart((LocalMoveFrom)object, (LocalMoveTo)object3);
                    arrayList.add(object3);
                    hashSet.add(object22.getItem().getItemId());
                    break;
                }
                case 4: {
                    if (object22.getItem() instanceof IFolderHandle) {
                        arrayList.add(new LocalFolderAddition(this.context, object22.getCurrentPath(), (IFolderHandle)object22.getItem(), object22.getCurrentParent()));
                    } else {
                        arrayList.add(new LocalFileAddition(this.context, object22.getCurrentPath(), (IFileItemHandle)object22.getItem(), object22.getCurrentParent()));
                    }
                    hashSet.add(object22.getItem().getItemId());
                    break;
                }
                default: {
                    int n = 0;
                    if (object22.isContentChange()) {
                        n = 1;
                    }
                    if (object22.isFlagChange()) {
                        n |= 0x20;
                    }
                    if (n == 0) continue block13;
                    arrayList.add(new LocalFileChange(this.context, object22.getCurrentPath(), object22.getOriginalPath(), (IFileItemHandle)object22.getItem(), n));
                    hashSet.add(object22.getItem().getItemId());
                }
            }
        }
        object22 = this.localChanges.entrySet().iterator();
        while (object22.hasNext()) {
            object4 = (Map.Entry)object22.next();
            if (hashSet.contains(object4.getKey())) continue;
            ((LocalChange)object4.getValue()).cancel();
            ((LocalChange)object4.getValue()).getNode().removeChange((LocalChange)object4.getValue());
            this.changeCanceled((LocalChange)object4.getValue());
            object22.remove();
        }
        for (Object object22 : arrayList) {
            LocalChange localChange = (LocalChange)this.localChanges.get(((LocalChange)object22).getItemId());
            if (localChange != null) {
                if (((LocalChange)object22).equals(localChange)) continue;
                localChange.cancel();
                localChange.getNode().removeChange(localChange);
                this.changeCanceled(localChange);
            }
            if (!((LocalChange)object22).isType(8) && (object = ((LocalChange)object22).getShareable()) != null && object.shouldBeIgnored()) continue;
            object = this.changeTree.getNode(((LocalChange)object22).getPath(), true);
            LocalChangeTracker.setNode((LocalChangeNode)object, (LocalChange)object22);
            this.localChanges.put(((LocalChange)object22).getItemId(), object22);
            this.changeOccurred((LocalChange)object22);
        }
    }

    public void computePendingChanges(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<FileSystemClientException> arrayList = new ArrayList<FileSystemClientException>();
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(iShareable.getRoot());
        IShare iShare = iShareable.getShare();
        ISchedulingRule iSchedulingRule = copyFileAreaStore.lock(iShare.getSharingDescriptor().getComponent(), iShare.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(1));
        try {
            MultiStatus multiStatus;
            ArrayList<IShareable> arrayList2 = new ArrayList<IShareable>();
            arrayList2.add(iShareable);
            do {
                subMonitor.setWorkRemaining(99);
                multiStatus = new ArrayList();
                IShareable object = (IShareable)arrayList2.remove(arrayList2.size() - 1);
                object.accept((IShareableVisitor)new LocalChangeTracker$1(this, (List)multiStatus, copyFileAreaStore, arrayList2, arrayList), Integer.MAX_VALUE, true, true, (IProgressMonitor)subMonitor.newChild(68));
                SubMonitor subMonitor2 = subMonitor.newChild(10);
                subMonitor2.setWorkRemaining(multiStatus.size());
                for (IShareable iShareable2 : multiStatus) {
                    try {
                        copyFileAreaStore.deleteTreeInfo(iShareable2, false, (IProgressMonitor)subMonitor2.newChild(1));
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        arrayList.add(fileSystemClientException);
                    }
                }
                subMonitor2.done();
            } while (!arrayList2.isEmpty());
            if (!arrayList.isEmpty()) {
                multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.LocalChangeTracker_11, null);
                for (FileSystemClientException fileSystemClientException : arrayList) {
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
        }
        finally {
            copyFileAreaStore.release(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            this.computeChangesjob.requestRefresh();
            subMonitor.done();
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    public void metadataChanged() {
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatelessVersionable(long l, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            LocalChangeTracker$DateRecord localChangeTracker$DateRecord = new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle);
            this.needDates.remove(localChangeTracker$DateRecord);
            this.needDates.put(localChangeTracker$DateRecord, l);
        }
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDatelessVersionable(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            LocalChangeTracker$DateRecord localChangeTracker$DateRecord = new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle);
            this.needDates.remove(localChangeTracker$DateRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatelessVersionable(long l, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        Long l2;
        HashMap hashMap = this.needDates;
        synchronized (hashMap) {
            l2 = (Long)this.needDates.get(new LocalChangeTracker$DateRecord(iVersionableHandle, iComponentHandle, iContextHandle));
        }
        return l2 != null && l2 == l;
    }

    static /* synthetic */ IVersionableTree access$0(LocalChangeTracker localChangeTracker) {
        return localChangeTracker.versionableTree;
    }

    static /* synthetic */ void access$1(LocalChangeTracker localChangeTracker) throws FileSystemClientException {
        localChangeTracker.refreshPendingChanges();
    }
}

