/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier$1;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier$2;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier$ChangeGeneration;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier$Event;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class LocalChangeNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 1000;
    private volatile long latestRequest;
    private static final ThreadLocal changeNotification = new LocalChangeNotifier$1();
    private static final boolean DEBUG_EVENTS = System.getProperty("filesystem.debug.localChangeEvents", "false").equals("true");
    private ListenerList listeners = new ListenerList();
    private LocalChangeNotifier$ChangeGeneration collectedChanges = new LocalChangeNotifier$ChangeGeneration();

    public static void disableChangeNotification() {
        changeNotification.set(new Integer((Integer)changeNotification.get() + 1));
    }

    public static void enableChangeNotification() {
        int n = (Integer)changeNotification.get();
        if (n == 0) {
            throw (Throwable)new IllegalStateException();
        }
        changeNotification.set(new Integer(n - 1));
    }

    public static boolean isChangeNotificationEnabled() {
        return (Integer)changeNotification.get() == 0;
    }

    public LocalChangeNotifier() {
        super(Messages.LocalChangeNotifier_9);
        this.setSystem(true);
        this.setUser(false);
    }

    public void addListener(ILocalChangeListener iLocalChangeListener) {
        this.listeners.add((Object)iLocalChangeListener);
    }

    public synchronized void changesCanceled(LocalChangeContext localChangeContext, ILocalChange[] iLocalChangeArray) {
        if (iLocalChangeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iLocalChangeArray.length) {
            if ((!this.collectedChanges.removeChange(localChangeContext, iLocalChangeArray[n], 1) || ((LocalChange)iLocalChangeArray[n]).isWild()) && LocalChangeNotifier.isChangeNotificationEnabled()) {
                this.collectedChanges.addChange(localChangeContext, iLocalChangeArray[n], 2);
            }
            ++n;
        }
        if (LocalChangeNotifier.isChangeNotificationEnabled()) {
            this.scheduleNotification();
        }
    }

    public synchronized void changeCanceled(LocalChangeContext localChangeContext, ILocalChange iLocalChange) {
        if (this.collectedChanges.removeChange(localChangeContext, iLocalChange, 1) && !((LocalChange)iLocalChange).isWild()) {
            return;
        }
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        this.collectedChanges.addChange(localChangeContext, iLocalChange, 2);
        this.scheduleNotification();
    }

    public synchronized void changesConfirmed(LocalChangeContext localChangeContext, ILocalChange[] iLocalChangeArray) {
        if (iLocalChangeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iLocalChangeArray.length) {
            this.collectedChanges.removeChange(localChangeContext, iLocalChangeArray[n], 1);
            if (LocalChangeNotifier.isChangeNotificationEnabled()) {
                this.collectedChanges.addChange(localChangeContext, iLocalChangeArray[n], 3);
            }
            ++n;
        }
        if (LocalChangeNotifier.isChangeNotificationEnabled()) {
            this.scheduleNotification();
        }
    }

    public synchronized void changeOccurred(LocalChangeContext localChangeContext, ILocalChange iLocalChange) {
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        this.collectedChanges.removeChange(localChangeContext, iLocalChange, 2);
        this.collectedChanges.addChange(localChangeContext, iLocalChange, 1);
        this.scheduleNotification();
    }

    public synchronized void changesOccurred(LocalChangeContext localChangeContext, ILocalChange[] iLocalChangeArray) {
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        if (iLocalChangeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iLocalChangeArray.length) {
            this.collectedChanges.removeChange(localChangeContext, iLocalChangeArray[n], 2);
            this.collectedChanges.addChange(localChangeContext, iLocalChangeArray[n], 1);
            ++n;
        }
        this.scheduleNotification();
    }

    private synchronized LocalChangeNotifier$ChangeGeneration collectChanges() {
        if (!this.collectedChanges.hasChanges()) {
            return null;
        }
        LocalChangeNotifier$ChangeGeneration localChangeNotifier$ChangeGeneration = this.collectedChanges;
        this.collectedChanges = new LocalChangeNotifier$ChangeGeneration();
        return localChangeNotifier$ChangeGeneration;
    }

    private void notify(IProgressMonitor iProgressMonitor, LocalChangeNotifier$ChangeGeneration localChangeNotifier$ChangeGeneration, Object[] objectArray) {
        try {
            iProgressMonitor.beginTask(Messages.LocalChangeNotifier_10, objectArray.length);
            LocalChangeNotifier$Event localChangeNotifier$Event = new LocalChangeNotifier$Event(localChangeNotifier$ChangeGeneration);
            if (DEBUG_EVENTS) {
                System.out.println(new Date() + "\n" + localChangeNotifier$Event);
            }
            int n = 0;
            while (n < objectArray.length) {
                if (iProgressMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                ILocalChangeListener iLocalChangeListener = (ILocalChangeListener)objectArray[n];
                SafeRunner.run((ISafeRunnable)new LocalChangeNotifier$2(this, iLocalChangeListener, localChangeNotifier$Event));
                iProgressMonitor.worked(1);
                ++n;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void removeListener(ILocalChangeListener iLocalChangeListener) {
        this.listeners.remove((Object)iLocalChangeListener);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        LocalChangeNotifier$ChangeGeneration localChangeNotifier$ChangeGeneration;
        if (System.currentTimeMillis() - this.latestRequest < 1000L) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        Job[] jobArray = Job.getJobManager().find(LocalChangeTracker.CHANGES_COMPUTER_JOB_FAMILY);
        int n = 0;
        while (n < jobArray.length) {
            int n2 = jobArray[n].getState();
            if (n2 == 4 || n2 == 2 || n2 == 1) {
                this.schedule(1000L);
                return Status.CANCEL_STATUS;
            }
            ++n;
        }
        if (!LocalChangeManager.getInstance().isNotificationEnabled()) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        while ((localChangeNotifier$ChangeGeneration = this.collectChanges()) != null) {
            subMonitor.setWorkRemaining(2);
            this.notify((IProgressMonitor)subMonitor.newChild(1), localChangeNotifier$ChangeGeneration, this.listeners.getListeners());
        }
        subMonitor.done();
        return Status.OK_STATUS;
    }

    void scheduleNotification() {
        this.latestRequest = System.currentTimeMillis();
        this.schedule(1000L);
    }
}

