/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public abstract class LocalChange
implements ILocalChange {
    private boolean canceled;
    private boolean inTheWild;
    protected LocalChangeNode node;
    protected IVersionableHandle target;
    protected IFolderHandle targetParent;
    protected IPath path;
    protected IPath originalPath;
    protected LocalChangeContext context;

    public LocalChange(LocalChangeContext localChangeContext, IPath iPath, IPath iPath2, IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle) {
        this.validateTarget(iVersionableHandle);
        this.validateTargetParent(iFolderHandle);
        this.context = localChangeContext;
        this.path = iPath;
        this.originalPath = iPath2;
        this.target = iVersionableHandle;
        this.targetParent = iFolderHandle;
    }

    protected void validateTarget(IVersionableHandle iVersionableHandle) {
        Assert.isNotNull((Object)iVersionableHandle);
        Assert.isTrue((!iVersionableHandle.hasFullState() ? 1 : 0) != 0);
        this.validateTargetState(iVersionableHandle);
    }

    protected void validateTargetParent(IFolderHandle iFolderHandle) {
        Assert.isNotNull((Object)iFolderHandle);
        Assert.isTrue((!iFolderHandle.hasFullState() ? 1 : 0) != 0);
        this.validateTargetParentState(iFolderHandle);
    }

    protected void validateTargetState(IVersionableHandle iVersionableHandle) {
        Assert.isTrue((boolean)iVersionableHandle.hasStateId());
    }

    protected void validateTargetParentState(IFolderHandle iFolderHandle) {
        Assert.isTrue((boolean)iFolderHandle.hasStateId());
    }

    final void cancel() {
        this.canceled = true;
        LocalChange localChange = (LocalChange)this.getCounterpart();
        if (localChange != null) {
            localChange.canceled = true;
        }
    }

    final boolean isWild() {
        return this.inTheWild;
    }

    final void setWild() {
        this.inTheWild = true;
    }

    public IComponentHandle getComponent() {
        return this.context == null ? null : this.context.getComponent();
    }

    public ILocalChange getCounterpart() {
        return null;
    }

    final UUID getItemId() {
        return this.target == null ? null : this.target.getItemId();
    }

    LocalChangeNode getNode() {
        return this.node;
    }

    public final IPath getPath() {
        return this.path;
    }

    public IPath getResultingPath() {
        return this.path;
    }

    public IPath getOriginalPath() {
        return this.originalPath;
    }

    public IShareable getShareable() throws FileSystemClientException {
        return LocalChangeManager.getInstance().getShareable(this);
    }

    public final IVersionableHandle getTarget() {
        return this.target;
    }

    public IContextHandle getConnection() {
        return this.context == null ? null : this.context.getConnection();
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public boolean isType(int n) {
        return (this.getType() & n) == n;
    }

    void setNode(LocalChangeNode localChangeNode) {
        this.node = localChangeNode;
    }

    public int hashCode() {
        int n = this.originalPath == null ? 0 : this.originalPath.hashCode();
        return this.target.getItemId().hashCode() ^ this.path.hashCode() ^ n ^ this.getType();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LocalChange)) {
            return false;
        }
        LocalChange localChange = (LocalChange)object;
        if (this.originalPath == null ? localChange.originalPath != null : !this.originalPath.equals((Object)localChange.originalPath)) {
            return false;
        }
        return this.canceled == localChange.canceled && LocalChange.equals(this.target, localChange.target) && LocalChange.equals((IVersionableHandle)this.targetParent, (IVersionableHandle)localChange.targetParent) && this.path.equals((Object)localChange.path) && this.getType() == localChange.getType() && this.context == localChange.context;
    }

    private static boolean equals(IVersionableHandle iVersionableHandle, IVersionableHandle iVersionableHandle2) {
        if (iVersionableHandle == iVersionableHandle2) {
            return true;
        }
        if (iVersionableHandle == null || iVersionableHandle2 == null) {
            return false;
        }
        if (!iVersionableHandle.sameItemId((IItemHandle)iVersionableHandle2)) {
            return false;
        }
        if (iVersionableHandle.hasStateId() != iVersionableHandle2.hasStateId()) {
            return false;
        }
        return !iVersionableHandle.hasStateId() || iVersionableHandle.sameStateId((IItemHandle)iVersionableHandle2);
    }

    public String toString() {
        return String.valueOf(this.getTypeString()) + " " + this.path + " " + this.getItemId();
    }

    private String getTypeString() {
        String string;
        switch (this.getType()) {
            case 2: {
                string = "ADDITION";
                break;
            }
            case 16: {
                string = "MOVE_FROM";
                break;
            }
            case 8: {
                string = "MOVE_TO";
                break;
            }
            case 17: {
                string = "MOVE_FROM (content)";
                break;
            }
            case 49: {
                string = "MOVE_FROM (content + attributes)";
                break;
            }
            case 48: {
                string = "MOVE_FROM (attributes)";
                break;
            }
            case 9: {
                string = "MOVE_TO (content)";
                break;
            }
            case 41: {
                string = "MOVE_TO (content + attributes)";
                break;
            }
            case 40: {
                string = "MOVE_TO (attributes)";
                break;
            }
            case 4: {
                string = "DELETION";
                break;
            }
            case 1: {
                string = "CONTENT";
                break;
            }
            case 33: {
                string = "CONTENT + ATTRIBUTES";
                break;
            }
            case 32: {
                string = "ATTRIBUTES";
                break;
            }
            case 0: {
                return "NO_CHANGE";
            }
            default: {
                string = "UNKNOWN(" + this.getType() + ")";
            }
        }
        if (this.isCanceled()) {
            string = String.valueOf(string) + " (canceled)";
        }
        return string;
    }

    public IFolderHandle getTargetParent() {
        return this.targetParent;
    }
}

