/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateOrder {
    private Collection adds;
    private Collection deletes;
    private HashMap orderedAdds;
    private Collection moves;
    private Collection modifies;

    public UpdateOrder(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        this.adds = collection;
        this.deletes = collection2;
        this.moves = collection3;
        this.modifies = collection4;
    }

    public List getOrderedDeletes() {
        HashMap hashMap = this.group(this.deletes);
        ArrayList arrayList = new ArrayList(this.deletes.size());
        for (List list : hashMap.values()) {
            HashMap<UUID, ArrayList<FileAreaUpdate>> hashMap2 = new HashMap<UUID, ArrayList<FileAreaUpdate>>();
            for (FileAreaUpdate fileAreaUpdate : list) {
                UUID uUID = fileAreaUpdate.getSourceParent().getItemId();
                ArrayList<FileAreaUpdate> arrayList2 = (ArrayList<FileAreaUpdate>)hashMap2.get(uUID);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<FileAreaUpdate>();
                    hashMap2.put(uUID, arrayList2);
                }
                arrayList2.add(fileAreaUpdate);
            }
            arrayList.addAll(this.calculateOrdering(hashMap2));
        }
        return arrayList;
    }

    public List getFolderAdds() {
        if (this.orderedAdds == null) {
            this.calculateOrderedAdds();
        }
        ArrayList<FileAreaUpdate> arrayList = new ArrayList<FileAreaUpdate>();
        for (List list : this.orderedAdds.values()) {
            for (FileAreaUpdate fileAreaUpdate : list) {
                if (!(fileAreaUpdate.getItem() instanceof IFolderHandle)) continue;
                arrayList.add(fileAreaUpdate);
            }
        }
        return arrayList;
    }

    public List getFileAdds() {
        if (this.orderedAdds == null) {
            this.calculateOrderedAdds();
        }
        ArrayList<FileAreaUpdate> arrayList = new ArrayList<FileAreaUpdate>();
        for (List list : this.orderedAdds.values()) {
            for (FileAreaUpdate fileAreaUpdate : list) {
                if (!(fileAreaUpdate.getItem() instanceof IFileItemHandle)) continue;
                arrayList.add(fileAreaUpdate);
            }
        }
        return arrayList;
    }

    public List getFolderMoves() {
        ArrayList<FileAreaUpdate> arrayList = new ArrayList<FileAreaUpdate>();
        for (FileAreaUpdate fileAreaUpdate : this.moves) {
            if (!(fileAreaUpdate.getItem() instanceof IFolderHandle)) continue;
            arrayList.add(fileAreaUpdate);
        }
        return arrayList;
    }

    public List getFileMoves() {
        ArrayList<FileAreaUpdate> arrayList = new ArrayList<FileAreaUpdate>();
        for (FileAreaUpdate fileAreaUpdate : this.moves) {
            if (!(fileAreaUpdate.getItem() instanceof IFileItemHandle)) continue;
            arrayList.add(fileAreaUpdate);
        }
        return arrayList;
    }

    public List getGroupedModifies() {
        HashMap hashMap = this.group(this.modifies);
        ArrayList arrayList = new ArrayList(this.modifies.size());
        for (List list : hashMap.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private HashMap group(Collection collection) {
        HashMap<UUID, ArrayList<FileAreaUpdate>> hashMap = new HashMap<UUID, ArrayList<FileAreaUpdate>>();
        for (FileAreaUpdate fileAreaUpdate : collection) {
            ArrayList<FileAreaUpdate> arrayList = (ArrayList<FileAreaUpdate>)hashMap.get(fileAreaUpdate.component().getItemId());
            if (arrayList == null) {
                arrayList = new ArrayList<FileAreaUpdate>();
                hashMap.put(fileAreaUpdate.component().getItemId(), arrayList);
            }
            arrayList.add(fileAreaUpdate);
        }
        return hashMap;
    }

    private void calculateOrderedAdds() {
        HashMap hashMap = this.group(this.adds);
        this.orderedAdds = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList2;
            HashMap<UUID, ArrayList<ArrayList>> hashMap2 = new HashMap<UUID, ArrayList<ArrayList>>();
            for (ArrayList arrayList2 : (List)entry.getValue()) {
                ArrayList<ArrayList> arrayList3 = (ArrayList<ArrayList>)hashMap2.get(arrayList2.getDestinationParent().getItemId());
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<ArrayList>();
                    hashMap2.put(arrayList2.getDestinationParent().getItemId(), arrayList3);
                }
                arrayList3.add(arrayList2);
            }
            arrayList2 = this.calculateOrdering(hashMap2);
            Collections.reverse(arrayList2);
            this.orderedAdds.put((UUID)entry.getKey(), arrayList2);
        }
    }

    private ArrayList calculateOrdering(HashMap hashMap) {
        ArrayList arrayList = new ArrayList();
        while (!hashMap.isEmpty()) {
            Object k = hashMap.keySet().iterator().next();
            List list = (List)hashMap.get(k);
            this.orderChildrenFirst(list, hashMap, arrayList);
            hashMap.remove(k);
        }
        return arrayList;
    }

    private void orderChildrenFirst(List list, HashMap hashMap, List list2) {
        for (FileAreaUpdate fileAreaUpdate : list) {
            List list3 = (List)hashMap.get(fileAreaUpdate.getItem().getItemId());
            if (list3 != null) {
                this.orderChildrenFirst(list3, hashMap, list2);
            }
            list2.add(fileAreaUpdate);
            hashMap.remove(fileAreaUpdate.getItem().getItemId());
        }
    }
}

