/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator$ShareReference;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class UpdateMutator
extends FileSystemOperation {
    private final FileAreaUpdateReport updates;
    protected final ITeamRepository repository;
    private final IConnection connection;
    protected final IContextHandle connectionHandle;
    protected IContentManagerSession contentSession;
    private IComponentHandle lastComponent;
    private String lastPath;
    private boolean lastNewProjectAllowed;
    private boolean lastResult;
    private boolean lastComponentSharedResult;
    private IComponent lastComponentShareTested;
    private Set versionablesToSkip = new HashSet();
    private HashSet inconsistentShares = new HashSet();
    private HashSet newShares = new HashSet();
    private HashMap componentStatesBefore;
    private HashMap componentStatesAfter;
    private HashSet componentNotShared;
    private HashMap shareParents;
    private HashMap failedUpdates;

    public UpdateMutator(ITeamRepository iTeamRepository, IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, DilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
        if (iTeamRepository == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.repository = iTeamRepository;
        if (iConnection instanceof IWorkspaceConnection) {
            this.connectionHandle = (IContextHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace();
        } else if (iConnection instanceof IBaselineConnection) {
            this.connectionHandle = (IContextHandle)((IBaselineConnection)iConnection).getBaseline();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connection = iConnection;
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.componentStatesBefore = new HashMap();
        for (IComponentStateSummary iComponentStateSummary : collection) {
            this.componentStatesBefore.put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary);
        }
        this.componentStatesAfter = new HashMap();
        for (IComponentStateSummary iComponentStateSummary : collection2) {
            this.componentStatesAfter.put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary);
        }
        this.componentNotShared = new HashSet();
        this.shareParents = new HashMap();
        for (IComponentStateSummary iComponentStateSummary : fileAreaUpdateReport.getShareParents()) {
            HashSet<UUID> hashSet = (HashSet<UUID>)this.shareParents.get(iComponentStateSummary.getComponent().getItemId());
            if (hashSet == null) {
                hashSet = new HashSet<UUID>();
                this.shareParents.put(iComponentStateSummary.getComponent().getItemId(), hashSet);
            }
            hashSet.add(iComponentStateSummary.getVersionable().getItemId());
        }
        this.updates = fileAreaUpdateReport;
        this.failedUpdates = new HashMap();
    }

    protected abstract CopyFileAreaStore getCopyFileArea();

    protected abstract Shareable getRootFolder(String var1);

    protected abstract void preserve(IComponent var1, Shareable var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void createFile(IComponent var1, DeferredDownloadInformation var2, Shareable var3, IProgressMonitor var4) throws TeamRepositoryException, FileSystemClientException;

    protected abstract void createFolder(IComponent var1, IFolderHandle var2, Shareable var3, String var4, IFolderHandle var5, IProgressMonitor var6) throws TeamRepositoryException, FileSystemClientException;

    protected abstract void modifyFile(IComponent var1, DeferredDownloadInformation var2, Shareable var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void move(IComponent var1, IComponentHandle var2, Shareable var3, Shareable var4, IFolderHandle var5, String var6, IVersionableHandle var7, IProgressMonitor var8) throws FileSystemClientException, TeamRepositoryException;

    protected abstract Shareable getShareableFor(IPath var1, boolean var2);

    protected abstract void deleteSubtree(IComponent var1, Shareable var2, IProgressMonitor var3) throws FileSystemClientException;

    private final void createFile(IComponent iComponent, FileAreaUpdate fileAreaUpdate, DeferredDownloadInformation deferredDownloadInformation, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Shareable shareable;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        String string = deferredDownloadInformation.getName();
        IFileItemHandle iFileItemHandle = deferredDownloadInformation.getFileItem();
        IFolderHandle iFolderHandle = deferredDownloadInformation.getParent();
        if (!this.isComponentShared(iComponent)) {
            return;
        }
        if (this.skipUpdate(iFileItemHandle.getItemId())) {
            return;
        }
        String string2 = string;
        if (this.isShareParent(iComponent, iFolderHandle)) {
            return;
        }
        IPath iPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
        Shareable shareable2 = this.getShareableFor(iPath, true);
        if (shareable2 == null || !shareable2.isLocal()) {
            if (iPath == null) {
                iPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
            }
            if (iPath != null) {
                string2 = iPath.append(string).toString();
                this.recordInconsistentShare((IComponentHandle)iComponent, iPath.segment(0));
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)string2, (Object)iComponent.getName())));
            } else {
                this.failedUpdate(fileAreaUpdate);
            }
            return;
        }
        string2 = iPath.append(string).toString();
        if (!this.isPathValid((IComponentHandle)iComponent, shareable2.getLocalFullPath(), false)) {
            this.recordInconsistentShare((IComponentHandle)iComponent, shareable2.getLocalFullPath().segment(0));
            this.collectStatus(new FileSystemStatus(2, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)string2, (Object)iComponent.getName())));
            return;
        }
        IFileStorage iFileStorage = shareable2.getFileStorage().getChild(string);
        if (iFileStorage != null && !iFileItemHandle.sameItemId((IItemHandle)iFileStorage.getRemote())) {
            this.handleCollision(iComponent, iFileStorage.getShareable(), (IProgressMonitor)subMonitor.newChild(25));
        }
        if ((shareable = (Shareable)FileSystemCore.getSharingManager().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)iFileItemHandle, (IComponentHandle)iComponent, this.connectionHandle, null)) != null && shareable.isLocal()) {
            IFileStorage iFileStorage2 = shareable.getFileStorage().getParent();
            if (!iFolderHandle.sameItemId((IItemHandle)iFileStorage2.getRemote()) || !string.equals(shareable.getLocalFullPath().lastSegment())) {
                this.move(iComponent, (IComponentHandle)iComponent, shareable, shareable2, iFolderHandle, string, (IVersionableHandle)iFileItemHandle, (IProgressMonitor)subMonitor.newChild(25));
                shareable = (Shareable)FileSystemCore.getSharingManager().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)iFileItemHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
            }
            subMonitor.setWorkRemaining(100);
            this.modifyFile(iComponent, deferredDownloadInformation, shareable, (IProgressMonitor)subMonitor.newChild(100));
        } else {
            subMonitor.setWorkRemaining(100);
            this.createFile(iComponent, deferredDownloadInformation, shareable2, (IProgressMonitor)subMonitor.newChild(100));
        }
    }

    protected final void createFolder(IComponent iComponent, FileAreaUpdate fileAreaUpdate, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        Object object3;
        IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
        String string = fileAreaUpdate.getName();
        IFolderHandle iFolderHandle2 = (IFolderHandle)fileAreaUpdate.afterState();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isComponentShared(iComponent)) {
            return;
        }
        String string2 = string;
        Shareable shareable = null;
        if (this.isShareParent(iComponent, iFolderHandle)) {
            Path path = new Path(string);
        } else {
            object3 = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
            shareable = this.getShareableFor((IPath)object3, true);
            if (shareable == null) {
                this.failedUpdate(fileAreaUpdate);
                return;
            }
            if (!shareable.isLocal()) {
                string2 = object3.append(string).toString();
                this.recordInconsistentShare((IComponentHandle)iComponent, object3.segment(0));
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)string2, (Object)iComponent.getName())));
                return;
            }
            IPath iPath = object3.append(string);
            string2 = iPath.toString();
            if (!this.isPathValid((IComponentHandle)iComponent, iPath, true)) {
                if (iPath != null) {
                    this.recordInconsistentShare((IComponentHandle)iComponent, iPath.segment(0));
                }
                this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_3, (Object)string2, (Object)iComponent.getName())));
                return;
            }
        }
        object3 = null;
        if (this.isShareParent(iComponent, iFolderHandle)) {
            object3 = this.getRootFolder(string);
        } else {
            object2 = shareable.getFileStorage().getChild(string);
            if (object2 != null) {
                object3 = object2.getShareable();
            }
        }
        object2 = (Shareable)SharingManager.getInstance().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)iFolderHandle2, (IComponentHandle)iComponent, this.connectionHandle, null);
        if (object3 != null && ((Shareable)object3).isLocal() && ((Shareable)object3).getFileStorage().isFolder() && ((Shareable)object3).getRemote() == null && object2 == null) {
            FileItemInfo fileItemInfo;
            if (this.isShareParent(iComponent, iFolderHandle)) {
                this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, string));
                SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), iFolderHandle2);
                if (((Shareable)object3).getShare() == null) {
                    ((Shareable)object3).share(sharingDescriptor, true, (IProgressMonitor)subMonitor.newChild(40));
                } else {
                    this.getCopyFileArea().setSharingInfo((IShareable)object3, sharingDescriptor, (IProgressMonitor)subMonitor.newChild(40));
                }
                fileItemInfo = new FileItemInfo(iFolderHandle2, null, null);
            } else {
                fileItemInfo = new FileItemInfo(iFolderHandle2, iFolderHandle, string);
            }
            this.getCopyFileArea().setItemInfo((IShareable)object3, fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
            return;
        }
        if (object3 != null && ((Shareable)object3).isLocal()) {
            object = null;
            IShare iShare = ((Shareable)object3).getShare();
            if (iShare != null) {
                object = iShare.getSharingDescriptor().getComponent();
            }
            if (!iFolderHandle2.sameItemId((IItemHandle)((Shareable)object3).getRemote()) || !iComponent.sameItemId((IItemHandle)object)) {
                this.handleCollision(iComponent, (Shareable)object3, (IProgressMonitor)subMonitor.newChild(25));
            }
        }
        if (this.isShareParent(iComponent, iFolderHandle)) {
            this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, string));
        }
        if (object2 != null && ((Shareable)object2).isLocal()) {
            object = ((Shareable)object2).getFileStorage().getParent();
            if (!(object == null && shareable == null || object != null && iFolderHandle.sameItemId((IItemHandle)object.getRemote()) && string.equals(object2.getLocalFullPath().lastSegment()))) {
                this.move(iComponent, (IComponentHandle)iComponent, (Shareable)object2, shareable, iFolderHandle, string, (IVersionableHandle)iFolderHandle2, (IProgressMonitor)subMonitor.newChild(25));
            }
        } else {
            subMonitor.setWorkRemaining(100);
            this.createFolder(iComponent, iFolderHandle, shareable, string, iFolderHandle2, (IProgressMonitor)subMonitor.newChild(100));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void deleteSubtree(IComponent iComponent, IFolderHandle iFolderHandle, String string, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isComponentShared(iComponent)) {
            return;
        }
        try {
            subMonitor.subTask(NLS.bind((String)Messages.UpdateMutator_4, (Object)string));
            IPath iPath = this.getCopyFileArea().getLocalPathFor(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
            if (iPath == null) {
                this.getCopyFileArea().deleteTreeInfo(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
                return;
            }
            if (!this.isPathValid((IComponentHandle)iComponent, iPath, false)) {
                this.recordInconsistentShare((IComponentHandle)iComponent, iPath.segment(0));
                this.collectStatus(new FileSystemStatus(2, 370, NLS.bind((String)Messages.UpdateMutator_5, (Object)string, (Object)iComponent.getName())));
                return;
            }
            Shareable shareable = this.getShareableFor(iPath, iVersionableHandle instanceof IFolderHandle);
            if (!shareable.isLocal()) {
                if (this.isRoot(shareable)) {
                    shareable.unshare((IProgressMonitor)subMonitor.newChild(100));
                    return;
                } else {
                    shareable.forget((IProgressMonitor)subMonitor.newChild(100));
                }
                return;
            } else {
                this.deleteSubtree(iComponent, shareable, (IProgressMonitor)subMonitor.newChild(100));
            }
            return;
        }
        finally {
            subMonitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void modifyFile(IComponent iComponent, FileAreaUpdate fileAreaUpdate, DeferredDownloadInformation deferredDownloadInformation, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        String string = deferredDownloadInformation.getName();
        IFileItemHandle iFileItemHandle = deferredDownloadInformation.getFileItem();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isComponentShared(iComponent)) {
            return;
        }
        try {
            IPath iPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)iFileItemHandle, (IComponentHandle)iComponent, this.connectionHandle, (IProgressMonitor)subMonitor.newChild(1));
            Shareable shareable = this.getShareableFor(iPath, false);
            if (shareable == null) {
                if (this.isShareParent(iComponent, fileAreaUpdate.getDestinationParent())) {
                    return;
                }
                if (iPath == null) {
                    iPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)iFileItemHandle, (IComponentHandle)iComponent, this.connectionHandle, (IProgressMonitor)subMonitor.newChild(1));
                    if (iPath != null) {
                        string = iPath.toString();
                    } else {
                        iPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)fileAreaUpdate.getDestinationParent(), (IComponentHandle)iComponent, this.connectionHandle, (IProgressMonitor)subMonitor.newChild(1));
                        if (iPath != null) {
                            string = iPath.append(deferredDownloadInformation.getName()).toString();
                        }
                    }
                }
                if (iPath != null) {
                    this.recordInconsistentShare((IComponentHandle)iComponent, iPath.segment(0));
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_6, (Object)string, (Object)iComponent.getName())));
                    return;
                }
                this.failedUpdate(fileAreaUpdate);
                return;
            }
            string = shareable.getLocalFullPath().toString();
            if (!this.isPathValid((IComponentHandle)iComponent, iPath, false)) {
                this.recordInconsistentShare((IComponentHandle)iComponent, iPath.segment(0));
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_7, (Object)string, (Object)iComponent.getName())));
                return;
            }
            if (!shareable.isLocal()) {
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)string, (Object)iComponent.getName())));
                return;
            }
            this.modifyFile(iComponent, deferredDownloadInformation, shareable, (IProgressMonitor)subMonitor);
            return;
        }
        finally {
            subMonitor.done();
        }
    }

    protected final void moveSubtree(IComponent iComponent, FileAreaUpdate fileAreaUpdate, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        IComponentHandle iComponentHandle = fileAreaUpdate.getPreviousComponent();
        String string = fileAreaUpdate.getOldName();
        IFolderHandle iFolderHandle = fileAreaUpdate.getDestinationParent();
        String string2 = fileAreaUpdate.getName();
        IVersionableHandle iVersionableHandle = fileAreaUpdate.afterState();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isComponentShared(iComponent)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string3 = null;
        String string4 = null;
        IPath iPath = this.getCopyFileArea().getLocalPathFor(iVersionableHandle, iComponentHandle, this.connectionHandle, null);
        if (iPath != null) {
            string4 = iPath.segment(0);
            bl = true;
            bl2 = iPath.segmentCount() == 1;
        } else {
            bl = false;
            object = this.getCopyFileArea().getRemotePathFor(iVersionableHandle, iComponentHandle, this.connectionHandle, null);
            if (object != null) {
                string4 = object.segment(0);
                bl3 = true;
                bl2 = object.segmentCount() == 1;
            }
        }
        object = null;
        if (this.isShareParent(iComponent, iFolderHandle)) {
            string3 = string2;
            bl6 = true;
        } else {
            IPath iPath2 = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
            object = this.getShareableFor(iPath2, true);
            if (iPath2 != null) {
                string3 = iPath2.segment(0);
                bl4 = true;
                bl5 = true;
            } else {
                bl4 = false;
                IPath iPath3 = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)iComponent, this.connectionHandle, null);
                if (iPath3 != null) {
                    string3 = iPath3.segment(0);
                    bl5 = true;
                } else if (bl2) {
                    string3 = string2;
                    bl6 = true;
                }
            }
        }
        if (!bl) {
            this.recordInconsistentShare(iComponentHandle, string4);
            this.recordInconsistentShare((IComponentHandle)iComponent, string3);
            if (!bl3) {
                this.failedUpdate(fileAreaUpdate, fileAreaUpdate.getPreviousComponent());
            }
            if (bl4 || bl5) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_9, (Object)string, (Object)iComponent.getName())));
            } else if (!bl6) {
                this.failedUpdate(fileAreaUpdate);
            }
            return;
        }
        boolean bl7 = this.isPathValid(iComponentHandle, iPath, false);
        boolean bl8 = false;
        if (bl4) {
            bl8 = this.isPathValid((IComponentHandle)iComponent, object.getLocalFullPath().append(string2), true);
        } else if (bl6) {
            bl8 = true;
        } else if (bl2 && !bl5) {
            bl8 = true;
        } else {
            this.recordInconsistentShare(iComponentHandle, string4);
            this.recordInconsistentShare((IComponentHandle)iComponent, string3);
            this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_10, (Object)iPath.toString(), (Object)iComponent.getName())));
            return;
        }
        if (!bl7 || !bl8) {
            Object object2;
            IShare iShare;
            this.recordInconsistentShare(iComponentHandle, string4);
            this.recordInconsistentShare((IComponentHandle)iComponent, string3);
            String string5 = iComponent.getName();
            if (!iComponentHandle.sameItemId((IItemHandle)iComponent) && (iShare = ((Shareable)(object2 = this.getShareableFor(iPath, iVersionableHandle instanceof IFolderHandle))).getShare()) != null) {
                string5 = iShare.getSharingDescriptor().getComponentName();
            }
            string5 = String.valueOf(string5) + " - " + iPath.segment(0);
            object2 = iComponent.getName();
            object2 = object == null ? String.valueOf(object2) + " - " + string2 : String.valueOf(object2) + object.getLocalFullPath().segment(0);
            if (!string5.equals(object2)) {
                string5 = String.valueOf(string5) + " & " + (String)object2;
            }
            if (!bl7 && !bl8) {
                this.collectStatus(new FileSystemStatus(2, 371, NLS.bind((String)Messages.UpdateMutator_14, (Object)string5)));
            } else if (!bl7) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_15, (Object)string5)));
            } else if (!bl8) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_16, (Object)string5)));
            }
            return;
        }
        Shareable shareable = this.getShareableFor(iPath, iVersionableHandle instanceof IFolderHandle);
        Shareable shareable2 = null;
        if (bl6) {
            shareable2 = this.getRootFolder(string2);
        } else {
            IFileStorage iFileStorage = ((Shareable)object).getFileStorage().getChild(string2);
            if (iFileStorage != null) {
                shareable2 = iFileStorage.getShareable();
            }
        }
        if (shareable2 != null) {
            if (iVersionableHandle.sameItemId((IItemHandle)shareable2.getRemote()) && iComponent.sameItemId((IItemHandle)iComponentHandle)) {
                if (fileAreaUpdate.getName().equals(shareable2.getLocalFullPath().lastSegment())) {
                    this.updateMetaDataAfterMove(iComponent, iComponentHandle, iVersionableHandle, true, shareable, shareable2, true, (IProgressMonitor)subMonitor.newChild(75));
                    return;
                }
            } else if (shareable2.isLocal()) {
                if (shareable2.getLocalFullPath().equals((Object)shareable.getLocalFullPath())) {
                    this.updateMetaDataAfterMove(iComponent, iComponentHandle, iVersionableHandle, true, shareable, shareable2, true, (IProgressMonitor)subMonitor.newChild(75));
                    return;
                }
                this.handleCollision(iComponent, shareable2, (IProgressMonitor)subMonitor.newChild(25));
            }
        }
        this.move(iComponent, iComponentHandle, shareable, (Shareable)object, iFolderHandle, string2, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(75));
    }

    private void handleCollision(IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IVersionableHandle iVersionableHandle = shareable.getRemote();
        boolean bl = false;
        if (iVersionableHandle != null) {
            if (this.isRoot(shareable)) {
                boolean bl2 = bl = this.pendingUpdate(iVersionableHandle, this.updates.getDeletes()) || this.pendingUpdate(iVersionableHandle, this.updates.getMoves());
                if (!bl) {
                    this.collectStatus(new FileSystemStatus(2, 333, NLS.bind((String)Messages.UpdateMutator_17, (Object)shareable.getLocalFullPath())));
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.preserve(iComponent, shareable, iProgressMonitor);
        } else {
            this.deleteSubtree(iComponent, shareable, iProgressMonitor);
        }
    }

    private boolean pendingUpdate(IVersionableHandle iVersionableHandle, Collection collection) {
        for (FileAreaUpdate fileAreaUpdate : collection) {
            if (!fileAreaUpdate.item().sameItemId((IItemHandle)iVersionableHandle)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isRoot(Shareable shareable) {
        IShare iShare;
        boolean bl = false;
        IVersionableHandle iVersionableHandle = shareable.getRemote();
        if (iVersionableHandle != null && (iShare = shareable.getShare()) != null) {
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            bl = iSharingDescriptor != null && iVersionableHandle.sameItemId((IItemHandle)iSharingDescriptor.getRootFolder());
        }
        return bl;
    }

    protected boolean isPathValid(IComponentHandle iComponentHandle, IPath iPath, boolean bl) {
        if (iPath == null) {
            return true;
        }
        String[] stringArray = iPath.segments();
        if (iComponentHandle.sameItemId((IItemHandle)this.lastComponent) && stringArray[0].equals(this.lastPath) && bl == this.lastNewProjectAllowed) {
            return this.lastResult;
        }
        this.lastComponent = iComponentHandle;
        this.lastPath = stringArray[0];
        this.lastNewProjectAllowed = bl;
        ISharingDescriptor iSharingDescriptor = this.getCopyFileArea().getSharingInfo((IPath)new Path(stringArray[0]));
        this.lastResult = iSharingDescriptor != null ? this.sharedToSameComponent(iSharingDescriptor, iComponentHandle) : bl && stringArray.length == 1 && !this.getRootFolder(stringArray[0]).isLocal();
        return this.lastResult;
    }

    protected final boolean sharedToSameComponent(ISharingDescriptor iSharingDescriptor, IComponentHandle iComponentHandle) {
        if (iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle)) {
            return iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle);
        }
        return false;
    }

    protected final boolean isComponentShared(IComponent iComponent) throws FileSystemClientException {
        if (iComponent.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        this.lastComponentShareTested = iComponent;
        this.lastComponentSharedResult = this.getCopyFileArea().isLoaded((IComponentHandle)iComponent, this.connectionHandle, null);
        if (!this.lastComponentSharedResult && !this.componentNotShared.contains(iComponent.getItemId())) {
            this.componentNotShared.add(iComponent.getItemId());
            this.collectStatus(new FileSystemStatus(2, 367, NLS.bind((String)Messages.UpdateMutator_18, (Object)iComponent.getName())));
        }
        return this.lastComponentSharedResult;
    }

    protected final void recordInconsistentShare(IComponentHandle iComponentHandle, String string) {
        if (string != null) {
            this.inconsistentShares.add(new UpdateMutator$ShareReference(iComponentHandle, string));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected final void execute(IProgressMonitor var1_1) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        var2_2 = SubMonitor.convert((IProgressMonitor)var1_1, (int)100);
        var3_3 = new UpdateOrder(this.updates.getAdds(), this.updates.getDeletes(), this.updates.getMoves(), this.updates.getModifies());
        var4_4 = var3_3.getFileMoves().size() + var3_3.getFileAdds().size() + var3_3.getGroupedModifies().size();
        var5_5 = new ArrayList<IStatus[]>(var4_4);
        this.contentSession = this.repository.contentManager().createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName()), true, (long)var4_4, (IProgressMonitor)var2_2.newChild(80));
        var6_6 = new CancellationMonitor((IProgressMonitor)var2_2);
        var7_7 = null;
        try {
            for (FileAreaUpdate var8_9 : var3_3.getFolderAdds()) {
                var7_7 = this.getFullComponent(var8_9, var7_7);
                this.createFolder(var7_7, var8_9, (IProgressMonitor)var6_6);
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            for (FileAreaUpdate var8_9 : var3_3.getFolderMoves()) {
                var7_7 = this.getFullComponent(var8_9, var7_7);
                this.moveSubtree(var7_7, var8_9, (IProgressMonitor)var6_6);
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            for (FileAreaUpdate var8_9 : var3_3.getFileMoves()) {
                var7_7 = this.getFullComponent(var8_9, var7_7);
                this.moveSubtree(var7_7, var8_9, (IProgressMonitor)var6_6);
                if (var8_9.isChangeType(4)) {
                    var10_10 = new DeferredDownloadInformation(var8_9);
                    var5_5.add(var10_10);
                    this.modifyFile(var7_7, var8_9, (DeferredDownloadInformation)var10_10, var8_9.getTimestamp(), (IProgressMonitor)var6_6);
                } else {
                    this.contentSession.decrementTransferCount(1);
                }
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            for (FileAreaUpdate var8_9 : var3_3.getOrderedDeletes()) {
                var7_7 = this.getFullComponent(var8_9, var7_7);
                this.deleteSubtree(var7_7, var8_9.getSourceParent(), var8_9.getName(), var8_9.beforeState(), (IProgressMonitor)var6_6);
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            for (FileAreaUpdate var8_9 : var3_3.getGroupedModifies()) {
                if (!(var8_9.getItem() instanceof IFileItemHandle)) continue;
                var7_7 = this.getFullComponent(var8_9, var7_7);
                var10_10 = new DeferredDownloadInformation(var8_9);
                var5_5.add(var10_10);
                this.modifyFile(var7_7, var8_9, (DeferredDownloadInformation)var10_10, var8_9.getTimestamp(), (IProgressMonitor)var6_6);
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            for (FileAreaUpdate var8_9 : var3_3.getFileAdds()) {
                var7_7 = this.getFullComponent(var8_9, var7_7);
                var10_10 = new DeferredDownloadInformation(var8_9);
                var5_5.add(var10_10);
                this.createFile(var7_7, var8_9, (DeferredDownloadInformation)var10_10, var8_9.getTimestamp(), (IProgressMonitor)var6_6);
                this.checkCancelled((IProgressMonitor)var6_6);
            }
            this.verifyUpdatesOutsideShares((IProgressMonitor)var6_6);
        }
        finally {
            this.contentSession.join();
            var12_13 = var2_2.newChild(5);
            var12_13.setWorkRemaining(var5_5.size() * 2);
            ** for (var13_17 : var5_5)
        }
lbl-1000:
        // 1 sources

        {
            if (!var13_17.contentUpdated()) continue;
            this.updateMetaData(var13_17, (IProgressMonitor)var12_13.newChild(1));
            if (this.skipUpdate(var13_17.getShareable())) continue;
            var13_17.getShareable().getFileStorage().setExecutable(var13_17.isExecutable(), (IProgressMonitor)var12_13.newChild(1));
            continue;
        }
lbl68:
        // 1 sources

        var12_13.done();
        var8_9 = this.getDownloadFailures(var5_5);
        if (((IStatus[])var8_9).length > 0) {
            var9_8 = this.getErrors();
            if (var9_8.length > 0) {
                var10_10 = new IStatus[((IStatus[])var8_9).length + var9_8.length];
                System.arraycopy(var9_8, 0, var10_10, 0, var9_8.length);
                System.arraycopy(var8_9, 0, var10_10, var9_8.length, ((IStatus[])var8_9).length);
                var8_9 = var10_10;
            }
            RepositoryUtils.throwAppropriateException(Messages.UpdateMutator_20, (IStatus[])var8_9);
        } else if (this.contentSession.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        this.updateConfigStates((IProgressMonitor)var2_2.newChild(15));
    }

    private void verifyUpdatesOutsideShares(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        HashMap<UUID, IPath> hashMap;
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.failedUpdates.size());
        if (this.failedUpdates.isEmpty()) {
            return;
        }
        HashMap<UUID, HashMap<UUID, IPath>> hashMap2 = new HashMap<UUID, HashMap<UUID, IPath>>();
        CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
        IPath[] iPathArray = copyFileAreaStore.allSharePaths();
        Object object2 = iPathArray;
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath object3 = object2[n2];
            object = copyFileAreaStore.getSharingInfo(object3);
            if (this.failedUpdates.containsKey(object.getComponent().getItemId()) && object.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) {
                hashMap = (HashMap<UUID, IPath>)hashMap2.get(object.getComponent().getItemId());
                if (hashMap == null) {
                    hashMap = new HashMap<UUID, IPath>();
                    hashMap2.put(object.getComponent().getItemId(), hashMap);
                }
                hashMap.put(object.getRootFolder().getItemId(), object3);
            }
            ++n2;
        }
        for (Map.Entry entry : this.failedUpdates.entrySet()) {
            Collection collection;
            Object object3;
            Object object42;
            IConfiguration iConfiguration = null;
            object2 = new HashMap();
            object = new HashMap();
            hashMap = new HashMap<UUID, IPath>();
            for (Object object42 : (List)entry.getValue()) {
                if (iConfiguration == null) {
                    iConfiguration = this.connection instanceof IWorkspaceConnection ? (((UUID)entry.getKey()).equals((Object)object42.getComponent().getItemId()) ? ((IWorkspaceConnection)this.connection).configuration(object42.component()) : ((IWorkspaceConnection)this.connection).configuration(object42.getPreviousComponent())) : ((IBaselineConnection)this.connection).configuration();
                }
                if (object42.isChangeType(8)) {
                    if (((UUID)entry.getKey()).equals((Object)object42.getComponent().getItemId())) {
                        this.determineWhatToLocate((HashMap)object2, (HashMap)object, hashMap, (FileAreaUpdate)object42);
                    }
                    if (!((UUID)entry.getKey()).equals((Object)object42.getPreviousComponent().getItemId())) continue;
                    object3 = object42.getSourceParent().getItemId();
                    collection = new HashSet<Object>();
                    ((HashSet)collection).add(object42);
                    if (!((HashMap)object2).containsKey(object3)) {
                        ((HashMap)object).put(object3, object42.getSourceParent());
                        hashMap.put((UUID)object3, (IPath)collection);
                        ((HashMap)object2).put(object3, null);
                        continue;
                    }
                    this.recordUpdateAgainstLocate((UUID)object3, (HashSet)collection, (HashMap)object2, hashMap);
                    continue;
                }
                if (!object42.isChangeType(1) && !object42.isChangeType(4)) continue;
                this.determineWhatToLocate((HashMap)object2, (HashMap)object, hashMap, (FileAreaUpdate)object42);
            }
            object42 = (HashMap)hashMap2.get(iConfiguration.component().getItemId());
            if (object42 == null || ((HashMap)object42).isEmpty() || ((HashMap)object).isEmpty()) continue;
            IComponent iComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)iConfiguration.component(), 0, null);
            object3 = new ArrayList(((HashMap)object).values());
            collection = iConfiguration.locateAncestors((List)object3, (IProgressMonitor)subMonitor.newChild(1));
            int n3 = 0;
            for (IAncestorReport iAncestorReport : collection) {
                for (INameItemPair iNameItemPair : iAncestorReport.getNameItemPairs()) {
                    IPath iPath = (IPath)((HashMap)object42).get(iNameItemPair.getItem().getItemId());
                    if (iPath == null) continue;
                    this.recordInconsistentShare(iConfiguration.component(), iPath.segment(0));
                    this.reportFailedUpdates(iComponent, (IVersionableHandle)((ArrayList)object3).get(n3), hashMap);
                }
                ++n3;
            }
        }
    }

    private void determineWhatToLocate(HashMap hashMap, HashMap hashMap2, HashMap hashMap3, FileAreaUpdate fileAreaUpdate) {
        HashSet hashSet;
        UUID uUID = fileAreaUpdate.item().getItemId();
        UUID uUID2 = fileAreaUpdate.getDestinationParent().getItemId();
        hashMap.put(uUID, uUID2);
        if (hashMap2.containsKey(uUID)) {
            hashMap2.remove(uUID);
            hashSet = (HashSet)hashMap3.remove(uUID);
        } else {
            hashSet = new HashSet();
        }
        hashSet.add(fileAreaUpdate);
        if (!hashMap.containsKey(uUID2)) {
            hashMap2.put(uUID2, fileAreaUpdate.getDestinationParent());
            hashMap3.put(uUID2, hashSet);
            hashMap.put(uUID2, null);
        } else {
            this.recordUpdateAgainstLocate(uUID2, hashSet, hashMap, hashMap3);
        }
    }

    private void recordUpdateAgainstLocate(UUID uUID, HashSet hashSet, HashMap hashMap, HashMap hashMap2) {
        int n = 0;
        while (n < 2000) {
            UUID uUID2 = (UUID)hashMap.get(uUID);
            if (uUID2 == null) {
                HashSet hashSet2 = (HashSet)hashMap2.get(uUID);
                if (hashSet2 == null) {
                    hashMap2.put(uUID, hashSet);
                    break;
                }
                hashSet2.addAll(hashSet);
                break;
            }
            uUID = uUID2;
            ++n;
        }
    }

    private void reportFailedUpdates(IComponent iComponent, IVersionableHandle iVersionableHandle, HashMap hashMap) {
        HashSet hashSet = (HashSet)hashMap.get(iVersionableHandle.getItemId());
        if (hashSet != null) {
            for (FileAreaUpdate fileAreaUpdate : hashSet) {
                if (fileAreaUpdate.isChangeType(4)) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_25, (Object)fileAreaUpdate.getName(), (Object)iComponent.getName())));
                    continue;
                }
                if (fileAreaUpdate.isChangeType(1) && fileAreaUpdate.item() instanceof IFileItemHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_26, (Object)fileAreaUpdate.getName(), (Object)iComponent.getName())));
                    continue;
                }
                if (fileAreaUpdate.isChangeType(1) && fileAreaUpdate.item() instanceof IFolderHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_27, (Object)fileAreaUpdate.getName(), (Object)iComponent.getName())));
                    continue;
                }
                if (!fileAreaUpdate.isChangeType(8)) continue;
                this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_28, (Object)fileAreaUpdate.getOldName(), (Object)iComponent.getName())));
            }
        }
    }

    private IStatus[] getDownloadFailures(ArrayList arrayList) {
        ArrayList<Status> arrayList2 = new ArrayList<Status>();
        for (DeferredDownloadInformation deferredDownloadInformation : arrayList) {
            if (deferredDownloadInformation == null || deferredDownloadInformation.getFailure() == null) continue;
            Throwable throwable = deferredDownloadInformation.getFailure().getCause();
            int n = 0;
            while (throwable instanceof TeamRepositoryException && n < 50) {
                Throwable throwable2 = ((TeamRepositoryException)throwable).getCause();
                if (throwable2 == null) break;
                throwable = throwable2;
                ++n;
            }
            Status status = throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_21, (Object)deferredDownloadInformation.getShareable().getLocalFullPath(), (Object)deferredDownloadInformation.getContent().getCharacterEncoding()), (Throwable)deferredDownloadInformation.getFailure()) : (throwable instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_23, (Object)deferredDownloadInformation.getShareable().getLocalFullPath(), (Object)deferredDownloadInformation.getContent().getCharacterEncoding()), (Throwable)deferredDownloadInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_22, (Object)deferredDownloadInformation.getShareable().getLocalFullPath()), (Throwable)deferredDownloadInformation.getFailure()));
            arrayList2.add(status);
        }
        return arrayList2.toArray(new IStatus[arrayList2.size()]);
    }

    protected abstract void updateMetaData(DeferredDownloadInformation var1, IProgressMonitor var2) throws FileSystemClientException, TeamRepositoryException;

    private IComponent getFullComponent(FileAreaUpdate fileAreaUpdate, IComponent iComponent) throws TeamRepositoryException {
        if (!fileAreaUpdate.component().sameItemId((IItemHandle)iComponent)) {
            iComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)fileAreaUpdate.component(), 0, null);
        }
        return iComponent;
    }

    private void updateConfigStates(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        IComponentStateSummary iComponentStateSummary;
        this.newShares.removeAll(this.inconsistentShares);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.newShares) {
            iComponentStateSummary = (IComponentStateSummary)this.componentStatesAfter.get(updateMutator$ShareReference.component.getItemId());
            this.getCopyFileArea().setConfigurationState(this.connectionHandle, updateMutator$ShareReference.component, (IPath)new Path(updateMutator$ShareReference.sharePath), iComponentStateSummary.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.componentStatesAfter.values()) {
            iComponentStateSummary = (IComponentStateSummary)this.componentStatesBefore.get(updateMutator$ShareReference.getComponent().getItemId());
            if (iComponentStateSummary == null) continue;
            this.getCopyFileArea().setConfigurationState(this.connectionHandle, updateMutator$ShareReference.getComponent(), iComponentStateSummary.getConfigurationTime(), updateMutator$ShareReference.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (UpdateMutator$ShareReference updateMutator$ShareReference : this.inconsistentShares) {
            this.getCopyFileArea().setUnknownConfigurationState(this.connectionHandle, updateMutator$ShareReference.component, new Path(updateMutator$ShareReference.sharePath), (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    protected ISyncTime getBeforeConfigState(IComponentHandle iComponentHandle) {
        return ((IComponentStateSummary)this.componentStatesBefore.get(iComponentHandle.getItemId())).getConfigurationTime();
    }

    protected void updateMetaDataAfterMove(IComponent iComponent, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, boolean bl, Shareable shareable, Shareable shareable2, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
        FileItemInfo fileItemInfo = copyFileAreaStore.getItemInfo(shareable.getLocalFullPath());
        if (bl2) {
            if (!shareable.getLocalFullPath().equals((Object)shareable2.getLocalFullPath())) {
                copyFileAreaStore.moveSharingInfo(shareable.getLocalFullPath(), shareable2.getLocalFullPath(), (IProgressMonitor)subMonitor.newChild(75));
            }
            if (!iComponent.sameItemId((IItemHandle)iComponentHandle)) {
                object2 = (SharingDescriptor)shareable2.getShare().getSharingDescriptor();
                object = this.getBeforeConfigState(iComponentHandle);
                ISyncTime iSyncTime = this.getBeforeConfigState((IComponentHandle)iComponent);
                if (!((SharingDescriptor)object2).getConfigurationState().equals(object)) {
                    this.recordInconsistentShare((IComponentHandle)iComponent, shareable2.getLocalFullPath().segment(0));
                    copyFileAreaStore.setSharingInfo(shareable2, new SharingDescriptor(((SharingDescriptor)object2).getRepositoryUri(), ((SharingDescriptor)object2).getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), ((SharingDescriptor)object2).getRootFolder()), (IProgressMonitor)subMonitor.newChild(25));
                } else if (iSyncTime == null) {
                    this.newShares.add(new UpdateMutator$ShareReference((IComponentHandle)iComponent, shareable2.getLocalFullPath().segment(0)));
                    copyFileAreaStore.setSharingInfo(shareable2, new SharingDescriptor(((SharingDescriptor)object2).getRepositoryUri(), ((SharingDescriptor)object2).getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), ((SharingDescriptor)object2).getRootFolder()), (IProgressMonitor)subMonitor.newChild(25));
                } else {
                    copyFileAreaStore.setSharingInfo(shareable2, new SharingDescriptor(((SharingDescriptor)object2).getRepositoryUri(), ((SharingDescriptor)object2).getRepositoryId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), ((SharingDescriptor)object2).getRootFolder(), iSyncTime), (IProgressMonitor)subMonitor.newChild(25));
                }
            }
        } else if (fileItemInfo != null) {
            copyFileAreaStore.moveTreeInfo(shareable, shareable2, bl, (IProgressMonitor)subMonitor.newChild(90));
            object2 = (SharingDescriptor)shareable.getShare().getSharingDescriptor();
            if (!((SharingDescriptor)object2).getConfigurationState().equals(this.getBeforeConfigState(((SharingDescriptor)object2).getComponent()))) {
                this.recordInconsistentShare((IComponentHandle)iComponent, shareable2.getLocalFullPath().segment(0));
            }
        }
        if (bl && iVersionableHandle instanceof IFileItemHandle) {
            object2 = copyFileAreaStore.getItemInfo(iVersionableHandle, (IComponentHandle)iComponent, this.connectionHandle);
            object = new FileItemInfo(iVersionableHandle, ((FileItemInfo)object2).getLastModification(), ((FileItemInfo)object2).getParent(), ((FileItemInfo)object2).getName(), ((FileItemInfo)object2).getHash(), ((FileItemInfo)object2).getContentLength(), ((FileItemInfo)object2).getOriginalLineDelimiter(), ((FileItemInfo)object2).getLineDelimiter(), ((FileItemInfo)object2).getOriginalContentType(), ((FileItemInfo)object2).getContentType(), ((FileItemInfo)object2).getStoredContentId(), ((FileItemInfo)object2).getStoredDeltaPredecessor(), ((FileItemInfo)object2).getStoredSize(), ((FileItemInfo)object2).getStoredEncoding(), ((FileItemInfo)object2).getStoredChecksum(), ((FileItemInfo)object2).getStoredNumLineDelimiters(), ((FileItemInfo)object2).isExecutable(), ((FileItemInfo)object2).isOriginalExecutable());
            this.getCopyFileArea().setItemInfo(shareable2, (FileItemInfo)object, null);
        }
    }

    public final void setSkipStoreContent(Set set) {
        this.versionablesToSkip = set;
    }

    protected final boolean isSkipping() {
        return this.versionablesToSkip.size() > 0;
    }

    protected final boolean skipUpdate(Shareable shareable) {
        Assert.isNotNull((Object)shareable);
        if (shareable.getRemote() == null) {
            return false;
        }
        return this.skipUpdate(shareable.getRemote().getItemId());
    }

    protected final boolean skipUpdate(UUID uUID) {
        return this.versionablesToSkip.contains(uUID);
    }

    private void failedUpdate(FileAreaUpdate fileAreaUpdate) {
        this.failedUpdate(fileAreaUpdate, fileAreaUpdate.component());
    }

    protected final void failedUpdate(FileAreaUpdate fileAreaUpdate, IComponentHandle iComponentHandle) {
        ArrayList<FileAreaUpdate> arrayList = (ArrayList<FileAreaUpdate>)this.failedUpdates.get(iComponentHandle.getItemId());
        if (arrayList == null) {
            arrayList = new ArrayList<FileAreaUpdate>();
            this.failedUpdates.put(iComponentHandle.getItemId(), arrayList);
        }
        arrayList.add(fileAreaUpdate);
    }

    private boolean isShareParent(IComponent iComponent, IFolderHandle iFolderHandle) {
        HashSet hashSet = (HashSet)this.shareParents.get(iComponent.getItemId());
        if (hashSet != null) {
            return hashSet.contains(iFolderHandle.getItemId());
        }
        return false;
    }

    protected void reportErrorsAsException(IStatus[] iStatusArray) throws FileSystemClientException {
        if (iStatusArray.length == 0) {
            return;
        }
        if (this.inconsistentShares.size() > 0) {
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, iStatusArray, NLS.bind((String)Messages.UpdateMutator_24, (Object)iStatusArray.length), null);
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
        super.reportErrorsAsException(iStatusArray);
    }
}

