/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$1;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$FolderInformation;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$RelativePath;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class MergeLoadMutator
extends FileSystemOperation {
    protected IContentManagerSession contentSession = null;
    private final IPath copyFileAreaPath;
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    private final LoadTree loadTree;
    private final ITeamRepository repo;
    private HashSet loadLocations;
    private HashMap roots;

    public MergeLoadMutator(IConnection iConnection, Map map, LoadTree loadTree, IPath iPath, Collection collection, DilemmaHandler dilemmaHandler) throws TeamRepositoryException {
        super(dilemmaHandler);
        if (iPath == null || iConnection == null || collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connection = iConnection;
        this.repo = iConnection.teamRepository();
        this.copyFileAreaPath = iPath;
        this.loadTree = loadTree;
        this.loadLocations = new HashSet();
        for (String[] object : collection) {
            this.loadLocations.add(PathUtils.getPath(object));
        }
        this.connectionHandle = iConnection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace().getItemHandle() : (IContextHandle)((IBaselineConnection)iConnection).getBaseline();
        this.roots = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            UUID uUID = ((ConfigurationDescriptor)entry.getKey()).componentHandle.getItemId();
            HashSet<UUID> hashSet = (HashSet<UUID>)this.roots.get(uUID);
            if (hashSet == null) {
                hashSet = new HashSet<UUID>();
                this.roots.put(uUID, hashSet);
            }
            for (IVersionableHandle iVersionableHandle : (Collection)entry.getValue()) {
                hashSet.add(iVersionableHandle.getItemId());
            }
        }
    }

    protected void beginning() throws TeamRepositoryException, FileSystemClientException {
    }

    /*
     * WARNING - void declaration
     */
    protected final void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        IComponentHandle iComponentHandle;
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        List list = this.loadTree.getFileAreaUpdates();
        this.contentSession = this.repo.contentManager().createSession("", true, (long)list.size(), (IProgressMonitor)subMonitor.newChild(80));
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        MergeLoadMutator$DeferredUpdateInformation[] mergeLoadMutator$DeferredUpdateInformationArray = new MergeLoadMutator$DeferredUpdateInformation[list.size()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(this.getRoot());
        CancellationMonitor cancellationMonitor = new CancellationMonitor((IProgressMonitor)subMonitor);
        IComponent iComponent = null;
        try {
            int n = -1;
            for (FileAreaUpdate fileAreaUpdate : list) {
                this.checkCancelled(iProgressMonitor);
                ++n;
                iComponentHandle = fileAreaUpdate.getComponent();
                if (!iComponentHandle.sameItemId((IItemHandle)iComponent)) {
                    iComponent = (IComponent)this.repo.itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, null);
                }
                if (fileAreaUpdate.getChangeType() == 1) {
                    boolean bl;
                    void var18_34;
                    Object object5;
                    object4 = fileAreaUpdate.afterState();
                    boolean bl2 = object4 instanceof IFolderHandle;
                    object3 = null;
                    if (this.isShareRoot(iComponentHandle, fileAreaUpdate.getItem())) {
                        object2 = new Path(fileAreaUpdate.getName());
                        Shareable shareable = this.getShareable((IPath)object2);
                    } else {
                        object3 = this.getShareable((IVersionableHandle)fileAreaUpdate.getDestinationParent(), fileAreaUpdate.component(), null);
                        object = ((Shareable)object3).getFileStorage().getChild(fileAreaUpdate.getName());
                        if (object != null) {
                            Shareable shareable = object.getShareable();
                        } else {
                            Object var18_37 = null;
                        }
                        object2 = object3.getLocalFullPath();
                        object5 = (HashSet)hashMap.get(new MergeLoadMutator$RelativePath(this, (IPath)object2));
                        if (object5 != null) {
                            ((HashSet)object5).add(fileAreaUpdate.getName());
                        }
                        if ((object5 = (HashSet)hashMap2.get(new MergeLoadMutator$FolderInformation((IPath)object2, this.connectionHandle, iComponentHandle, fileAreaUpdate.getDestinationParent()))) != null) {
                            ((HashSet)object5).add(fileAreaUpdate.getName());
                        }
                        object2 = object2.append(fileAreaUpdate.getName());
                    }
                    if (bl2) {
                        hashMap.put(new MergeLoadMutator$RelativePath(this, (IPath)object2), new HashSet());
                        object = new MergeLoadMutator$FolderInformation((IPath)object2, this.connectionHandle, iComponentHandle, (IFolderHandle)object4);
                        if (object2.segmentCount() == 1) {
                            arrayList.add(object);
                        }
                        hashMap2.put(object, new HashSet());
                    }
                    if ((object = this.getShareable(fileAreaUpdate.getItem(), fileAreaUpdate.component(), null)) != null) {
                        Shareable shareable;
                        object5 = ((Shareable)object).getFileStorage().getParent();
                        Shareable shareable2 = shareable = object5 == null ? null : object5.getShareable();
                        if (shareable == null && object3 != null || shareable != null && !fileAreaUpdate.parent().sameItemId((IItemHandle)shareable.getRemote()) || !fileAreaUpdate.getName().equals(object.getLocalFullPath().lastSegment())) {
                            this.deleteSubtree(object.getLocalFullPath(), (IProgressMonitor)cancellationMonitor);
                            if (object2.segmentCount() == 1) {
                                ((Shareable)object).unshare((IProgressMonitor)cancellationMonitor);
                            } else {
                                ((Shareable)object).forget((IProgressMonitor)cancellationMonitor);
                            }
                        }
                    } else {
                        object5 = copyFileAreaStore.getItemInfo(fileAreaUpdate.getItem(), fileAreaUpdate.component(), this.connectionHandle);
                        if (object5 != null) {
                            if (((FileItemInfo)object5).getParent() == null) {
                                Shareable shareable = this.getNonExistantShareable((FileItemInfo)object5, fileAreaUpdate.component(), this.connectionHandle, (IProgressMonitor)cancellationMonitor);
                                shareable.forget((IProgressMonitor)cancellationMonitor);
                            } else {
                                copyFileAreaStore.deleteTreeInfo(fileAreaUpdate.getItem(), fileAreaUpdate.component(), this.connectionHandle, (IProgressMonitor)cancellationMonitor);
                            }
                        }
                    }
                    if (var18_34 == null || (var18_34.getState() & 8) == 0) {
                        if (bl2) {
                            this.createFolder(fileAreaUpdate.getComponent(), (IPath)object2, (IVersionableHandle)object4, (IProgressMonitor)cancellationMonitor);
                            if (!this.isShareRoot((IComponentHandle)iComponent, fileAreaUpdate.getItem())) {
                                hashMap.remove(new MergeLoadMutator$RelativePath(this, (IPath)object2));
                            }
                            this.contentSession.decrementTransferCount(1);
                            continue;
                        }
                        mergeLoadMutator$DeferredUpdateInformationArray[n] = new MergeLoadMutator$DeferredUpdateInformation((IPath)object2, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent());
                        this.createNewFile(fileAreaUpdate.getComponent(), object2.segments(), (IVersionableHandle)object4, fileAreaUpdate.getTimestamp(), this.repo, fileAreaUpdate.getOptionalContent(), mergeLoadMutator$DeferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    object5 = null;
                    boolean bl3 = bl = var18_34.getFileStorage().isFolder() == bl2;
                    if (bl) {
                        object5 = var18_34.getRemote();
                    }
                    if (!bl || !object4.sameItemId((IItemHandle)object5)) {
                        this.deleteSubtree(var18_34.getLocalFullPath(), (IProgressMonitor)cancellationMonitor);
                        if (object2.segmentCount() == 1) {
                            var18_34.unshare((IProgressMonitor)cancellationMonitor);
                        } else {
                            var18_34.forget((IProgressMonitor)cancellationMonitor);
                        }
                        if (bl2) {
                            this.createFolder(fileAreaUpdate.getComponent(), (IPath)object2, (IVersionableHandle)object4, (IProgressMonitor)cancellationMonitor);
                            hashMap.remove(new MergeLoadMutator$RelativePath(this, (IPath)object2));
                            this.contentSession.decrementTransferCount(1);
                            continue;
                        }
                        mergeLoadMutator$DeferredUpdateInformationArray[n] = new MergeLoadMutator$DeferredUpdateInformation((IPath)object2, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent());
                        this.createNewFile(fileAreaUpdate.getComponent(), object2.segments(), (IVersionableHandle)object4, fileAreaUpdate.getTimestamp(), this.repo, fileAreaUpdate.getOptionalContent(), mergeLoadMutator$DeferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    if (bl2) {
                        Object object6;
                        Object object7;
                        if (object2.segmentCount() == 1) {
                            object7 = (IComponent)this.repo.itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)cancellationMonitor);
                            object6 = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, iComponentHandle, object7.getName(), (IFolderHandle)object4);
                            IShare iShare = var18_34.getShare();
                            if (iShare == null) {
                                try {
                                    SharingManager.getInstance().doSilentChange(new MergeLoadMutator$1(this, (Shareable)var18_34, (SharingDescriptor)object6, cancellationMonitor));
                                }
                                catch (CoreException coreException) {
                                    LoggingHelper.error("com.ibm.team.filesystem.client", "Error sharing into local file area", coreException);
                                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 200, Messages.MergeLoadMutator_2, coreException)));
                                }
                            } else {
                                copyFileAreaStore.setSharingInfo((IShareable)var18_34, (ISharingDescriptor)object6, (IProgressMonitor)cancellationMonitor);
                                FileItemInfo fileItemInfo = new FileItemInfo((IFolderHandle)object4, null, null);
                                copyFileAreaStore.setItemInfo((IShareable)var18_34, fileItemInfo, (IProgressMonitor)cancellationMonitor);
                            }
                        } else if (!object4.sameStateId((IItemHandle)object5)) {
                            object7 = copyFileAreaStore.getItemInfo(object2.removeLastSegments(1));
                            object6 = new FileItemInfo((IFolderHandle)object4, (IFolderHandle)((FileItemInfo)object7).getVersionableHandle(), object2.lastSegment());
                            copyFileAreaStore.setItemInfo((IShareable)var18_34, (FileItemInfo)object6, (IProgressMonitor)cancellationMonitor);
                        }
                        this.contentSession.decrementTransferCount(1);
                        continue;
                    }
                    if (!object4.sameStateId((IItemHandle)object5) || (var18_34.getState() & 4) != 0) {
                        mergeLoadMutator$DeferredUpdateInformationArray[n] = new MergeLoadMutator$DeferredUpdateInformation((IPath)object2, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent(), this.loadLocations.contains(object2));
                        this.modifyFile(iComponentHandle, (IVersionableHandle)object4, this.repo, fileAreaUpdate.getTimestamp(), mergeLoadMutator$DeferredUpdateInformationArray[n], (IProgressMonitor)cancellationMonitor);
                        continue;
                    }
                    this.contentSession.decrementTransferCount(1);
                    continue;
                }
                throw (Throwable)new IllegalStateException("Mutator is intended to only load new files/folders");
            }
        }
        finally {
            this.contentSession.join();
            if (subMonitor.isCanceled()) {
                subMonitor.subTask(Messages.MergeLoadMutator_11);
            } else if (iComponent != null) {
                subMonitor.subTask(NLS.bind((String)Messages.MergeLoadMutator_12, (Object)iComponent.getName()));
            } else {
                subMonitor.subTask(Messages.MergeLoadMutator_10);
            }
            this.updateContentLoadedMetaData(mergeLoadMutator$DeferredUpdateInformationArray, list, (IProgressMonitor)subMonitor);
        }
        IStatus[] object9 = this.getDownloadFailures(mergeLoadMutator$DeferredUpdateInformationArray);
        if (object9.length > 0) {
            IStatus[] iStatusArray = this.getErrors();
            if (iStatusArray.length > 0) {
                IStatus[] iStatusArray2 = new IStatus[object9.length + iStatusArray.length];
                System.arraycopy(iStatusArray, 0, iStatusArray2, 0, iStatusArray.length);
                System.arraycopy(object9, 0, iStatusArray2, iStatusArray.length, object9.length);
                object9 = iStatusArray2;
            }
            RepositoryUtils.throwAppropriateException(Messages.MergeLoadMutator_4, object9);
        } else if (this.contentSession.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
        subMonitor.setWorkRemaining(hashMap.size() + arrayList.size() + hashMap2.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            iComponentHandle = ((MergeLoadMutator$RelativePath)entry.getKey()).path;
            object4 = (HashSet)entry.getValue();
            List list2 = this.getChildren((IPath)iComponentHandle);
            object3 = subMonitor.newChild(1);
            int n = list2.size() * 2;
            object2 = list2.iterator();
            while (object2.hasNext()) {
                void var18_40;
                object3.setWorkRemaining((int)var18_40);
                object = (IShareable)object2.next();
                if (!((HashSet)object4).contains(object.getLocalFullPath().lastSegment())) {
                    if ((object.getState() & 1) == 1) {
                        copyFileAreaStore.deleteTreeInfo((IShareable)object, true, (IProgressMonitor)object3.newChild(1));
                    }
                    if (!object.shouldBeIgnored()) {
                        if (!this.isSpecialCase((IShareable)object)) {
                            this.deleteSubtree(object.getLocalFullPath(), (IProgressMonitor)object3.newChild(1));
                        } else {
                            LocalChangeManager.getInstance().computeChanges((IShareable)object, (IProgressMonitor)object3.newChild(1));
                        }
                    }
                }
                var18_40 -= 2;
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            iComponentHandle = subMonitor.newChild(1);
            object4 = (MergeLoadMutator$FolderInformation)entry.getKey();
            InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo((IVersionableHandle)((MergeLoadMutator$FolderInformation)object4).folderHandle, ((MergeLoadMutator$FolderInformation)object4).component, ((MergeLoadMutator$FolderInformation)object4).connectionHandle);
            if (inverseFileItemInfo != null) {
                object3 = new HashMap(inverseFileItemInfo.getRemoteChildren());
                for (String string : (HashSet)entry.getValue()) {
                    object3.remove(string);
                }
                iComponentHandle.setWorkRemaining(object3.size());
                for (Map.Entry entry2 : object3.entrySet()) {
                    copyFileAreaStore.deleteTreeInfo((IVersionableHandle)entry2.getValue(), ((MergeLoadMutator$FolderInformation)object4).component, ((MergeLoadMutator$FolderInformation)object4).connectionHandle, (IProgressMonitor)iComponentHandle.newChild(1));
                }
            }
            iComponentHandle.done();
        }
        for (MergeLoadMutator$FolderInformation mergeLoadMutator$FolderInformation : arrayList) {
            copyFileAreaStore.setConfigurationState(mergeLoadMutator$FolderInformation.connectionHandle, mergeLoadMutator$FolderInformation.component, mergeLoadMutator$FolderInformation.folderHandle, ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState()), (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private boolean isShareRoot(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle) {
        Set set = (Set)this.roots.get(iComponentHandle.getItemId());
        return set != null && set.contains(iVersionableHandle.getItemId());
    }

    private IStatus[] getDownloadFailures(MergeLoadMutator$DeferredUpdateInformation[] mergeLoadMutator$DeferredUpdateInformationArray) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        MergeLoadMutator$DeferredUpdateInformation[] mergeLoadMutator$DeferredUpdateInformationArray2 = mergeLoadMutator$DeferredUpdateInformationArray;
        int n = mergeLoadMutator$DeferredUpdateInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeLoadMutator$DeferredUpdateInformation mergeLoadMutator$DeferredUpdateInformation = mergeLoadMutator$DeferredUpdateInformationArray2[n2];
            if (mergeLoadMutator$DeferredUpdateInformation != null && mergeLoadMutator$DeferredUpdateInformation.getFailure() != null) {
                Throwable throwable = mergeLoadMutator$DeferredUpdateInformation.getFailure().getCause();
                int n3 = 0;
                while (throwable instanceof TeamRepositoryException && n3 < 50) {
                    Throwable throwable2 = ((TeamRepositoryException)throwable).getCause();
                    if (throwable2 == null) break;
                    throwable = throwable2;
                    ++n3;
                }
                Status status = throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_5, (Object)mergeLoadMutator$DeferredUpdateInformation.getPath(), (Object)mergeLoadMutator$DeferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)mergeLoadMutator$DeferredUpdateInformation.getFailure()) : (throwable instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_1, (Object)mergeLoadMutator$DeferredUpdateInformation.getPath(), (Object)mergeLoadMutator$DeferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)mergeLoadMutator$DeferredUpdateInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_6, (Object)mergeLoadMutator$DeferredUpdateInformation.getPath()), (Throwable)mergeLoadMutator$DeferredUpdateInformation.getFailure()));
                arrayList.add(status);
            }
            ++n2;
        }
        return arrayList.toArray(new IStatus[arrayList.size()]);
    }

    private void updateContentLoadedMetaData(MergeLoadMutator$DeferredUpdateInformation[] mergeLoadMutator$DeferredUpdateInformationArray, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)mergeLoadMutator$DeferredUpdateInformationArray.length);
        subMonitor.setWorkRemaining(mergeLoadMutator$DeferredUpdateInformationArray.length);
        int n = 0;
        while (n < mergeLoadMutator$DeferredUpdateInformationArray.length) {
            if (mergeLoadMutator$DeferredUpdateInformationArray[n] == null || !mergeLoadMutator$DeferredUpdateInformationArray[n].contentUpdated()) {
                subMonitor.worked(1);
            } else {
                FileAreaUpdate fileAreaUpdate = (FileAreaUpdate)list.get(n);
                this.updateMetaInfoForPath(fileAreaUpdate.getComponent(), fileAreaUpdate.afterState(), mergeLoadMutator$DeferredUpdateInformationArray[n], (IProgressMonitor)subMonitor.newChild(1));
            }
            ++n;
        }
        subMonitor.done();
    }

    protected void updateMetaInfoForPath(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, MergeLoadMutator$DeferredUpdateInformation mergeLoadMutator$DeferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IFileStorage iFileStorage = this.pathToIFileStorage(mergeLoadMutator$DeferredUpdateInformation.path);
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(this.getRoot());
        InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo(iVersionableHandle, iComponentHandle, this.connectionHandle);
        FileItemInfo fileItemInfo = copyFileAreaStore.getItemInfo(mergeLoadMutator$DeferredUpdateInformation.path.removeLastSegments(1));
        String[] stringArray = mergeLoadMutator$DeferredUpdateInformation.path.segments();
        IFolderHandle iFolderHandle = null;
        String string = null;
        if (mergeLoadMutator$DeferredUpdateInformation.isUndo) {
            iFolderHandle = ((FileItemInfo)inverseFileItemInfo).getParent();
            string = ((FileItemInfo)inverseFileItemInfo).getName();
        } else {
            iFolderHandle = (IFolderHandle)fileItemInfo.getVersionableHandle();
            string = stringArray[stringArray.length - 1];
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Content content = (Content)mergeLoadMutator$DeferredUpdateInformation.getContent();
        FileItemInfo fileItemInfo2 = new FileItemInfo(iVersionableHandle, iFileStorage.getModificationStamp(), iFolderHandle, string, new HashCode(mergeLoadMutator$DeferredUpdateInformation.getCheckSum()), mergeLoadMutator$DeferredUpdateInformation.getContentSize(), content.getLineDelimiter(), content.getLineDelimiter(), content.getContentType(), content.getContentType(), content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), mergeLoadMutator$DeferredUpdateInformation.isExecutable(), mergeLoadMutator$DeferredUpdateInformation.isExecutable());
        copyFileAreaStore.setItemInfo(iFileStorage.getShareable(), fileItemInfo2, (IProgressMonitor)subMonitor.newChild(50));
        iFileStorage.setExecutable(mergeLoadMutator$DeferredUpdateInformation.isExecutable(), (IProgressMonitor)subMonitor.newChild(50));
        subMonitor.done();
    }

    protected abstract IFileStorage pathToIFileStorage(IPath var1);

    protected abstract boolean isSpecialCase(IShareable var1);

    protected abstract List getChildren(IPath var1) throws FileSystemClientException;

    protected abstract Shareable getShareable(IPath var1);

    private Shareable getShareable(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getLocalPathFor(iVersionableHandle, iComponentHandle, this.connectionHandle, iProgressMonitor);
        return iPath == null ? null : this.getShareable(iPath);
    }

    protected abstract void createNewFile(IComponentHandle var1, String[] var2, IVersionableHandle var3, Date var4, ITeamRepository var5, IContent var6, MergeLoadMutator$DeferredUpdateInformation var7, IProgressMonitor var8) throws FileSystemClientException, TeamRepositoryException;

    public void createFolder(IComponentHandle iComponentHandle, IPath iPath, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStorage iFileStorage = this.createNewFolder(iComponentHandle, iPath.segments(), iVersionableHandle, (IProgressMonitor)subMonitor.newChild(95));
        if (iFileStorage != null) {
            String string;
            IFolderHandle iFolderHandle;
            Object object;
            if (iPath.segmentCount() == 0) {
                return;
            }
            if (iPath.segmentCount() == 1) {
                object = iFileStorage.getShareable();
                IComponent iComponent = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponentHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
                SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, iComponentHandle, iComponent.getName(), (IFolderHandle)iVersionableHandle);
                if (((Shareable)object).getShare() == null) {
                    ((Shareable)object).share(sharingDescriptor, true, (IProgressMonitor)subMonitor.newChild(3));
                } else {
                    CopyFileAreaStore.getCopyFileArea(this.getRoot()).setSharingInfo((IShareable)object, sharingDescriptor, (IProgressMonitor)subMonitor.newChild(3));
                }
                iFolderHandle = null;
                string = null;
            } else {
                object = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getItemInfo(iPath.removeLastSegments(1));
                iFolderHandle = (IFolderHandle)((FileItemInfo)object).getVersionableHandle();
                string = iPath.lastSegment();
                subMonitor.worked(3);
            }
            object = new FileItemInfo((IFolderHandle)iVersionableHandle, iFolderHandle, string);
            CopyFileAreaStore.getCopyFileArea(this.getRoot()).setItemInfo(iFileStorage.getShareable(), (FileItemInfo)object, (IProgressMonitor)subMonitor.newChild(2));
        }
        subMonitor.done();
        this.checkCancelled((IProgressMonitor)subMonitor);
    }

    protected abstract IFileStorage createNewFolder(IComponentHandle var1, String[] var2, IVersionableHandle var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void deleteSubtree(IPath var1, IProgressMonitor var2) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void modifyFile(IComponentHandle var1, IVersionableHandle var2, ITeamRepository var3, Date var4, MergeLoadMutator$DeferredUpdateInformation var5, IProgressMonitor var6) throws FileSystemClientException, TeamRepositoryException;

    protected final IConnection getConnection() {
        return this.connection;
    }

    protected final IPath getRoot() {
        return this.copyFileAreaPath;
    }

    protected void deleteIncompleteFile(IPath iPath) throws TeamRepositoryException {
        this.internalDeleteIncompleteFile(iPath);
    }

    protected final void internalDeleteIncompleteFile(IPath iPath) throws TeamRepositoryException {
        File file = this.getRoot().append(iPath).toFile();
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_0, (Object)iPath));
        }
    }

    protected void storeFileContents(IPath iPath, IContent iContent, IVersionableHandle iVersionableHandle, InputStream inputStream) throws TeamRepositoryException {
        this.internalStoreFileContents(iPath, inputStream);
    }

    protected void internalStoreFileContents(IPath iPath, InputStream inputStream) throws TeamRepositoryException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getRoot().append(iPath).toFile());
            try {
                ContentManager.read((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
        catch (SocketException socketException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_7, (Object)socketException.getMessage()), (Throwable)socketException);
        }
        catch (IOException iOException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)iPath), (Throwable)iOException);
        }
    }

    protected abstract Shareable getNonExistantShareable(FileItemInfo var1, IComponentHandle var2, IContextHandle var3, IProgressMonitor var4) throws FileSystemClientException;

    protected void reportErrorsAsException(IStatus[] iStatusArray) throws FileSystemClientException {
        if (iStatusArray.length == 0) {
            return;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, iStatusArray, NLS.bind((String)Messages.MergeLoadMutator_9, (Object)iStatusArray.length), null);
        throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
    }
}

