/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.LoadMutator;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemLoadMutator$1;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalFileSystemLoadMutator
extends LoadMutator {
    private final File root;
    private final IComponentHandle component;
    private final HashSet loadLocations;
    private HashMap foldersCreated;
    private final HashSet shareRoots;
    private IPath fileSystemRoot;

    public LocalFileSystemLoadMutator(IConnection iConnection, IComponentHandle iComponentHandle, Collection collection, LoadTree loadTree, IPath iPath, Collection collection2, int n, LoadDilemmaHandler loadDilemmaHandler) throws TeamRepositoryException {
        super(iConnection, loadTree, iPath, n, loadDilemmaHandler);
        this.component = iComponentHandle;
        this.fileSystemRoot = iPath;
        this.root = iPath.toFile();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.LocalFileSystemLoadMutator_0, (Object)iPath));
        }
        this.loadLocations = new HashSet();
        for (IVersionableHandle iVersionableHandle : collection2) {
            this.loadLocations.add(PathUtils.getPath((String[])iVersionableHandle));
        }
        this.foldersCreated = new HashMap();
        this.shareRoots = new HashSet();
        for (IVersionableHandle iVersionableHandle : collection) {
            this.shareRoots.add(iVersionableHandle.getItemId());
        }
    }

    protected void deleteRootArea(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = this.getRoot();
        IConnection iConnection = this.getConnection();
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(iPath);
        if (SharingManager.getInstance().isConnectionShared(this.getRoot(), this.getConnectionHandle())) {
            File[] fileArray = iPath.toFile().listFiles();
            int n = 0;
            while (n < fileArray.length) {
                subMonitor.setWorkRemaining(fileArray.length - n);
                ISharingDescriptor iSharingDescriptor = copyFileAreaStore.getSharingInfo((IPath)new Path(fileArray[n].getName()));
                if (iSharingDescriptor != null && iSharingDescriptor.isAssociatedWithConnection(iConnection) && iSharingDescriptor.getComponent().sameItemId((IItemHandle)this.component) && (this.loadLocations.isEmpty() || this.loadLocations.contains(new Path(fileArray[n].getName())))) {
                    this.deleteSubtree(fileArray[n]);
                    ShareableFile shareableFile = new ShareableFile(iPath, fileArray[n]);
                    ((Shareable)shareableFile).forget((IProgressMonitor)subMonitor.newChild(1));
                }
                ++n;
            }
        } else if (this.loadLocations.isEmpty()) {
            File[] fileArray = this.root.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.deleteSubtree(fileArray[n]);
                ++n;
            }
        } else {
            for (IPath iPath2 : this.loadLocations) {
                File file = PathUtils.getFile(this.root, iPath2.segments());
                this.deleteSubtree(file);
            }
        }
        subMonitor.done();
    }

    private IDownloadHandler getDownloadAdapter(DeferredDownloadInformation deferredDownloadInformation, ShareableFile shareableFile, IProgressMonitor iProgressMonitor) {
        return (IDownloadHandler)new LocalFileSystemLoadMutator$1(this, shareableFile, deferredDownloadInformation);
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.deleteSubtree(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    protected IFileStorage pathToIFileStorage(IPath iPath) {
        File file = PathUtils.getFile(this.root, iPath.segments());
        return new LocalFileStorage(this.getRoot(), file);
    }

    protected void createNewFile(IComponent iComponent, DeferredDownloadInformation deferredDownloadInformation, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IFolderHandle iFolderHandle = deferredDownloadInformation.getParent();
        String string = deferredDownloadInformation.getName();
        IPath iPath = (IPath)this.foldersCreated.get(iFolderHandle.getItemId());
        if (iPath == null) {
            if (!iComponent.sameItemId((IItemHandle)iFolderHandle)) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, 367, NLS.bind((String)Messages.LocalFileSystemLoadMutator_2, (Object)string, (Object)iComponent.getName()))));
            }
            iPath = new Path(string);
        } else {
            iPath = iPath.append(string);
        }
        File file = PathUtils.getFile(this.root, iPath.segments());
        file.setLastModified(date.getTime());
        if (file.exists()) {
            this.deleteSubtree(file);
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 367, NLS.bind((String)Messages.LocalFileSystemLoadMutator_3, (Object)file.getPath()), iOException)));
        }
        if (deferredDownloadInformation.getContent() != null) {
            this.contentSession.retrieveContent(deferredDownloadInformation.getContent(), this.getDownloadAdapter(deferredDownloadInformation, new ShareableFile(this.getRoot(), file), iProgressMonitor));
        }
    }

    protected IFileStorage createNewFolder(IComponent iComponent, IFolderHandle iFolderHandle, String string, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IPath iPath = (IPath)this.foldersCreated.get(iFolderHandle.getItemId());
        if (iPath == null) {
            if (!this.isShareRoot(iComponent, iVersionableHandle)) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemLoadMutator_4, (Object)string, (Object)iComponent.getName()))));
            }
            iPath = new Path(string);
        } else {
            iPath = iPath.append(string);
        }
        File file = PathUtils.getFile(this.root, iPath.segments());
        if (file.exists()) {
            this.deleteSubtree(file);
            if (iPath.segmentCount() == 1) {
                ShareableFile shareableFile = new ShareableFile(this.getRoot(), file);
                ((Shareable)shareableFile).forget(iProgressMonitor);
            }
        }
        if (!file.mkdir()) {
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemLoadMutator_5, (Object)iPath.toString()))));
        }
        this.foldersCreated.put(iVersionableHandle.getItemId(), iPath);
        return new LocalFileStorage(this.getRoot(), file);
    }

    private boolean isShareRoot(IComponent iComponent, IVersionableHandle iVersionableHandle) {
        return this.shareRoots.contains(iVersionableHandle.getItemId());
    }

    protected void updateMetaData(DeferredDownloadInformation deferredDownloadInformation, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Shareable shareable = deferredDownloadInformation.getShareable();
        if (shareable instanceof ShareableFile) {
            File file = ((ShareableFile)shareable).getFile();
            if (this.isMaintainShareable()) {
                Content content = (Content)deferredDownloadInformation.getContent();
                LineDelimiter lineDelimiter = content.getLineDelimiter();
                String string = content.getContentType();
                FileItemInfo fileItemInfo = new FileItemInfo((IVersionableHandle)deferredDownloadInformation.getFileItem(), file.lastModified(), deferredDownloadInformation.getParent(), deferredDownloadInformation.getName(), new HashCode(deferredDownloadInformation.getChecksum()), deferredDownloadInformation.getContentSize(), lineDelimiter, lineDelimiter, string, string, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), deferredDownloadInformation.isExecutable(), deferredDownloadInformation.isExecutable());
                try {
                    CopyFileAreaStore.getCopyFileArea(this.getRoot()).setItemInfo(deferredDownloadInformation.getShareable(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LocalFileSystemLoadMutator_6, (Object)deferredDownloadInformation.getShareable().getLocalFullPath()), (Throwable)((Object)fileSystemClientException));
                }
            }
            ((ShareableFile)shareable).getFileStorage().setExecutable(deferredDownloadInformation.isExecutable(), (IProgressMonitor)subMonitor.newChild(50));
            subMonitor.done();
        }
    }
}

