/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.LoadMutator$DeferredShareInformation;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class LoadMutator
extends FileSystemOperation {
    public static final int NONE = 0;
    public static final int MAINTAIN_SHARE_INFO = 1;
    protected final IPath root;
    private final int flags;
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    protected IContentManagerSession contentSession;
    private ArrayList sharePaths;
    private LoadTree loadTree;
    private ITeamRepository teamRepository;

    public LoadMutator(IConnection iConnection, LoadTree loadTree, IPath iPath, int n, LoadDilemmaHandler loadDilemmaHandler) throws TeamRepositoryException {
        super(loadDilemmaHandler == null ? LoadDilemmaHandler.getDefault() : loadDilemmaHandler);
        this.teamRepository = iConnection.teamRepository();
        if (iPath == null || iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (loadTree == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            this.connectionHandle = (IContextHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace();
        } else if (iConnection instanceof IBaselineConnection) {
            this.connectionHandle = (IContextHandle)((IBaselineConnection)iConnection).getBaseline();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        this.root = iPath;
        this.flags = n;
        this.loadTree = loadTree;
        this.connection = iConnection;
    }

    protected final void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        this.beginning((IProgressMonitor)subMonitor.newChild(5));
        this.doRun((IProgressMonitor)subMonitor.newChild(90));
        this.ending((IProgressMonitor)subMonitor.newChild(5));
        subMonitor.done();
    }

    /*
     * Unable to fully structure code
     */
    protected final void doRun(IProgressMonitor var1_1) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        var2_2 = this.loadTree.getFileAreaUpdates();
        this.contentSession = this.teamRepository.contentManager().createSession(NLS.bind((String)Messages.LoadMutator_0, (Object)this.connection.getName()), true, (long)var2_2.size(), var1_1);
        var3_3 = new CancellationMonitor(var1_1);
        var4_4 = null;
        var5_5 = 0;
        var6_6 = new DeferredDownloadInformation[var2_2.size()];
        try {
            for (IStatus[] var7_8 : var2_2) {
                if (!var7_8.component().sameItemId((IItemHandle)var4_4)) {
                    var4_4 = (IComponent)this.teamRepository.itemManager().fetchCompleteItem((IItemHandle)var7_8.component(), 0, null);
                }
                if (var7_8.isChangeType(1)) {
                    var9_9 = var7_8.getDestinationParent();
                    if (var7_8.getItem() instanceof IFolderHandle) {
                        this.createFolder(var4_4, var9_9, var7_8.getName(), (IFolderHandle)var7_8.afterState(), (IProgressMonitor)var3_3);
                        this.contentSession.decrementTransferCount(1);
                    } else {
                        var6_6[var5_5] = new DeferredDownloadInformation((FileAreaUpdate)var7_8);
                        this.createFile(var4_4, var6_6[var5_5], var7_8.getTimestamp(), (IProgressMonitor)var3_3);
                    }
                }
                if (var7_8.isChangeType(8)) {
                    throw (Throwable)new IllegalStateException(Messages.LoadMutator_1);
                }
                if (var7_8.isChangeType(4)) {
                    throw (Throwable)new IllegalStateException(Messages.LoadMutator_2);
                }
                if (var7_8.isChangeType(2)) {
                    throw (Throwable)new IllegalStateException(Messages.LoadMutator_3);
                }
                if (var7_8.isChangeType(16)) {
                    this.contentSession.decrementTransferCount(1);
                }
                ++var5_5;
            }
        }
        finally {
            this.contentSession.join();
            var14_12 = var6_6;
            var13_14 = var6_6.length;
            var12_16 = 0;
            ** while (var12_16 < var13_14)
        }
lbl-1000:
        // 1 sources

        {
            var11_18 = var14_12[var12_16];
            if (var11_18 != null && var11_18.contentUpdated()) {
                this.updateMetaData(var11_18, (IProgressMonitor)var3_3);
            }
            ++var12_16;
            continue;
        }
lbl42:
        // 1 sources

        var7_8 = this.getDownloadFailures(var6_6);
        if (var7_8.length > 0) {
            RepositoryUtils.throwAppropriateException(Messages.LoadMutator_4, var7_8);
        } else if (this.contentSession.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    private IStatus[] getDownloadFailures(DeferredDownloadInformation[] deferredDownloadInformationArray) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        DeferredDownloadInformation[] deferredDownloadInformationArray2 = deferredDownloadInformationArray;
        int n = deferredDownloadInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredDownloadInformation deferredDownloadInformation = deferredDownloadInformationArray2[n2];
            if (deferredDownloadInformation != null && deferredDownloadInformation.getFailure() != null) {
                Throwable throwable = deferredDownloadInformation.getFailure().getCause();
                int n3 = 0;
                while (throwable instanceof TeamRepositoryException && n3 < 50) {
                    Throwable throwable2 = ((TeamRepositoryException)throwable).getCause();
                    if (throwable2 == null) break;
                    throwable = throwable2;
                    ++n3;
                }
                Status status = throwable instanceof UnsupportedEncodingException || throwable instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_5, (Object)deferredDownloadInformation.getShareable().getLocalFullPath(), (Object)deferredDownloadInformation.getContent().getCharacterEncoding()), (Throwable)deferredDownloadInformation.getFailure()) : (throwable instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_8, (Object)deferredDownloadInformation.getShareable().getLocalFullPath(), (Object)deferredDownloadInformation.getContent().getCharacterEncoding()), (Throwable)deferredDownloadInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LoadMutator_6, (Object)deferredDownloadInformation.getShareable().getLocalFullPath()), (Throwable)deferredDownloadInformation.getFailure()));
                arrayList.add(status);
            }
            ++n2;
        }
        return arrayList.toArray(new IStatus[arrayList.size()]);
    }

    protected abstract void updateMetaData(DeferredDownloadInformation var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected void beginning(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.deleteRootArea(iProgressMonitor);
        this.sharePaths = new ArrayList();
    }

    protected abstract void deleteRootArea(IProgressMonitor var1) throws FileSystemClientException;

    protected void checkCancelled(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    protected boolean isMaintainShareable() {
        return (this.flags & 1) == 1;
    }

    protected abstract void createNewFile(IComponent var1, DeferredDownloadInformation var2, Date var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract IFileStorage createNewFolder(IComponent var1, IFolderHandle var2, String var3, IVersionableHandle var4, IProgressMonitor var5) throws FileSystemClientException, TeamRepositoryException;

    protected final IConnection getConnection() {
        return this.connection;
    }

    protected final IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected final IPath getRoot() {
        return this.root;
    }

    public final void createFile(IComponent iComponent, DeferredDownloadInformation deferredDownloadInformation, Date date, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.setTaskName(NLS.bind((String)Messages.LoadMutator_7, (Object)deferredDownloadInformation.getName()));
        this.createNewFile(iComponent, deferredDownloadInformation, date, (IProgressMonitor)subMonitor.newChild(75));
    }

    public final void createFolder(IComponent iComponent, IFolderHandle iFolderHandle, String string, IFolderHandle iFolderHandle2, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStorage iFileStorage = this.createNewFolder(iComponent, iFolderHandle, string, (IVersionableHandle)iFolderHandle2, (IProgressMonitor)subMonitor.newChild(75));
        if (iFileStorage != null && this.isMaintainShareable()) {
            FileItemInfo fileItemInfo;
            IPath iPath = iFileStorage.getFullPath();
            if (iFolderHandle == null) {
                return;
            }
            if (iPath.segmentCount() == 1) {
                Shareable shareable = iFileStorage.getShareable();
                IComponent iComponent2 = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)iComponent, 0, (IProgressMonitor)subMonitor.newChild(1));
                SharingDescriptor sharingDescriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)iComponent, iComponent2.getName(), iFolderHandle2);
                if (shareable.getShare() == null) {
                    shareable.share(sharingDescriptor, true, (IProgressMonitor)subMonitor.newChild(12));
                } else {
                    CopyFileAreaStore.getCopyFileArea(this.root).setSharingInfo(shareable, sharingDescriptor, (IProgressMonitor)subMonitor.newChild(12));
                }
                LoadMutator$DeferredShareInformation loadMutator$DeferredShareInformation = new LoadMutator$DeferredShareInformation(iPath, this.connectionHandle, (IComponentHandle)iComponent, iFolderHandle2);
                this.sharePaths.add(loadMutator$DeferredShareInformation);
                fileItemInfo = new FileItemInfo(iFolderHandle2, null, null);
            } else {
                fileItemInfo = new FileItemInfo(iFolderHandle2, iFolderHandle, string);
            }
            CopyFileAreaStore.getCopyFileArea(this.root).setItemInfo(iFileStorage.getShareable(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(12));
        }
        this.checkCancelled((IProgressMonitor)subMonitor.newChild(0));
        subMonitor.done();
    }

    protected void ending(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.sharePaths.size());
        if (this.isMaintainShareable()) {
            for (LoadMutator$DeferredShareInformation loadMutator$DeferredShareInformation : this.sharePaths) {
                CopyFileAreaStore.getCopyFileArea(this.root).setConfigurationState(loadMutator$DeferredShareInformation.connectionHandle, loadMutator$DeferredShareInformation.component, loadMutator$DeferredShareInformation.shareRootItem, ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState()), (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }
}

