/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class JazzIgnoreFile {
    public static final String PROP_IGNORE_LOCAL = "core.ignore";
    public static final String PROP_IGNORE_GLOBAL = "core.global.ignore";
    public static final String IGNORE_GLOBAL_DEFAULT = "*.class";
    public static final String IGNORE_LOCAL_ROOT_DEFAULT = "bin";
    public static final String[] DEFAULT_PROP_IGNORE_LOCAL = new String[]{"bin"};
    public static final String[] DEFAULT_PROP_IGNORE_GLOBAL = new String[]{"*.class"};
    private final DefaultIgnoreProvider provider;
    private final IShareable file;
    private final IPath root;
    private final SortedSet rules;
    private final long lastModified;
    private long size = -2L;

    protected JazzIgnoreFile(DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable) {
        this.provider = defaultIgnoreProvider;
        this.file = iShareable;
        this.root = this.getRootShareable().getLocalFullPath();
        this.rules = new TreeSet(IgnoreRuleComparator.INSTANCE);
        this.lastModified = -1L;
    }

    public JazzIgnoreFile(DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable, SortedSet sortedSet, long l, long l2) {
        if (sortedSet.comparator() == null || !(sortedSet.comparator() instanceof IgnoreRuleComparator)) {
            throw (Throwable)new IllegalArgumentException("Must create a new ignore file with an ignore rule comparator.");
        }
        this.provider = defaultIgnoreProvider;
        this.file = iShareable;
        this.root = this.getRootShareable().getLocalFullPath();
        this.rules = sortedSet;
        this.lastModified = l;
        this.size = l2;
    }

    public int hashCode() {
        return this.file.getLocalFullPath().hashCode();
    }

    private static boolean isGlobal(IPath iPath) {
        return iPath.segmentCount() == 2;
    }

    public boolean isGlobal() {
        return JazzIgnoreFile.isGlobal(this.file.getLocalFullPath());
    }

    public SortedSet getRules() {
        return this.rules;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public IShareable getRootShareable() {
        return this.getParentFor(this.file);
    }

    public IPath getRootPath() {
        return this.root;
    }

    public IShareable getFile() {
        return this.file;
    }

    private IShareable getParentFor(IShareable iShareable) {
        return ((Shareable)iShareable).getParent();
    }

    public Collection computeComplement(Collection collection) {
        LinkedList<IgnoreRule> linkedList = new LinkedList<IgnoreRule>();
        for (IgnoreRule ignoreRule : collection) {
            if (this.rules.contains(ignoreRule)) continue;
            linkedList.add(ignoreRule);
        }
        return linkedList;
    }

    public JazzIgnoreFile addRules(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SortedSet sortedSet = this.copyRules();
        sortedSet.addAll(collection);
        return IgnoreFileLoader.getInstance().createNew(this.getFile(), this.getProvider(), sortedSet);
    }

    public JazzIgnoreFile removeRules(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SortedSet sortedSet = this.copyRules();
        for (IgnoreRule ignoreRule : collection) {
            sortedSet.remove(ignoreRule);
        }
        return IgnoreFileLoader.getInstance().createNew(this.getFile(), this.getProvider(), sortedSet);
    }

    public SortedSet copyRules() {
        TreeSet treeSet = new TreeSet(IgnoreRuleComparator.INSTANCE);
        treeSet.addAll(this.rules);
        return treeSet;
    }

    public DefaultIgnoreProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findIgnoreReasons(IPath iPath) {
        ArrayList<IgnoreRule> arrayList = null;
        JazzIgnoreFile jazzIgnoreFile = this;
        synchronized (jazzIgnoreFile) {
            for (IgnoreRule ignoreRule : this.rules) {
                if (!ignoreRule.shouldBeIgnored(iPath)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<IgnoreRule>(this.rules.size());
                }
                arrayList.add(ignoreRule);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        JazzIgnoreFile jazzIgnoreFile = this;
        synchronized (jazzIgnoreFile) {
            return "JazzIgnoreFile(" + this.file.getLocalFullPath().toString() + ", " + this.rules + ")";
        }
    }
}

