/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreRule;
import com.ibm.team.filesystem.client.internal.utils.StringMatcher;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public abstract class IgnoreRule
implements IIgnoreProvider$IIgnoreRule {
    protected final StringMatcher matcher;
    protected final IShareable file;
    protected final DefaultIgnoreProvider provider;
    private List matched = null;

    public IgnoreRule(IShareable iShareable, DefaultIgnoreProvider defaultIgnoreProvider, String string, boolean bl, boolean bl2) {
        this.file = iShareable;
        this.provider = defaultIgnoreProvider;
        this.matcher = new StringMatcher(string, bl, bl2);
    }

    public StringMatcher getMatcher() {
        return this.matcher;
    }

    public abstract boolean isGlobal();

    public boolean isLocal() {
        return !this.isGlobal();
    }

    public IShareable getFile() {
        return this.file;
    }

    public IShareable getRootShareable() {
        return ((Shareable)this.file).getParent();
    }

    public boolean equals(Object object) {
        if (object instanceof IgnoreRule) {
            IgnoreRule ignoreRule = (IgnoreRule)object;
            return this.matcher.getPattern().equals(ignoreRule.getMatcher().getPattern()) && this.getFile().equals(ignoreRule.getFile()) && this.isGlobal() == ignoreRule.isGlobal();
        }
        return false;
    }

    public int hashCode() {
        return this.matcher.getPattern().hashCode() ^ this.getFile().hashCode();
    }

    public boolean shouldBeIgnored(IPath iPath) {
        String string = iPath.lastSegment();
        return this.matcher.match(string);
    }

    public synchronized void forceMatched(List list) {
        Assert.isTrue((boolean)this.isTrivial(), (String)"We don't currently support saving matches of patterns with wildcards");
        if (this.matched != null) {
            throw (Throwable)new IllegalStateException("Match list may only be set once");
        }
        this.matched = list;
    }

    public boolean shouldBeIgnored(IShareable iShareable) {
        return this.shouldBeIgnored(iShareable.getLocalFullPath());
    }

    public abstract boolean isEffectiveBelow(IShareable var1);

    public List getEffectiveFrom() {
        return Collections.singletonList(this.getRootShareable());
    }

    public IIgnoreProvider getProvider() {
        return this.provider;
    }

    public abstract boolean isTrivial();

    public String toString() {
        return String.valueOf(this.isGlobal() ? "GLOBAL" : "LOCAL") + ":/" + this.matcher.getPattern() + "/";
    }
}

