/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EraSyncReportFragment {
    private List<ItemId<IChangeSet>> changeSets;
    private Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeStates;
    private Set<ItemId<IChangeSet>> closes;
    private static EraSyncReportFragment emptyReport = new EraSyncReportFragment();

    private EraSyncReportFragment() {
        this.changeSets = Collections.emptyList();
        this.activeChangeStates = Collections.emptyMap();
        this.closes = Collections.emptySet();
    }

    public EraSyncReportFragment(List<ItemId<IChangeSet>> changeSets) {
        this.changeSets = changeSets;
        this.activeChangeStates = Collections.emptyMap();
        this.closes = Collections.emptySet();
    }

    public EraSyncReportFragment(List<ItemId<IChangeSet>> changeSets, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeStates, Set<ItemId<IChangeSet>> closes) {
        this.changeSets = changeSets;
        this.activeChangeStates = activeChangeStates;
        this.closes = closes;
    }

    public List<ItemId<IChangeSet>> getChangeSets() {
        return this.changeSets;
    }

    public Map<ItemId<IChangeSet>, StateId<IChangeSet>> getActiveChangeStates() {
        return this.activeChangeStates;
    }

    public Set<ItemId<IChangeSet>> getCloses() {
        return this.closes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.activeChangeStates == null ? 0 : this.activeChangeStates.hashCode());
        result = 31 * result + (this.changeSets == null ? 0 : this.changeSets.hashCode());
        result = 31 * result + (this.closes == null ? 0 : this.closes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EraSyncReportFragment other = (EraSyncReportFragment)obj;
        if (this.activeChangeStates == null ? other.activeChangeStates != null : !this.activeChangeStates.equals(other.activeChangeStates)) {
            return false;
        }
        if (this.changeSets == null ? other.changeSets != null : !this.changeSets.equals(other.changeSets)) {
            return false;
        }
        return !(this.closes == null ? other.closes != null : !this.closes.equals(other.closes));
    }

    public static EraSyncReportFragment emptyReport() {
        return emptyReport;
    }

    public boolean isEmpty() {
        return this.activeChangeStates.isEmpty() && this.closes.isEmpty() && this.changeSets.isEmpty();
    }

    public Set<StateId<IVersionable>> getAfterStates(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<ItemId<IChangeSet>> inactiveChangeSets = new HashSet<ItemId<IChangeSet>>();
        inactiveChangeSets.addAll(this.getChangeSets());
        inactiveChangeSets.removeAll((Collection)this.getActiveChangeStates().keySet());
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repo, inactiveChangeSets, (IProgressMonitor)progress.newChild(50));
        Map fetchedActive = RepoFetcher.fetchItems((ITeamRepository)repo, this.getActiveChangeStates().values(), (IProgressMonitor)progress.newChild(50));
        ArrayList changeSets = new ArrayList();
        changeSets.addAll(fetched.values());
        changeSets.addAll(fetchedActive.values());
        HashSet<StateId<IVersionable>> afterStates = new HashSet<StateId<IVersionable>>();
        for (IChangeSet next : changeSets) {
            for (IChange nextChange : next.changes()) {
                afterStates.add((StateId<IVersionable>)ChangeSetUtil.getAfterState((IChange)nextChange));
            }
        }
        return afterStates;
    }
}

