/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock$1;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock$2;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock$ThreadInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.util.NLS;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class BatchingLock {
    private static final boolean DEBUG = System.getProperty("filesystem.debug.batchingLock", "false").equals("true");
    static final ISchedulingRule NULL_SCHEDULING_RULE = new BatchingLock$1();
    static final ISchedulingRule AVOID_NOTIFICATION_RULE = new BatchingLock$2();
    private Map infos = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchingLock$ThreadInfo getThreadInfo() {
        Thread thread = Thread.currentThread();
        Map map = this.infos;
        synchronized (map) {
            BatchingLock$ThreadInfo batchingLock$ThreadInfo = (BatchingLock$ThreadInfo)this.infos.get(thread);
            return batchingLock$ThreadInfo;
        }
    }

    private ISchedulingRule getRuleForResoure(ISchedulingRule iSchedulingRule) {
        return iSchedulingRule == null ? NULL_SCHEDULING_RULE : iSchedulingRule;
    }

    public boolean isLocked(ISchedulingRule iSchedulingRule) {
        ISchedulingRule iSchedulingRule2 = this.getRuleForResoure(iSchedulingRule);
        if (iSchedulingRule2 == AVOID_NOTIFICATION_RULE || iSchedulingRule2 == NULL_SCHEDULING_RULE) {
            return false;
        }
        BatchingLock$ThreadInfo batchingLock$ThreadInfo = this.getThreadInfo();
        if (batchingLock$ThreadInfo == null) {
            return false;
        }
        return batchingLock$ThreadInfo.ruleConflicts(iSchedulingRule2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ISchedulingRule acquire(ISchedulingRule var1_1, IFlushOperation var2_2, ILockParticipant var3_3, boolean var4_4, IProgressMonitor var5_5) {
        if (var5_5 == null) {
            var5_5 = new NullProgressMonitor();
        }
        var5_5.beginTask("", 1);
        var6_6 = this.getThreadInfo();
        var7_7 = false;
        var8_8 = Thread.currentThread();
        if (var6_6 == null) {
            var6_6 = this.createThreadInfo(var2_2);
            var9_9 = this.infos;
            // MONITORENTER : var9_9
            this.infos.put(var8_8, var6_6);
            // MONITOREXIT : var9_9
            var7_7 = true;
            if (BatchingLock.DEBUG) {
                System.out.println("[" + var8_8.getName() + "] acquired batching lock on " + var1_1);
            }
        }
        var9_9 = null;
        var10_10 = var5_5 instanceof IProgressMonitorWithBlocking != false ? (IProgressMonitorWithBlocking)var5_5 : null;
        var11_11 = true;
        var12_12 = false;
        try {
            var1_1 = var3_3.locking(var1_1);
            var13_13 = this.getRuleForResoure(var1_1);
            while (true) {
                block50: {
                    block51: {
                        block48: {
                            block49: {
                                if (var5_5.isCanceled()) {
                                    throw (Throwable)new OperationCanceledException();
                                }
                                if (var13_13 == BatchingLock.AVOID_NOTIFICATION_RULE || var13_13 == BatchingLock.NULL_SCHEDULING_RULE) ** GOTO lbl43
                                if (!var11_11) {
                                    ThreadCheck.checkLongOpsAllowed();
                                    var11_11 = true;
                                }
                                var14_14 /* !! */  = null;
                                var15_15 = null;
                                var16_17 = this.infos;
                                // MONITORENTER : var16_17
                                var17_18 /* !! */  = this.infos.entrySet().iterator();
                                if (true) ** GOTO lbl68
lbl43:
                                // 1 sources

                                var14_14 /* !! */  = var6_6.pushRule(var13_13);
                                var12_12 = true;
                                var21_26 = var14_14 /* !! */ ;
                                if (!var12_12 && var7_7) {
                                    var22_29 = this.infos;
                                    // MONITORENTER : var22_29
                                    this.infos.remove(Thread.currentThread());
                                    // MONITOREXIT : var22_29
                                }
                                if (var9_9 != null) {
                                    var10_10.clearBlocked();
                                }
                                var5_5.done();
                                return var21_26;
                                do {
                                    var18_20 = var17_18 /* !! */ .next();
                                    var19_24 = (BatchingLock$ThreadInfo)var18_20.getValue();
                                    if (var18_20.getKey() == var8_8 || !var19_24.ruleConflicts(var13_13)) continue;
                                    var14_14 /* !! */  = var19_24;
                                    var15_15 = (Thread)var18_20.getKey();
                                    break;
lbl68:
                                    // 2 sources

                                } while (var17_18 /* !! */ .hasNext());
                                if (var14_14 /* !! */  != null) break block48;
                                var17_18 /* !! */  = var6_6.pushRule(var13_13);
                                var12_12 = true;
                                var21_25 = var17_18 /* !! */ ;
                                // MONITOREXIT : var16_17
                                if (var12_12 || !var7_7) break block49;
                                var22_27 = this.infos;
                                // MONITORENTER : var22_27
                                this.infos.remove(Thread.currentThread());
                                // MONITOREXIT : var22_27
                            }
                            if (var9_9 != null) {
                                var10_10.clearBlocked();
                            }
                            var5_5.done();
                            return var21_25;
                        }
                        // MONITOREXIT : var16_17
                        var16_16 = false;
                        var17_18 /* !! */  = BatchingLock$ThreadInfo.access$0((BatchingLock$ThreadInfo)var14_14 /* !! */ );
                        // MONITORENTER : var17_18 /* !! */ 
                        if (!var14_14 /* !! */ .ruleConflicts(var13_13)) ** GOTO lbl146
                        if (var4_4) break block50;
                        // MONITOREXIT : var17_18 /* !! */ 
                        if (var12_12 || !var7_7) break block51;
                        var22_28 = this.infos;
                        this.infos.remove(Thread.currentThread());
                        // MONITOREXIT : var22_28
                    }
                    if (var9_9 != null) {
                        var10_10.clearBlocked();
                    }
                    var5_5.done();
                    return null;
                }
                if (var5_5.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                if (var10_10 != null) {
                    if (BatchingLock$ThreadInfo.access$1((BatchingLock$ThreadInfo)var14_14 /* !! */ ) != null) {
                        var18_21 = BatchingLock$ThreadInfo.access$1((BatchingLock$ThreadInfo)var14_14 /* !! */ ).getName();
                    } else {
                        var18_22 = var15_15.getName();
                    }
                    if (!var18_23.equals(var9_9)) {
                        var19_24 = NLS.bind((String)Messages.BatchingLock_0, (Object[])new Object[]{var18_23});
                        if (var9_9 != null) {
                            var9_9 = null;
                            var10_10.clearBlocked();
                        }
                        var10_10.setBlocked((IStatus)new Status(1, "com.ibm.team.filesystem.client", 1, (String)var19_24, null));
                        var9_9 = var18_23;
                    }
                }
                var3_3.waiting();
                var16_16 = true;
                try {
                    BatchingLock$ThreadInfo.access$0((BatchingLock$ThreadInfo)var14_14 /* !! */ ).wait(500L);
                }
                catch (InterruptedException v6) {}
lbl146:
                // 3 sources

                if (!var16_16) continue;
                var1_1 = var3_3.locking(var1_1);
                var13_13 = this.getRuleForResoure(var1_1);
                continue;
                break;
            }
        }
        catch (Throwable var20_31) {
            if (!var12_12 && var7_7) {
                var22_30 = this.infos;
                // MONITORENTER : var22_30
                this.infos.remove(Thread.currentThread());
                // MONITOREXIT : var22_30
            }
            if (var9_9 != null) {
                var10_10.clearBlocked();
            }
            var5_5.done();
            throw var20_31;
        }
    }

    protected BatchingLock$ThreadInfo createThreadInfo(IFlushOperation iFlushOperation) {
        return new BatchingLock$ThreadInfo(this, iFlushOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        BatchingLock$ThreadInfo batchingLock$ThreadInfo = this.getThreadInfo();
        Assert.isNotNull((Object)batchingLock$ThreadInfo, (String)"Unmatched acquire/release.");
        Assert.isTrue((boolean)batchingLock$ThreadInfo.isNested(), (String)"Unmatched acquire/release.");
        batchingLock$ThreadInfo.popRule(iSchedulingRule, iProgressMonitor);
        if (!batchingLock$ThreadInfo.isNested()) {
            Thread thread = Thread.currentThread();
            if (DEBUG) {
                System.out.println("[" + thread.getName() + "] released batching lock");
            }
            Map map = this.infos;
            synchronized (map) {
                this.infos.remove(thread);
            }
        }
    }

    public void addChange(ICopyFileAreaEvent iCopyFileAreaEvent) {
        BatchingLock$ThreadInfo batchingLock$ThreadInfo = this.getThreadInfo();
        Assert.isNotNull((Object)batchingLock$ThreadInfo, (String)"Folder changed outside of resource lock");
        batchingLock$ThreadInfo.addChange(iCopyFileAreaEvent);
    }

    public void flush(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        BatchingLock$ThreadInfo batchingLock$ThreadInfo = this.getThreadInfo();
        Assert.isNotNull((Object)batchingLock$ThreadInfo, (String)"Flush requested outside of resource lock");
        batchingLock$ThreadInfo.flush(iProgressMonitor);
    }
}

