/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.SharingManager$CoreRunnable;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SharingManager$$Cold {
    public static /* synthetic */ void clear(SharingManager sharingManager) {
        Collection collection = CopyFileAreaStore.getAllCopyFileAreas();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((CopyFileAreaStore)iterator.next()).clear();
        }
    }

    public static /* synthetic */ ISharingMetadata createSharingMetadata(SharingManager sharingManager, IPath iPath) {
        Assert.isLegal((iPath != null ? 1 : 0) != 0);
        IPath iPath2 = sharingManager.getMetadataPathForRoot(iPath);
        return new MetadataChangeTracker(new SharingMetadata2(iPath, iPath2), iPath, iPath2);
    }

    public static final /* synthetic */ void doSilentChange(SharingManager sharingManager, SharingManager$CoreRunnable sharingManager$CoreRunnable) {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            sharingManager$CoreRunnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public static /* synthetic */ IShareable findShareable(SharingManager sharingManager, IPath iPath, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath.equals((Object)sharingManager.getDefaultCFARoot())) {
            throw (Throwable)new IllegalStateException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath2 = CopyFileAreaStore.getCopyFileArea(iPath).getLocalPathFor(iVersionableHandle, iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(100));
        subMonitor.done();
        if (iPath2 == null) {
            return null;
        }
        File file = new File(iPath.toFile(), iPath2.toString());
        if (!file.exists()) {
            return null;
        }
        return new ShareableFile(iPath, file);
    }

    public static /* synthetic */ IShareable findShareable(SharingManager sharingManager, IPath iPath, IPath iPath2, boolean bl) {
        if (iPath.equals((Object)sharingManager.getDefaultCFARoot())) {
            throw (Throwable)new IllegalStateException();
        }
        File file = iPath.toFile();
        File file2 = new File(file, iPath2.toString());
        return new ShareableFile(iPath, file2);
    }

    public static /* synthetic */ List findShareables(SharingManager sharingManager, IPath iPath, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = CopyFileAreaStore.getCopyFileArea(iPath).getLocalItemPaths(iVersionableHandle, iComponentHandle, (IProgressMonitor)subMonitor.newChild(100));
        List list = sharingManager.getShareablesForPaths(iPath, collection);
        subMonitor.done();
        return list;
    }

    public static /* synthetic */ List findShareables(SharingManager sharingManager, IPath iPath, IVersionableHandle iVersionableHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = CopyFileAreaStore.getCopyFileArea(iPath).getLocalItemPaths(iVersionableHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(100));
        List list = sharingManager.getShareablesForPaths(iPath, collection);
        subMonitor.done();
        return list;
    }

    public static /* synthetic */ List findShareables(SharingManager sharingManager, IPath iPath, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = CopyFileAreaStore.getCopyFileArea(iPath).getLocalItemPaths(iVersionableHandle, (IProgressMonitor)subMonitor.newChild(100));
        List list = sharingManager.getShareablesForPaths(iPath, collection);
        subMonitor.done();
        return list;
    }

    public static /* synthetic */ void forget(SharingManager sharingManager, IShareable iShareable, IProgressMonitor iProgressMonitor) {
        IShare iShare = iShareable.getShare();
        boolean bl = iShare != null && iShare.getPath().equals((Object)iShareable.getLocalFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(bl ? 100 : 50));
        CopyFileAreaStore.getCopyFileArea(iShareable.getRoot()).deleteTreeInfo(iShareable, true, (IProgressMonitor)subMonitor.newChild(50));
        if (bl) {
            CopyFileAreaStore.getCopyFileArea(iShareable.getRoot()).removeSharingInfo(iShareable, (IProgressMonitor)subMonitor.newChild(50));
        }
        subMonitor.done();
    }

    public static /* synthetic */ IShare[] getAllShares(SharingManager sharingManager, CopyFileAreaStore copyFileAreaStore) {
        IPath[] iPathArray = copyFileAreaStore.allSharePaths();
        ArrayList<Share> arrayList = new ArrayList<Share>(iPathArray.length);
        int n = 0;
        while (n < iPathArray.length) {
            ISharingDescriptor iSharingDescriptor = copyFileAreaStore.getSharingInfo(iPathArray[n]);
            if (iSharingDescriptor != null) {
                arrayList.add(sharingManager.createShare(iSharingDescriptor, iPathArray[n], copyFileAreaStore));
            }
            ++n;
        }
        return arrayList.toArray(new IShare[arrayList.size()]);
    }

    public static /* synthetic */ ILocalChange getChange(SharingManager sharingManager, Shareable shareable) {
        boolean bl;
        IShare iShare = shareable.getShare();
        boolean bl2 = bl = iShare != null;
        if (!bl) {
            return NoOpChange.NO_OP;
        }
        if (shareable.shouldBeIgnored()) {
            return null;
        }
        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
        ILocalChange iLocalChange = LocalChangeManager.getInstance().getPendingChange(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent(), shareable);
        return iLocalChange == null ? NoOpChange.NO_OP : iLocalChange;
    }

    public static /* synthetic */ FileItemInfo getItemInfo(SharingManager sharingManager, IShareable iShareable) {
        return CopyFileAreaStore.getCopyFileArea(iShareable.getRoot()).getItemInfo(iShareable.getLocalFullPath());
    }

    public static /* synthetic */ List getPathRelativeToShares(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) {
        Object object2;
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(iPath);
        Collection collection = copyFileAreaStore.getShares(iContextHandle, iComponentHandle, iProgressMonitor);
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (Object object2 : collection) {
            hashSet.add(object2.getRootFolder().getItemId());
        }
        object2 = new ArrayList();
        for (Object object3 : list) {
            boolean bl = false;
            IPath iPath2 = null;
            if (!hashSet.isEmpty()) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    INameItemPair iNameItemPair = (INameItemPair)iterator.next();
                    if (bl) {
                        iPath2 = iPath2.append(iNameItemPair.getName());
                        continue;
                    }
                    if (!hashSet.contains(iNameItemPair.getItem().getItemId())) continue;
                    bl = true;
                    iPath2 = new Path(iNameItemPair.getName());
                }
            }
            object2.add(iPath2);
        }
        return (List)object2;
    }

    public static /* synthetic */ ITeamRepository getRepository(SharingManager sharingManager, IShare iShare) {
        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
        return RepositoryUtils.getTeamRepository(iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getRepositoryId());
    }

    public static /* synthetic */ List getRootShareables(SharingManager sharingManager, IPath iPath) {
        if (iPath.equals((Object)sharingManager.getDefaultCFARoot())) {
            throw (Throwable)new IllegalStateException();
        }
        File file = iPath.toFile();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ShareableFile> arrayList = new ArrayList<ShareableFile>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            arrayList.add(new ShareableFile(iPath, file2));
            ++n2;
        }
        return arrayList;
    }

    public static /* synthetic */ Share getShare(SharingManager sharingManager, IShareable iShareable) {
        return sharingManager.getShare(iShareable.getRoot(), iShareable.getLocalFullPath());
    }

    public static /* synthetic */ Share getShare(SharingManager sharingManager, CopyFileAreaStore copyFileAreaStore, String string) {
        Assert.isNotNull((Object)copyFileAreaStore);
        Path path = new Path(string);
        ISharingDescriptor iSharingDescriptor = copyFileAreaStore.getSharingInfo((IPath)path);
        if (iSharingDescriptor == null) {
            return null;
        }
        return sharingManager.createShare(iSharingDescriptor, (IPath)path, copyFileAreaStore);
    }

    public static /* synthetic */ Share getShare(SharingManager sharingManager, IPath iPath, IPath iPath2) {
        ISharingDescriptor iSharingDescriptor = null;
        iPath2 = iPath2.removeLastSegments(iPath2.segmentCount() - 1);
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(iPath);
        iSharingDescriptor = copyFileAreaStore.getSharingInfo(iPath2);
        if (iSharingDescriptor == null) {
            return null;
        }
        return sharingManager.createShare(iSharingDescriptor, iPath2, copyFileAreaStore);
    }

    public static /* synthetic */ List getShareablesForPaths(SharingManager sharingManager, IPath iPath, Collection collection) {
        if (iPath.equals((Object)sharingManager.getDefaultCFARoot())) {
            throw (Throwable)new IllegalStateException();
        }
        ArrayList<ShareableFile> arrayList = new ArrayList<ShareableFile>(collection.size());
        File file = iPath.toFile();
        for (IPath iPath2 : collection) {
            File file2 = new File(file, iPath2.toString());
            if (!file2.exists()) continue;
            arrayList.add(new ShareableFile(iPath, file2));
        }
        return arrayList;
    }

    public static /* synthetic */ int getState(SharingManager sharingManager, IShareable iShareable) {
        IVersionableHandle iVersionableHandle;
        int n = 0;
        Shareable shareable = (Shareable)iShareable;
        if (shareable.isLocal()) {
            n |= 8;
        }
        if (!sharingManager.isShared(iShareable)) {
            return n;
        }
        n |= 1;
        IFileStorage iFileStorage = shareable.getFileStorage();
        FileItemInfo fileItemInfo = null;
        fileItemInfo = CopyFileAreaStore.getCopyFileArea(iShareable.getRoot()).getItemInfo(iFileStorage.getFullPath());
        if (fileItemInfo != null && fileItemInfo.isFolder() == shareable.getFileStorage().isFolder() && (iVersionableHandle = fileItemInfo.getVersionableHandle()).hasStateId()) {
            n |= 2;
            if (!fileItemInfo.isFolder() && (fileItemInfo.getLastModification() == -1L || iFileStorage.getModificationStamp() != fileItemInfo.getLastModification() || fileItemInfo.getOriginalLineDelimiter() != fileItemInfo.getLineDelimiter() || fileItemInfo.getOriginalContentType() == null && fileItemInfo.getContentType() != null || fileItemInfo.getOriginalContentType() != null && !fileItemInfo.getOriginalContentType().equals(fileItemInfo.getContentType()) || fileItemInfo.isOriginalExecutable() != iFileStorage.isExecutable())) {
                n |= 4;
            }
        }
        return n;
    }

    public static /* synthetic */ ISchedulingRule getTrackingRule(SharingManager sharingManager, IPath iPath) {
        if (iPath.equals((Object)sharingManager.getDefaultCFARoot())) {
            throw (Throwable)new IllegalStateException();
        }
        return null;
    }

    public static /* synthetic */ UpdateMutator getUpdateMutator(SharingManager sharingManager, IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, IPath iPath) {
        return new LocalFileSystemUpdateMutator(iConnection, collection, collection2, fileAreaUpdateReport, iPath, (DilemmaHandler)UpdateDilemmaHandler.getDefault());
    }

    public static /* synthetic */ void setItemInfo(SharingManager sharingManager, IShareable iShareable, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) {
        CopyFileAreaStore.getCopyFileArea(iShareable.getRoot()).setItemInfo(iShareable, fileItemInfo, iProgressMonitor);
    }

    public static /* synthetic */ IShare share(SharingManager sharingManager, Shareable shareable, ISharingDescriptor iSharingDescriptor, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = shareable.getLocalFullPath();
        if (!shareable.getFileStorage().isFolder()) {
            throw (Throwable)new IllegalArgumentException(iPath + " cannot be shared. Only Folders can be shared");
        }
        if (!iSharingDescriptor.getRootFolder().hasStateId()) {
            throw (Throwable)new IllegalArgumentException(iPath + " cannot be shared. Root folder has no state id");
        }
        Share share = sharingManager.getShare(shareable);
        if (share != null) {
            if (bl) {
                sharingManager.forget(shareable, (IProgressMonitor)subMonitor.newChild(50));
            } else {
                FileSystemStatus fileSystemStatus = share.getSharingDescriptor() != null && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)share.getSharingDescriptor().getConnectionHandle()) ? new FileSystemStatus(4, 334, NLS.bind((String)Messages.SharingManager_0, (Object[])new Object[]{iPath})) : new FileSystemStatus(4, 366, NLS.bind((String)Messages.SharingManager_1, (Object[])new Object[]{iPath}));
                throw (Throwable)((Object)new FileSystemClientException(fileSystemStatus));
            }
        }
        subMonitor.setWorkRemaining(bl2 ? 300 : 100);
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
        copyFileAreaStore.setSharingInfo(shareable, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(50));
        copyFileAreaStore.setItemInfo(shareable, new FileItemInfo(iSharingDescriptor.getRootFolder(), null, null), (IProgressMonitor)subMonitor.newChild(50));
        Share share2 = sharingManager.createShare(iSharingDescriptor, iPath, copyFileAreaStore);
        if (bl2 && sharingManager.isChangeMonitoringEnabled()) {
            LocalChangeManager.getInstance().loadChanges(share2, (IProgressMonitor)subMonitor.newChild(200));
        }
        subMonitor.done();
        return share2;
    }

    public static /* synthetic */ void shutDown(SharingManager sharingManager) {
        Collection collection = CopyFileAreaStore.getAllCopyFileAreas();
        ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
        for (CopyFileAreaStore copyFileAreaStore : collection) {
            try {
                copyFileAreaStore.close();
            }
            catch (Exception exception) {
                arrayList.add(FileSystemStatus.getStatusFor(exception));
            }
        }
        int n = arrayList.size();
        if (n != 0) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, arrayList.toArray(new IStatus[n]), Messages.SharingManager_2, null)));
        }
    }
}

