/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ShareableFile
extends Shareable
implements IShareable {
    private final File file;
    private final IPath root;
    private final IPath fullPath;

    public ShareableFile(IPath iPath, File file) {
        this.root = iPath;
        this.file = file;
        String string = file.getPath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.ShareableFile_0, (Object[])new Object[]{string}), iOException);
        }
        this.fullPath = new Path(string).removeFirstSegments(this.root.segmentCount()).setDevice(null).makeAbsolute();
    }

    public ShareableFile(IPath iPath, IPath iPath2) {
        this(iPath, iPath.append(iPath2).toFile());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShareableFile)) {
            return false;
        }
        return this.root.equals((Object)((ShareableFile)object).root) && this.file.equals(((ShareableFile)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public IFileStorage getFileStorage() {
        return new LocalFileStorage(this.root, this.file);
    }

    public IPath getLocalFullPath() {
        return this.fullPath;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    public IPath getRoot() {
        return this.root;
    }

    public Shareable getShareableFor(IPath iPath, boolean bl) {
        return new ShareableFile(this.root, iPath);
    }

    public void visit(IShareableVisitor iShareableVisitor, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.file.exists() && this.file.isDirectory() && n != 0) {
            File[] fileArray = this.file.listFiles();
            subMonitor.setWorkRemaining(fileArray.length);
            int n2 = 0;
            while (n2 < fileArray.length) {
                SubMonitor subMonitor2 = subMonitor.newChild(1);
                subMonitor2.setWorkRemaining(100);
                ShareableFile shareableFile = new ShareableFile(this.root, fileArray[n2]);
                boolean bl = iShareableVisitor.visit(shareableFile, (IProgressMonitor)subMonitor2.newChild(5));
                if (bl) {
                    shareableFile.visit(iShareableVisitor, n - 1, (IProgressMonitor)subMonitor2.newChild(95));
                }
                ++n2;
            }
        }
    }

    public boolean isLocal() {
        return this.file.exists();
    }

    public String toString() {
        return NLS.bind((String)Messages.ShareableFile_1, (Object[])new Object[]{this.file});
    }

    public File getFile() {
        return this.file;
    }
}

