/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.ScmPackage;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EClass;

public class Share
implements IShare,
IVersionableTree {
    private ISharingDescriptor descriptor;
    private final IPath root;
    private IPath anchor;

    public Share(ISharingDescriptor iSharingDescriptor, IPath iPath, CopyFileAreaStore copyFileAreaStore) {
        Assert.isNotNull((Object)iSharingDescriptor, (String)"Sharing Descriptor is null");
        this.descriptor = iSharingDescriptor;
        this.root = iPath;
        this.anchor = copyFileAreaStore.getRoot();
        this.getTracker();
    }

    public IPath getPath() {
        if (this.descriptor == null) {
            throw (Throwable)new IllegalStateException("Not shared anymore");
        }
        return this.root;
    }

    public ISharingDescriptor getSharingDescriptor() {
        if (this.descriptor == null) {
            throw (Throwable)new IllegalStateException("Not shared anymore");
        }
        return this.descriptor;
    }

    void invalidate() {
        this.descriptor = null;
    }

    public IPath getAnchor() {
        return this.anchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Share)) {
            return false;
        }
        Share share = (Share)object;
        return this.anchor.equals((Object)share.anchor) && this.root.equals((Object)share.root) && this.descriptor.equals(share.descriptor);
    }

    public int hashCode() {
        return this.anchor.hashCode() ^ this.root.hashCode() ^ this.descriptor.hashCode();
    }

    public CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getCopyFileArea(this.anchor);
    }

    public LocalChangeTracker getTracker() {
        return LocalChangeManager.getInstance().getTracker(this, this.descriptor.getConnectionHandle(), this.descriptor.getComponent(), this.getAnchor(), SharingManager.getInstance().getTrackingRule(this.getAnchor()));
    }

    public IShareable getShareable(IPath iPath, boolean bl) {
        return new ShareableFile(this.anchor, this.anchor.append(iPath).toFile());
    }

    public IVersionableHandle createVersionable(IPath iPath, IItemType iItemType, IProgressMonitor iProgressMonitor) {
        block5: {
            try {
                if (this.isVersionable(iItemType)) break block5;
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not create versionable for " + iPath + " " + iItemType.getNamespaceURI() + " " + iItemType.getName(), null);
                return null;
            }
            catch (FileSystemClientException fileSystemClientException) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not create versionable for " + iPath, (Throwable)((Object)fileSystemClientException));
                return null;
            }
        }
        IVersionable iVersionable = (IVersionable)iItemType.createItem();
        boolean bl = iItemType == IFolder.ITEM_TYPE;
        IShareable iShareable = this.getShareable(iPath, bl);
        IVersionableHandle iVersionableHandle = (IVersionableHandle)iItemType.createItemHandle(iVersionable.getItemId(), null);
        if (bl) {
            this.getCopyFileArea().setItemInfo(iShareable, new FileItemInfo((IFolderHandle)iVersionableHandle, null, null), iProgressMonitor);
        } else {
            this.getCopyFileArea().setItemInfo(iShareable, new FileItemInfo(iVersionableHandle, -1L, null, null, null, -1L, null, null, null, null, null, null, -1L, null, -1L, -1L, false, false), iProgressMonitor);
        }
        return iVersionableHandle;
    }

    private boolean isVersionable(IItemType iItemType) {
        EClass eClass = (EClass)iItemType.getAdapter(EClass.class);
        if (eClass == null) {
            return false;
        }
        return ScmPackage.eINSTANCE.getVersionable().isSuperTypeOf(eClass);
    }

    public void restoreVersionable(IPath iPath, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        try {
            IShareable iShareable = this.getShareable(iPath, iVersionableHandle instanceof IFolderHandle);
            CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
            InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo(iVersionableHandle, this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
            Assert.isTrue((inverseFileItemInfo != null ? 1 : 0) != 0);
            Assert.isTrue((((FileItemInfo)inverseFileItemInfo).getParent() != null ? 1 : 0) != 0);
            copyFileAreaStore.setItemInfo(iShareable, new FileItemInfo(((FileItemInfo)inverseFileItemInfo).getVersionableHandle(), -1L, ((FileItemInfo)inverseFileItemInfo).getParent(), ((FileItemInfo)inverseFileItemInfo).getName(), ((FileItemInfo)inverseFileItemInfo).getHash(), ((FileItemInfo)inverseFileItemInfo).getContentLength(), ((FileItemInfo)inverseFileItemInfo).getOriginalLineDelimiter(), ((FileItemInfo)inverseFileItemInfo).getLineDelimiter(), ((FileItemInfo)inverseFileItemInfo).getOriginalContentType(), ((FileItemInfo)inverseFileItemInfo).getContentType(), ((FileItemInfo)inverseFileItemInfo).getStoredContentId(), ((FileItemInfo)inverseFileItemInfo).getStoredDeltaPredecessor(), ((FileItemInfo)inverseFileItemInfo).getStoredSize(), ((FileItemInfo)inverseFileItemInfo).getStoredEncoding(), ((FileItemInfo)inverseFileItemInfo).getStoredChecksum(), ((FileItemInfo)inverseFileItemInfo).getStoredNumLineDelimiters(), ((FileItemInfo)inverseFileItemInfo).isOriginalExecutable(), ((FileItemInfo)inverseFileItemInfo).isOriginalExecutable()), iProgressMonitor);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Could not restore versionable for " + iPath, (Throwable)((Object)fileSystemClientException));
        }
    }

    public IVersionableHandle getVersionableHandle(IPath iPath) {
        FileItemInfo fileItemInfo = this.getCopyFileArea().getItemInfo(iPath);
        return fileItemInfo == null ? null : fileItemInfo.getVersionableHandle();
    }

    public IVersionableHandle getDeletedVersionable(IFolderHandle iFolderHandle, String string, IProgressMonitor iProgressMonitor) {
        return this.getCopyFileArea().getDeletedItem(iFolderHandle, string, this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), iProgressMonitor);
    }

    public boolean isLocked() {
        return this.getCopyFileArea().isLocked(this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
    }

    public ISchedulingRule lock(IProgressMonitor iProgressMonitor) {
        return this.getCopyFileArea().lock(this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), iProgressMonitor);
    }

    public void unlock(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getCopyFileArea().release(iSchedulingRule, iProgressMonitor);
    }

    public List getChangedItems() {
        try {
            return SharingManager.getInstance().getChangeTracker(this.getCopyFileArea()).getLocalChanges(this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Failed to retrieve changed item infos", (Throwable)((Object)fileSystemClientException));
            return Collections.EMPTY_LIST;
        }
    }

    public void trackFileChange(IVersionableHandle iVersionableHandle, IPath iPath) {
        try {
            SharingManager.getInstance().getChangeTracker(this.getCopyFileArea()).setContentChanged(iVersionableHandle, iPath, this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Failed to set file as modified", (Throwable)((Object)fileSystemClientException));
        }
    }

    public void refreshChanges(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        LocalChangeManager.getInstance().refreshChanges(this, iShareable, iProgressMonitor);
    }

    public void syncChanges() {
        this.getTracker().syncChanges();
    }

    public String toString() {
        return this.root + " @ " + this.getAnchor();
    }
}

