/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorage$RuleKind;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation$LockData;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RestoreVersionableOperation {
    private RestoreVersionableOperation() {
    }

    public static void restoreFile(IShareable iShareable, InputStream inputStream, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IOException {
        if (inputStream == null) {
            throw (Throwable)new NullPointerException();
        }
        try {
            Shareable shareable;
            IFileStorage iFileStorage;
            IFileStorage iFileStorage2;
            if (iShareable == null) {
                throw (Throwable)new NullPointerException();
            }
            if (iVersionableHandle == null) {
                throw (Throwable)new NullPointerException();
            }
            if (iVersionableHandle.getItemId() == null) {
                throw (Throwable)new NullPointerException();
            }
            if (iVersionableHandle instanceof IFolderHandle) {
                throw (Throwable)new IllegalArgumentException("Cannot give a file a versionable of type folder");
            }
            if (iVersionableHandle.hasStateId() || iVersionableHandle.hasFullState()) {
                iVersionableHandle = (IVersionableHandle)iVersionableHandle.getItemType().createItemHandle(iVersionableHandle.getItemId(), null);
            }
            if ((iFileStorage2 = (iFileStorage = (shareable = (Shareable)iShareable).getFileStorage()).getParent()) == null) {
                throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalFullPath() + " outside of share");
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            RestoreVersionableOperation$LockData restoreVersionableOperation$LockData = RestoreVersionableOperation.lockTree(iFileStorage2, (IProgressMonitor)subMonitor.newChild(5));
            if (restoreVersionableOperation$LockData == null) {
                throw (Throwable)new IllegalArgumentException(shareable.getLocalFullPath() + " is not in a shared location");
            }
            try {
                FileItemInfo fileItemInfo;
                if (iFileStorage.exists()) {
                    throw (Throwable)new IllegalArgumentException(shareable.getLocalFullPath() + " already exists");
                }
                if (!iFileStorage2.exists()) {
                    throw (Throwable)new IllegalArgumentException("Parent folder " + iFileStorage2.getFullPath() + " does not exist");
                }
                if (!iFileStorage2.isFolder()) {
                    throw (Throwable)new IllegalArgumentException("Parent " + iFileStorage2.getFullPath() + " is not a folder");
                }
                IShare iShare = shareable.getShare();
                if (iShare.getPath().equals((Object)shareable.getLocalFullPath())) {
                    throw (Throwable)new IllegalArgumentException("Cannot restore file at share root");
                }
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
                if (copyFileAreaStore.isShareRoot((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(iVersionableHandle.getItemId(), null), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())) {
                    throw (Throwable)new IllegalArgumentException(iVersionableHandle.getItemId() + " already exists");
                }
                InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo(iVersionableHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                if (inverseFileItemInfo != null) {
                    if (inverseFileItemInfo.getLocalName() != null) {
                        throw (Throwable)new IllegalArgumentException(iVersionableHandle.getItemId() + " already exists");
                    }
                    if (inverseFileItemInfo.getVersionableHandle().getItemType() != iVersionableHandle.getItemType()) {
                        throw (Throwable)new IllegalArgumentException("Type mismatch, existing: " + inverseFileItemInfo.getVersionableHandle().getItemType().getName() + ", restoring: " + iVersionableHandle.getItemType().getName());
                    }
                    fileItemInfo = new FileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isOriginalExecutable(), inverseFileItemInfo.isOriginalExecutable());
                } else {
                    fileItemInfo = new FileItemInfo(iVersionableHandle, -1L, null, null, null, -1L, null, null, null, null, null, null, -1L, null, -1L, -1L, false, false);
                }
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    iFileStorage.create(inputStream, (IProgressMonitor)subMonitor.newChild(60));
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                copyFileAreaStore.setItemInfo(shareable, fileItemInfo, (IProgressMonitor)subMonitor.newChild(30));
            }
            finally {
                RestoreVersionableOperation.unlockTree(restoreVersionableOperation$LockData, (IProgressMonitor)subMonitor.newChild(5));
            }
            inputStream.close();
            inputStream = null;
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void restoreFolder(IShareable iShareable, IFolderHandle iFolderHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Shareable shareable;
        IFileStorage iFileStorage;
        IFileStorage iFileStorage2;
        if (iShareable == null) {
            throw (Throwable)new NullPointerException();
        }
        if (iFolderHandle == null || iFolderHandle.getItemId() == null) {
            throw (Throwable)new NullPointerException();
        }
        if (iFolderHandle.hasStateId() || iFolderHandle.hasFullState()) {
            iFolderHandle = (IFolderHandle)iFolderHandle.getItemType().createItemHandle(iFolderHandle.getItemId(), null);
        }
        if ((iFileStorage2 = (iFileStorage = (shareable = (Shareable)iShareable).getFileStorage()).getParent()) == null) {
            throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalFullPath() + " outside of share");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        RestoreVersionableOperation$LockData restoreVersionableOperation$LockData = RestoreVersionableOperation.lockTree(iFileStorage, (IProgressMonitor)subMonitor.newChild(5));
        if (restoreVersionableOperation$LockData == null) {
            throw (Throwable)new IllegalArgumentException(shareable.getLocalFullPath() + " is not in a shared location");
        }
        try {
            FileItemInfo fileItemInfo;
            if (iFileStorage.exists()) {
                throw (Throwable)new IllegalArgumentException(shareable.getLocalFullPath() + " already exists");
            }
            if (!iFileStorage2.exists()) {
                throw (Throwable)new IllegalArgumentException("Parent folder " + iFileStorage2.getFullPath() + " does not exist");
            }
            if (!iFileStorage2.isFolder()) {
                throw (Throwable)new IllegalArgumentException("Parent " + iFileStorage2.getFullPath() + " is not a folder");
            }
            IShare iShare = shareable.getShare();
            if (iShare.getPath().equals((Object)shareable.getLocalFullPath())) {
                throw (Throwable)new IllegalArgumentException("Cannot restore folder at share root");
            }
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
            if (copyFileAreaStore.isShareRoot(iFolderHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())) {
                throw (Throwable)new IllegalArgumentException(iFolderHandle.getItemId() + " already exists");
            }
            InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo((IVersionableHandle)iFolderHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            if (inverseFileItemInfo != null) {
                if (inverseFileItemInfo.getLocalName() != null) {
                    throw (Throwable)new IllegalArgumentException(iFolderHandle.getItemId() + " already exists");
                }
                if (inverseFileItemInfo.getVersionableHandle().getItemType() != iFolderHandle.getItemType()) {
                    throw (Throwable)new IllegalArgumentException("Type mismatch, existing: " + inverseFileItemInfo.getVersionableHandle().getItemType().getName() + ", restoring: " + iFolderHandle.getItemType().getName());
                }
                fileItemInfo = new FileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), false, false);
            } else {
                fileItemInfo = new FileItemInfo(iFolderHandle, null, null);
            }
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                iFileStorage.create((IProgressMonitor)subMonitor.newChild(30));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            copyFileAreaStore.setItemInfo(shareable, fileItemInfo, (IProgressMonitor)subMonitor.newChild(60));
        }
        finally {
            RestoreVersionableOperation.unlockTree(restoreVersionableOperation$LockData, (IProgressMonitor)subMonitor.newChild(5));
        }
    }

    private static RestoreVersionableOperation$LockData lockTree(IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = iFileStorage.getRule(IFileStorage$RuleKind.CREATE);
        boolean bl = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(50));
            CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(iFileStorage.getShareable().getRoot());
            ISchedulingRule iSchedulingRule2 = copyFileAreaStore.lock(iFileStorage.getShareable(), (IProgressMonitor)subMonitor.newChild(50));
            if (iSchedulingRule2 == null) {
                return null;
            }
            RestoreVersionableOperation$LockData restoreVersionableOperation$LockData = new RestoreVersionableOperation$LockData(iSchedulingRule, iSchedulingRule2, copyFileAreaStore.getRoot());
            bl = true;
            RestoreVersionableOperation$LockData restoreVersionableOperation$LockData2 = restoreVersionableOperation$LockData;
            return restoreVersionableOperation$LockData2;
        }
        finally {
            if (!bl) {
                Job.getJobManager().endRule(iSchedulingRule);
            }
        }
    }

    private static void unlockTree(RestoreVersionableOperation$LockData restoreVersionableOperation$LockData, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(restoreVersionableOperation$LockData.cfaPath);
            copyFileAreaStore.release(restoreVersionableOperation$LockData.cfaRule, iProgressMonitor);
        }
        finally {
            Job.getJobManager().endRule(restoreVersionableOperation$LockData.fsRule);
        }
    }
}

