/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.ReadWriteLock$1;
import com.ibm.team.filesystem.client.internal.ReadWriteLock$LockStatus;
import com.ibm.team.repository.common.LogFactory;

public class ReadWriteLock {
    private final ReadWriteLock$LockStatus status = new ReadWriteLock$LockStatus(null);
    private final ThreadLocal threadStatus = new ReadWriteLock$1(this);

    public void acquireRead() {
        this.acquireRead(true);
    }

    public boolean tryAcquireRead() {
        return this.acquireRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireRead(boolean bl) {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.getThreadLockStatus();
            boolean bl2 = false;
            while (this.status.writes != 0 && this.status.writes != readWriteLock$LockStatus2.writes) {
                if (!bl) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)interruptedException);
                }
            }
            ++this.status.reads;
            ++readWriteLock$LockStatus2.reads;
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    public void acquireWrite() {
        this.acquireWrite(true);
    }

    public boolean tryAcquireWrite() {
        return this.acquireWrite(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireWrite(boolean bl) {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.getThreadLockStatus();
            boolean bl2 = false;
            while (true) {
                if (this.status.writes == 0) {
                    if (this.status.reads == 0) break;
                    if (readWriteLock$LockStatus2.reads > 0) {
                        throw (Throwable)new IllegalStateException("nesting of write lock inside read lock is illegal");
                    }
                } else {
                    if (this.status.writes == readWriteLock$LockStatus2.writes) break;
                    if (!bl) {
                        return false;
                    }
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)interruptedException);
                }
            }
            ++this.status.writes;
            ++readWriteLock$LockStatus2.writes;
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        boolean bl;
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.getThreadLockStatus();
            if (this.status.reads > 0) {
                if (readWriteLock$LockStatus2.reads == 0) {
                    throw (Throwable)new IllegalStateException("releasing read lock outside of locking thread is illegal");
                }
                --this.status.reads;
                --readWriteLock$LockStatus2.reads;
            } else if (this.status.writes > 0) {
                if (readWriteLock$LockStatus2.writes == 0) {
                    throw (Throwable)new IllegalStateException("releasing write lock outside of locking thread is illegal");
                }
                --this.status.writes;
                --readWriteLock$LockStatus2.writes;
            } else {
                throw (Throwable)new IllegalStateException("releasing an unlocked lock is illegal");
            }
            bl = this.locks() == 0;
            this.status.notifyAll();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reads() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.reads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writes() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.writes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int locks() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.reads + this.status.writes;
        }
    }

    public int threadReads() {
        return this.getThreadLockStatus().reads;
    }

    public int threadWrites() {
        return this.getThreadLockStatus().writes;
    }

    public int threadLocks() {
        return this.getThreadLockStatus().reads + this.getThreadLockStatus().writes;
    }

    private ReadWriteLock$LockStatus getThreadLockStatus() {
        return (ReadWriteLock$LockStatus)this.threadStatus.get();
    }

    public String toString() {
        return "reads: " + this.threadReads() + "/" + this.reads() + " - writes: " + this.threadWrites() + "/" + this.writes();
    }
}

