/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ITransaction;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LocalChangeInfo;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$1;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$2;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$ChangeDiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$ChangeKey;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$ChangeType;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.content.util.DBHMException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class MetadataChangeTracker
implements ISharingMetadata,
IMetadataChangeTracker {
    private static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    private static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    private static final int METADATA_VERSION = 1;
    protected ISharingMetadata delegate;
    protected IPath cfaRoot;
    protected IPath basePath;
    protected PersistentHeapManager heapMgr;
    protected MetadataChangeTracker$ChangeDiskBackedMapManager mapMgr;
    protected ReadWriteLock globalLock;

    private void setCorrupt(DBHMException dBHMException) {
        this.setCorrupt(true, dBHMException.getMessage(), dBHMException.getCause());
    }

    public MetadataChangeTracker(ISharingMetadata iSharingMetadata, IPath iPath, IPath iPath2) {
        this.delegate = iSharingMetadata;
        this.cfaRoot = iPath;
        this.basePath = iPath2;
        this.heapMgr = new PersistentHeapManager();
        this.globalLock = new ReadWriteLock();
        this.mapMgr = new MetadataChangeTracker$ChangeDiskBackedMapManager(this, this.globalLock, iSharingMetadata.getPersistentMetadataFlag(), this);
    }

    public void accept(IVisitor iVisitor, IPath iPath, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (bl) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(iVisitor, iPath, n, bl, iProgressMonitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    public void accept(IRemoteVisitor iRemoteVisitor, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (bl) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(iRemoteVisitor, iVersionableHandle, iComponentHandle, iContextHandle, n, bl, iProgressMonitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    public IPath[] allShares() throws FileSystemClientException {
        return this.delegate.allShares();
    }

    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
            this.delegate.clear();
        }
        finally {
            this.globalLock.release();
        }
    }

    public void close() throws FileSystemClientException {
        this.delegate.close();
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
        }
        finally {
            this.globalLock.release();
        }
    }

    private void notifyTracker(IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        LocalChangeTracker localChangeTracker = LocalChangeManager.getInstance().findTracker(iContextHandle, iComponentHandle, this.cfaRoot);
        if (localChangeTracker != null) {
            localChangeTracker.metadataChanged();
        }
    }

    public FileItemInfo deleteFileItemInfo(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Path path = new Path(iPath.segment(0));
        ISharingDescriptor iSharingDescriptor = this.getSharingDescriptor((IPath)path);
        if (iSharingDescriptor != null) {
            LockableMap lockableMap = this.getMapFor(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            try {
                try {
                    this.delegate.accept(new MetadataChangeTracker$1(this, lockableMap), iPath, Integer.MAX_VALUE, false, (IProgressMonitor)subMonitor.newChild(50));
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(true, "Failed to delete item info", dBHMException.getCause());
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_2, dBHMException.getCause())));
                }
            }
            finally {
                this.releaseMap(lockableMap);
            }
        }
        subMonitor.setWorkRemaining(50);
        return this.delegate.deleteFileItemInfo(iPath, (IProgressMonitor)subMonitor.newChild(50));
    }

    public boolean isCaseSensitive() {
        return this.delegate.isCaseSensitive();
    }

    public Map getChildInfos(IPath iPath) throws FileSystemClientException {
        return this.delegate.getChildInfos(iPath);
    }

    public FileItemInfo getFileItemInfo(IPath iPath) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(iPath);
    }

    public InverseFileItemInfo getFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
    }

    public Collection getLocations(IVersionableHandle iVersionableHandle) throws FileSystemClientException {
        return this.delegate.getLocations(iVersionableHandle);
    }

    public IPath getPathForShareRoot(IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getPathForShareRoot(iFolderHandle, iComponentHandle, iContextHandle);
    }

    public ISharingDescriptor getSharingDescriptor(IPath iPath) throws FileSystemClientException {
        return this.delegate.getSharingDescriptor(iPath);
    }

    public FileItemInfo moveFileItemInfo(IPath iPath, IPath iPath2) throws FileSystemClientException {
        return this.delegate.moveFileItemInfo(iPath, iPath2);
    }

    public void run(ISharingMetadata$ITransaction iSharingMetadata$ITransaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.delegate.run(iSharingMetadata$ITransaction);
        }
        finally {
            this.globalLock.release();
        }
    }

    private IFileStorage getStorage(IPath iPath, ISharingDescriptor iSharingDescriptor, IPath iPath2, boolean bl) {
        Share share = SharingManager.getInstance().createShare(iSharingDescriptor, iPath2, CopyFileAreaStore.getCopyFileArea(this.cfaRoot));
        Shareable shareable = (Shareable)share.getShareable(iPath, bl);
        return shareable.getFileStorage();
    }

    private boolean isIgnored(IPath iPath, ISharingDescriptor iSharingDescriptor, IPath iPath2) {
        SharingManager sharingManager = SharingManager.getInstance();
        Share share = sharingManager.createShare(iSharingDescriptor, iPath2, CopyFileAreaStore.getCopyFileArea(this.cfaRoot));
        IShareable iShareable = share.getShareable(iPath, false);
        sharingManager.disableChangeMonitoring();
        try {
            boolean bl = iShareable.shouldBeIgnored();
            return bl;
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public void setContentChanged(IVersionableHandle iVersionableHandle, IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        MetadataChangeTracker$ChangeKey metadataChangeTracker$ChangeKey = new MetadataChangeTracker$ChangeKey(iVersionableHandle);
        LockableMap lockableMap = this.getMapFor(iComponentHandle, iContextHandle);
        try {
            try {
                LocalChangeInfo localChangeInfo = (LocalChangeInfo)lockableMap.entries().get(metadataChangeTracker$ChangeKey);
                boolean bl = localChangeInfo == null ? false : localChangeInfo.inverseMapChanged();
                lockableMap.entries().put(metadataChangeTracker$ChangeKey, new LocalChangeInfo(bl, true));
                this.notifyTracker(iComponentHandle, iContextHandle);
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Could not tag content as changed", dBHMException.getCause());
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_3, dBHMException.getCause())));
            }
        }
        finally {
            this.releaseMap(lockableMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLocalChanges(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        LockableMap lockableMap = this.getMapFor(iComponentHandle, iContextHandle, false);
        HashMap hashMap = new HashMap();
        try {
            ArrayList<MetadataChangeTracker$ChangeType> arrayList;
            Map map = lockableMap.entries();
            synchronized (map) {
                arrayList = new ArrayList<MetadataChangeTracker$ChangeType>(lockableMap.entries().size());
                block18: for (Map.Entry entry : lockableMap.entries().entrySet()) {
                    boolean bl;
                    InverseFileItemInfo inverseFileItemInfo;
                    Object object;
                    IPath iPath;
                    IPath iPath2;
                    Object object2;
                    IVersionableHandle iVersionableHandle = ((MetadataChangeTracker$ChangeKey)entry.getKey()).item;
                    LocalChangeInfo localChangeInfo = (LocalChangeInfo)entry.getValue();
                    InverseFileItemInfo inverseFileItemInfo2 = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                    int n = !localChangeInfo.inverseMapChanged() ? 0 : (inverseFileItemInfo2.getParent() == null ? 4 : (inverseFileItemInfo2.getLocalParent() == null ? (this.getPathForShareRoot(inverseFileItemInfo2.getParent(), iComponentHandle, iContextHandle) == null ? (((InverseFileItemInfo)(object2 = this.getInverseInfo((IVersionableHandle)inverseFileItemInfo2.getParent(), iComponentHandle, iContextHandle, hashMap))).getLocalParent() == null ? 2 : 1) : 1) : (this.noPathChange(inverseFileItemInfo2, iComponentHandle, iContextHandle) ? 0 : 3)));
                    ISharingDescriptor iSharingDescriptor = null;
                    Path path = null;
                    switch (n) {
                        case 2: {
                            object2 = null;
                            iPath2 = null;
                            iPath = null;
                            break;
                        }
                        case 1: {
                            object2 = this.computeDeletionPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath = null;
                            break;
                        }
                        case 0: {
                            object2 = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath = null;
                            break;
                        }
                        case 4: {
                            object2 = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath2 = null;
                            iPath = null;
                            break;
                        }
                        case 3: {
                            object2 = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath = this.computeDeletionPath((IVersionableHandle)inverseFileItemInfo2.getParent(), iComponentHandle, iContextHandle, hashMap).append(inverseFileItemInfo2.getName());
                            path = new Path(object2.segment(0));
                            iSharingDescriptor = this.getSharingDescriptor((IPath)path);
                            boolean bl2 = this.isIgnored((IPath)object2, iSharingDescriptor, (IPath)path);
                            if (object2.segment(0).equals(iPath.segment(0))) {
                                object = iSharingDescriptor;
                                inverseFileItemInfo = path;
                            } else {
                                inverseFileItemInfo = new Path(iPath.segment(0));
                                object = this.getSharingDescriptor((IPath)inverseFileItemInfo);
                            }
                            bl = this.isIgnored(iPath, (ISharingDescriptor)object, (IPath)inverseFileItemInfo);
                            if (bl && bl2) continue block18;
                            if (bl && !bl2) {
                                n = 4;
                                iPath2 = null;
                                iPath = null;
                                break;
                            }
                            if (!bl && bl2) {
                                n = 1;
                                iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                                object2 = this.computeDeletionPath((IVersionableHandle)inverseFileItemInfo2.getParent(), iComponentHandle, iContextHandle, hashMap).append(inverseFileItemInfo2.getName());
                                iPath = null;
                                break;
                            }
                            Assert.isTrue((!bl && !bl2 ? 1 : 0) != 0);
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                    IFolderHandle iFolderHandle = inverseFileItemInfo2.getLocalParent();
                    object = inverseFileItemInfo2.getParent();
                    if (iFolderHandle != null) {
                        inverseFileItemInfo = this.getInverseInfo((IVersionableHandle)inverseFileItemInfo2.getLocalParent(), iComponentHandle, iContextHandle, hashMap);
                        iFolderHandle = (IFolderHandle)inverseFileItemInfo.getVersionableHandle();
                    }
                    if (object != null) {
                        inverseFileItemInfo = this.getInverseInfo((IVersionableHandle)inverseFileItemInfo2.getParent(), iComponentHandle, iContextHandle, hashMap);
                        object = (IFolderHandle)inverseFileItemInfo.getVersionableHandle();
                    }
                    boolean bl3 = !inverseFileItemInfo2.isFolder() && (inverseFileItemInfo2.getOriginalLineDelimiter() != inverseFileItemInfo2.getLineDelimiter() || inverseFileItemInfo2.getOriginalContentType() == null && inverseFileItemInfo2.getContentType() != null || inverseFileItemInfo2.getOriginalContentType() != null && !inverseFileItemInfo2.getOriginalContentType().equals(inverseFileItemInfo2.getContentType()) || inverseFileItemInfo2.getLastModification() == -1L);
                    bl = false;
                    if ((n == 0 || n == 3) && !inverseFileItemInfo2.isFolder() && localChangeInfo.isForwardMapChanged()) {
                        if (path == null) {
                            path = new Path(object2.segment(0));
                            iSharingDescriptor = this.getSharingDescriptor((IPath)path);
                        }
                        IFileStorage iFileStorage = this.getStorage((IPath)object2, iSharingDescriptor, (IPath)path, false);
                        SharingManager.getInstance().disableChangeMonitoring();
                        try {
                            if (!bl3) {
                                boolean bl4 = bl3 = inverseFileItemInfo2.getLastModification() != iFileStorage.getModificationStamp();
                            }
                            bl = iFileStorage.supportsExecBit() ? iFileStorage.isExecutable() ^ inverseFileItemInfo2.isOriginalExecutable() : inverseFileItemInfo2.isExecutable() ^ inverseFileItemInfo2.isOriginalExecutable();
                        }
                        finally {
                            SharingManager.getInstance().enableChangeMonitoring();
                        }
                    }
                    arrayList.add(new MetadataChangeTracker$ChangeType(inverseFileItemInfo2.getVersionableHandle(), n, iFolderHandle, (IFolderHandle)object, (IPath)object2, iPath2, iPath, bl3, bl));
                }
            }
            ArrayList<MetadataChangeTracker$ChangeType> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(true, "Failure during getLocalChanges()", dBHMException.getCause());
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_4, dBHMException.getCause())));
        }
        finally {
            this.releaseMap(lockableMap);
        }
    }

    private IPath computeLocalPath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            Object object;
            if (iVersionableHandle instanceof IFolderHandle && (object = this.delegate.getPathForShareRoot((IFolderHandle)iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return object;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return object.append((String)arrayList.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer(n + n2);
                stringBuffer.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuffer.append('/');
                    stringBuffer.append((String)arrayList.get(n3));
                    --n3;
                }
                return object.append(stringBuffer.toString());
            }
            object = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            String string = ((InverseFileItemInfo)object).getLocalName();
            if (string == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (iVersionableHandle == null ? "null item" : iVersionableHandle.getItemId().getUuidValue()), null);
                throw (Throwable)new IllegalStateException("Path to " + ((FileItemInfo)object).getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            iVersionableHandle = ((InverseFileItemInfo)object).getLocalParent();
        }
    }

    private IPath computeRemotePath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            Object object;
            if (iVersionableHandle instanceof IFolderHandle && (object = this.delegate.getPathForShareRoot((IFolderHandle)iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return object;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return object.append((String)arrayList.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer(n + n2);
                stringBuffer.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuffer.append('/');
                    stringBuffer.append((String)arrayList.get(n3));
                    --n3;
                }
                return object.append(stringBuffer.toString());
            }
            object = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            String string = ((FileItemInfo)object).getName();
            if (string == null) {
                throw (Throwable)new IllegalStateException("Path to " + ((FileItemInfo)object).getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            iVersionableHandle = ((FileItemInfo)object).getParent();
        }
    }

    private IPath computeDeletionPath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        boolean bl = true;
        while (true) {
            Object object;
            if (iVersionableHandle instanceof IFolderHandle && (object = this.delegate.getPathForShareRoot((IFolderHandle)iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return object;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return object.append((String)arrayList.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer(n + n2);
                stringBuffer.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuffer.append('/');
                    stringBuffer.append((String)arrayList.get(n3));
                    --n3;
                }
                return object.append(stringBuffer.toString());
            }
            object = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            String string = ((InverseFileItemInfo)object).getLocalName();
            if (bl) {
                if (string != null) {
                    bl = false;
                } else {
                    string = ((FileItemInfo)object).getName();
                }
            }
            if (string == null) {
                throw (Throwable)new IllegalStateException("Path to " + ((FileItemInfo)object).getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            iVersionableHandle = bl ? ((FileItemInfo)object).getParent() : ((InverseFileItemInfo)object).getLocalParent();
        }
    }

    private InverseFileItemInfo getInverseInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = (InverseFileItemInfo)map.get(iVersionableHandle.getItemId());
        if (inverseFileItemInfo != null) {
            return inverseFileItemInfo;
        }
        inverseFileItemInfo = this.delegate.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        map.put(iVersionableHandle.getItemId(), inverseFileItemInfo);
        return inverseFileItemInfo;
    }

    public FileItemInfo setFileItemInfo(IPath iPath, FileItemInfo fileItemInfo) throws FileSystemClientException {
        FileItemInfo fileItemInfo2;
        block23: {
            boolean bl;
            fileItemInfo2 = this.delegate.setFileItemInfo(iPath, fileItemInfo);
            boolean bl2 = fileItemInfo != null && !fileItemInfo.isFolder();
            boolean bl3 = bl = fileItemInfo2 != null && !fileItemInfo2.isFolder() && (fileItemInfo == null || !fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo2.getVersionableHandle()));
            if (bl2 || bl) {
                try {
                    boolean bl4;
                    Path path = new Path(iPath.segment(0));
                    ISharingDescriptor iSharingDescriptor = this.getSharingDescriptor((IPath)path);
                    long l = -1L;
                    long l2 = bl2 ? fileItemInfo.getLastModification() : -1L;
                    IFileStorage iFileStorage = this.getStorage(iPath, iSharingDescriptor, (IPath)path, false);
                    if (l2 != -1L) {
                        SharingManager sharingManager = SharingManager.getInstance();
                        sharingManager.disableChangeMonitoring();
                        try {
                            l = iFileStorage.getModificationStamp();
                        }
                        finally {
                            sharingManager.enableChangeMonitoring();
                        }
                    }
                    boolean bl5 = bl4 = bl2 && (l2 == -1L || l != -1L);
                    if (!bl4 && !bl) break block23;
                    LockableMap lockableMap = this.getMapFor(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    try {
                        boolean bl6;
                        LocalChangeInfo localChangeInfo;
                        MetadataChangeTracker$ChangeKey metadataChangeTracker$ChangeKey;
                        if (bl4) {
                            boolean bl7;
                            metadataChangeTracker$ChangeKey = new MetadataChangeTracker$ChangeKey(fileItemInfo.getVersionableHandle());
                            localChangeInfo = (LocalChangeInfo)lockableMap.entries().get(metadataChangeTracker$ChangeKey);
                            bl6 = localChangeInfo == null ? false : localChangeInfo.inverseMapChanged();
                            boolean bl8 = bl7 = !fileItemInfo.isFolder() && (l2 == -1L || l2 != l);
                            if (!bl7) {
                                SharingManager sharingManager = SharingManager.getInstance();
                                sharingManager.disableChangeMonitoring();
                                try {
                                    bl7 = iFileStorage.supportsExecBit() ? iFileStorage.isExecutable() ^ fileItemInfo.isOriginalExecutable() : fileItemInfo.isExecutable() ^ fileItemInfo.isOriginalExecutable();
                                }
                                finally {
                                    sharingManager.enableChangeMonitoring();
                                }
                            }
                            if (!bl7 && !bl6) {
                                if (localChangeInfo != null) {
                                    lockableMap.entries().remove(metadataChangeTracker$ChangeKey);
                                    this.notifyTracker(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                                }
                            } else {
                                lockableMap.entries().put(metadataChangeTracker$ChangeKey, new LocalChangeInfo(bl6, bl7));
                                this.notifyTracker(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                            }
                        }
                        if (bl) {
                            metadataChangeTracker$ChangeKey = new MetadataChangeTracker$ChangeKey(fileItemInfo2.getVersionableHandle());
                            localChangeInfo = (LocalChangeInfo)lockableMap.entries().get(metadataChangeTracker$ChangeKey);
                            bl6 = localChangeInfo == null ? false : localChangeInfo.inverseMapChanged();
                            if (!bl6) {
                                if (localChangeInfo != null) {
                                    lockableMap.entries().remove(metadataChangeTracker$ChangeKey);
                                    this.notifyTracker(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                                }
                            } else {
                                lockableMap.entries().put(metadataChangeTracker$ChangeKey, new LocalChangeInfo(bl6, false));
                                this.notifyTracker(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                            }
                        }
                    }
                    finally {
                        this.releaseMap(lockableMap);
                    }
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(true, "Failure when setting item info", dBHMException.getCause());
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_5, dBHMException.getCause())));
                }
            }
        }
        return fileItemInfo2;
    }

    private static boolean isUnchanged(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private static boolean isUnchanged(IVersionableHandle iVersionableHandle, IVersionableHandle iVersionableHandle2, boolean bl) {
        if (iVersionableHandle == iVersionableHandle2) {
            return true;
        }
        if (iVersionableHandle == null || iVersionableHandle2 == null) {
            return false;
        }
        if (bl && !MetadataChangeTracker.isUnchanged(iVersionableHandle.getStateId(), iVersionableHandle2.getStateId())) {
            return false;
        }
        return iVersionableHandle.sameItemId((IItemHandle)iVersionableHandle2);
    }

    private static boolean isUnchanged(UUID uUID, UUID uUID2) {
        if (uUID == uUID2) {
            return true;
        }
        if (uUID == null || uUID2 == null) {
            return false;
        }
        return uUID.equals((Object)uUID2);
    }

    private boolean itemPathUnchanged(InverseFileItemInfo inverseFileItemInfo, InverseFileItemInfo inverseFileItemInfo2) {
        if (inverseFileItemInfo == inverseFileItemInfo2) {
            return true;
        }
        if (inverseFileItemInfo == null || inverseFileItemInfo2 == null) {
            return false;
        }
        return MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getParent(), (IVersionableHandle)inverseFileItemInfo2.getParent(), false) && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getName(), inverseFileItemInfo2.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getLocalParent(), (IVersionableHandle)inverseFileItemInfo2.getLocalParent(), false) && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getLocalName(), inverseFileItemInfo2.getLocalName());
    }

    private boolean noPathNoPropertyChange(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (inverseFileItemInfo == null) {
            return true;
        }
        if (inverseFileItemInfo.isFolder() && this.getPathForShareRoot((IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) != null) {
            return true;
        }
        if (inverseFileItemInfo.getOriginalLineDelimiter() == inverseFileItemInfo.getLineDelimiter() && (inverseFileItemInfo.getOriginalContentType() == null && inverseFileItemInfo.getOriginalContentType() == inverseFileItemInfo.getContentType() || inverseFileItemInfo.getOriginalContentType() != null && inverseFileItemInfo.getOriginalContentType().equals(inverseFileItemInfo.getContentType()))) {
            return MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getLocalParent(), (IVersionableHandle)inverseFileItemInfo.getParent(), false);
        }
        return false;
    }

    private boolean noPathChange(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (inverseFileItemInfo == null) {
            return true;
        }
        if (inverseFileItemInfo.isFolder() && this.getPathForShareRoot((IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) != null) {
            return true;
        }
        return MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getLocalParent(), (IVersionableHandle)inverseFileItemInfo.getParent(), false);
    }

    private LockableMap getMapFor(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.getMapFor(iComponentHandle, iContextHandle, true);
    }

    private LockableMap getMapFor(IComponentHandle iComponentHandle, IContextHandle iContextHandle, boolean bl) throws FileSystemClientException {
        Path path = new Path(SCM_CHANGED_INFOS_PREFIX + iComponentHandle.getItemId().getUuidValue() + "_" + iContextHandle.getItemId().getUuidValue() + SCM_CHANGED_INFOS_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, bl, (IPath)path);
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(true, "Failed to get map for " + path.toString(), dBHMException.getCause());
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, dBHMException.getCause())));
        }
    }

    private void releaseMap(LockableMap lockableMap) throws FileSystemClientException {
        this.mapMgr.releaseMap(lockableMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InverseFileItemInfo setFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, InverseFileItemInfo inverseFileItemInfo) throws FileSystemClientException {
        if (inverseFileItemInfo != null && !iVersionableHandle.sameItemId((IItemHandle)inverseFileItemInfo.getVersionableHandle())) {
            throw (Throwable)new IllegalArgumentException();
        }
        InverseFileItemInfo inverseFileItemInfo2 = this.delegate.setFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle, inverseFileItemInfo);
        boolean bl = this.noPathNoPropertyChange(inverseFileItemInfo, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null || this.noPathNoPropertyChange(inverseFileItemInfo2, iComponentHandle, iContextHandle) != bl) {
            try {
                MetadataChangeTracker$ChangeKey metadataChangeTracker$ChangeKey = new MetadataChangeTracker$ChangeKey(iVersionableHandle);
                LockableMap lockableMap = this.getMapFor(iComponentHandle, iContextHandle);
                try {
                    LocalChangeInfo localChangeInfo = (LocalChangeInfo)lockableMap.entries().get(metadataChangeTracker$ChangeKey);
                    if (inverseFileItemInfo == null) {
                        if (localChangeInfo == null) return inverseFileItemInfo2;
                        if (localChangeInfo.isForwardMapChanged()) {
                            lockableMap.entries().put(metadataChangeTracker$ChangeKey, new LocalChangeInfo(false, true));
                        } else {
                            lockableMap.entries().remove(metadataChangeTracker$ChangeKey);
                        }
                        this.notifyTracker(iComponentHandle, iContextHandle);
                        return inverseFileItemInfo2;
                    }
                    boolean bl2 = localChangeInfo == null ? false : localChangeInfo.isForwardMapChanged();
                    if (bl && !bl2) {
                        if (localChangeInfo == null) return inverseFileItemInfo2;
                        lockableMap.entries().remove(metadataChangeTracker$ChangeKey);
                        this.notifyTracker(iComponentHandle, iContextHandle);
                        return inverseFileItemInfo2;
                    }
                    lockableMap.entries().put(metadataChangeTracker$ChangeKey, new LocalChangeInfo(!bl, bl2));
                    this.notifyTracker(iComponentHandle, iContextHandle);
                    return inverseFileItemInfo2;
                }
                finally {
                    this.releaseMap(lockableMap);
                }
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Failure when setting item info", dBHMException.getCause());
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_6, dBHMException.getCause())));
            }
        } else {
            if (this.itemPathUnchanged(inverseFileItemInfo, inverseFileItemInfo2)) return inverseFileItemInfo2;
            this.notifyTracker(iComponentHandle, iContextHandle);
        }
        return inverseFileItemInfo2;
    }

    public ISharingDescriptor setSharingDescriptor(IPath iPath, ISharingDescriptor iSharingDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISharingDescriptor iSharingDescriptor2 = this.delegate.setSharingDescriptor(iPath, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(50));
        if (iSharingDescriptor2 != null) {
            if (iSharingDescriptor == null || !iSharingDescriptor2.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()) || !iSharingDescriptor2.getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent())) {
                LockableMap lockableMap = this.getMapFor(iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle());
                try {
                    try {
                        LockableMap lockableMap2 = iSharingDescriptor != null ? this.getMapFor(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle()) : null;
                        try {
                            this.delegate.accept(new MetadataChangeTracker$2(this, lockableMap, lockableMap2), iPath, Integer.MAX_VALUE, false, (IProgressMonitor)subMonitor.newChild(50));
                        }
                        finally {
                            if (lockableMap2 != null) {
                                this.releaseMap(lockableMap2);
                            }
                        }
                    }
                    catch (DBHMException dBHMException) {
                        this.setCorrupt(true, null, dBHMException.getCause());
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_7, dBHMException.getCause())));
                    }
                }
                finally {
                    this.releaseMap(lockableMap);
                }
            }
            this.notifyTracker(iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle());
        }
        if (iSharingDescriptor != null) {
            this.notifyTracker(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
        }
        return iSharingDescriptor2;
    }

    public String toDebugString() {
        return this.delegate.toDebugString();
    }

    public Map getSharingDescriptors(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getSharingDescriptors(iComponentHandle, iContextHandle);
    }

    public Collection allLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.allLoadedComponents(iProgressMonitor);
    }

    public Collection allLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.allLoadedContexts(iProgressMonitor);
    }

    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor loadedConfigurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.componentLoaded(loadedConfigurationDescriptor, iProgressMonitor);
    }

    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.componentUnloaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public boolean hasShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.hasShares(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public boolean isLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.isLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.delegate.getPersistentMetadataFlag();
    }

    public void addCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        this.delegate.addCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void removeCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        this.delegate.removeCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void setCorrupt(boolean bl, String string, Throwable throwable) {
        this.delegate.setCorrupt(bl, string, throwable);
    }

    public boolean isCorrupted() {
        return this.delegate.isCorrupted();
    }

    static /* synthetic */ void access$0(MetadataChangeTracker metadataChangeTracker, DBHMException dBHMException) {
        metadataChangeTracker.setCorrupt(dBHMException);
    }
}

