/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemLoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflictReport;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class FileSystemView
implements IFileSystemView {
    private final IConnection connection;
    private final boolean isWorkspaceConnection;
    private final FileSystemServiceProxy fileSystemService;

    public FileSystemView(FileSystemServiceProxy fileSystemServiceProxy, IConnection iConnection) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            this.isWorkspaceConnection = true;
        } else {
            this.isWorkspaceConnection = false;
            if (!(iConnection instanceof IBaselineConnection)) {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        this.connection = iConnection;
        this.fileSystemService = fileSystemServiceProxy;
    }

    public IConnection connection() {
        return this.connection;
    }

    public void updateLocalFileSystem(File file, IUpdateReport iUpdateReport, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.updateLocalFileSystem(file, iUpdateReport, null, iProgressMonitor);
    }

    public void updateLocalFileSystem(File file, IUpdateReport iUpdateReport, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (file == null || !file.exists()) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iUpdateReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_0);
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            LocalFileSystemUpdateOperation localFileSystemUpdateOperation = new LocalFileSystemUpdateOperation((IWorkspaceConnection)this.connection(), Collections.singletonList(iUpdateReport), (IPath)new Path(file.getCanonicalPath()), 3, UpdateDilemmaHandler.getDefault());
            localFileSystemUpdateOperation.setSynchronizationInfo(iSynchronizationInfo);
            localFileSystemUpdateOperation.run(iProgressMonitor);
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 207, Messages.FileSystemView_1, iOException)));
        }
    }

    public List getBlame(IComponentHandle iComponentHandle, IFileItemHandle iFileItemHandle, IChangeSetHandle iChangeSetHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return this.fileSystemService.getBlame(this.connection, iComponentHandle, iFileItemHandle, iChangeSetHandle, null, iProgressMonitor);
    }

    public ILogicalConflictReport interpretConflicts(IPath iPath, Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_2);
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection.isEmpty()) {
            LogicalConflictReport logicalConflictReport = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            return (ILogicalConflictReport)logicalConflictReport;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.interpretConflicts((IWorkspaceConnection)this.connection, collection, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public void loadLocalFileSystem(File file, Collection collection, int n, LoadDilemmaHandler loadDilemmaHandler, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.loadLocalFileSystem(file, collection, n, loadDilemmaHandler, null, iProgressMonitor);
    }

    public void loadLocalFileSystem(File file, Collection collection, int n, LoadDilemmaHandler loadDilemmaHandler, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (file == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (loadDilemmaHandler == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (n != 0 && n != 1 && n != 2) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (Object object : collection) {
            if (object instanceof IComponentHandle) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw (Throwable)new IllegalArgumentException(Messages.FileSystemView_3);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(100 + collection.size() * 10));
        try {
            Object object;
            object = new LocalFileSystemLoadOperation((IPath)new Path(file.getCanonicalPath()), this.getLoadOperationFlags(n), loadDilemmaHandler);
            if (this.isWorkspaceConnection) {
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)this.connection;
                for (IComponentHandle iComponentHandle : collection) {
                    IConfiguration iConfiguration = iWorkspaceConnection.configuration(iComponentHandle);
                    ArrayList arrayList = this.getFoldersToLoad(iConfiguration, subMonitor.newChild(10));
                    ((LoadOperation)object).requestLoad(iWorkspaceConnection, iComponentHandle, arrayList);
                }
            } else {
                IConfiguration iConfiguration = ((IBaselineConnection)this.connection).configuration();
                ArrayList arrayList = this.getFoldersToLoad(iConfiguration, subMonitor.newChild(10));
                ((LoadOperation)object).requestLoad((IBaselineConnection)this.connection, arrayList);
            }
            ((LoadOperation)object).setSychronizationInfo(iSynchronizationInfo);
            ((FileSystemOperation)object).run((IProgressMonitor)subMonitor.newChild(90));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 207, Messages.FileSystemView_4, iOException)));
        }
    }

    private ArrayList getFoldersToLoad(IConfiguration iConfiguration, SubMonitor subMonitor) throws TeamRepositoryException {
        Map map = iConfiguration.childEntriesForRoot((IProgressMonitor)subMonitor);
        ArrayList<IFolderHandle> arrayList = new ArrayList<IFolderHandle>(map.size());
        for (IVersionableHandle iVersionableHandle : map.values()) {
            if (!(iVersionableHandle instanceof IFolderHandle)) continue;
            arrayList.add((IFolderHandle)iVersionableHandle);
        }
        return arrayList;
    }

    private int getLoadOperationFlags(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 = 1;
        } else if ((n & 2) == 2) {
            n2 = 2;
        }
        return n2;
    }

    public List interpretChanges(IPath iPath, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.interpretChanges(this.connection, list, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public ILogicalConflictReport conflictReport(IPath iPath, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IUpdateReport iUpdateReport = ((IWorkspaceConnection)this.connection).conflictReport();
        if (iUpdateReport.conflicts().isEmpty()) {
            LogicalConflictReport logicalConflictReport = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            logicalConflictReport.setConflictReport(iUpdateReport);
            return (ILogicalConflictReport)logicalConflictReport;
        }
        return this.fileSystemService.conflictReport((IWorkspaceConnection)this.connection, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection iWorkspaceConnection, int n, IPath iPath, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)n)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.compareAsWorkspaces((IWorkspaceConnection)this.connection, iWorkspaceConnection, n, (IProgressMonitor)subMonitor.newChild(99));
    }
}

