/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.repository.common.utils.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class FileStorage
implements IFileStorage {
    public static final boolean PLATFORM_SUPPORTS_EXEC_BIT = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    public boolean isContentChangedFrom(long l, long l2, IShareable iShareable, InputStream inputStream, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            HashCode hashCode;
            if (inputStream == null) {
                throw (Throwable)new IllegalArgumentException("in may not be null");
            }
            if (iShareable == null) {
                iShareable = this.getShareable();
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            if (l != -1L && l == this.getModificationStamp()) {
                return false;
            }
            FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(iShareable);
            if (fileItemInfo == null || fileItemInfo.getHash() == null || l2 != fileItemInfo.getContentLength()) {
                return true;
            }
            subMonitor.beginTask(Messages.FileStorage_0, 100);
            try {
                hashCode = HashCode.createHashCode((InputStream)inputStream);
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)iOException)));
            }
            boolean bl = hashCode.equals((Object)fileItemInfo.getHash());
            subMonitor.done();
            boolean bl2 = !bl;
            return bl2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, iOException);
            }
        }
    }

    public boolean supportsExecBit() {
        return PLATFORM_SUPPORTS_EXEC_BIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setExecutable(boolean bl, IProgressMonitor iProgressMonitor) {
        Shareable shareable = this.getShareable();
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            ISchedulingRule iSchedulingRule = copyFileAreaStore.lock(shareable, (IProgressMonitor)subMonitor.newChild(25));
            if (iSchedulingRule == null) {
                return false;
            }
            try {
                FileItemInfo fileItemInfo = copyFileAreaStore.getItemInfo(this.getFullPath());
                if (fileItemInfo == null) {
                    return false;
                }
                if (bl == fileItemInfo.isExecutable()) return true;
                fileItemInfo = new FileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.getLastModification(), fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredContentId(), fileItemInfo.getStoredDeltaPredecessor(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredChecksum(), fileItemInfo.getStoredNumLineDelimiters(), bl, fileItemInfo.isOriginalExecutable());
                copyFileAreaStore.setItemInfo(shareable, fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
                return true;
            }
            finally {
                copyFileAreaStore.release(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(25));
            }
        }
        catch (Exception exception) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(exception));
            return false;
        }
    }

    public boolean isExecutable() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this.getShareable());
        return fileItemInfo == null ? false : fileItemInfo.isExecutable();
    }
}

