/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Assert;

public class FileItemInfo {
    public static final long NULL_STAMP = -1L;
    public static final long NULL_CHECKSUM = -1L;
    public static final long NULL_DELIMITER_COUNT = -1L;
    private final IVersionableHandle handle;
    private final long lastModification;
    private final IFolderHandle parent;
    private final String name;
    public static final int NULL_SIZE = -1;
    private final long contentLength;
    private final HashCode hash;
    private final LineDelimiter lineDelimiter;
    private final LineDelimiter originalLineDelimiter;
    private final String contentType;
    private final String originalContentType;
    private final UUID deltaPredecessor;
    private final UUID contentId;
    private final long sizeInRepo;
    private final String encoding;
    private final long checksum;
    private final long numLineDelimiters;
    private final boolean originalExecutable;
    private final boolean executable;

    public FileItemInfo(IVersionableHandle iVersionableHandle, long l, IFolderHandle iFolderHandle, String string, HashCode hashCode, long l2, LineDelimiter lineDelimiter, LineDelimiter lineDelimiter2, String string2, String string3, UUID uUID, UUID uUID2, long l3, String string4, long l4, long l5, boolean bl, boolean bl2) {
        this.validateFileItemInfo(iVersionableHandle, iFolderHandle, string);
        if (iVersionableHandle instanceof IFolderHandle) {
            if (string2 != null || string3 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (lineDelimiter != null || lineDelimiter2 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            bl = false;
            bl2 = false;
        } else {
            if (string3 == null && string2 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (lineDelimiter2 == null && lineDelimiter != null) {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        if (iVersionableHandle.hasStateId() && !(iVersionableHandle instanceof IFolderHandle)) {
            if (hashCode == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (l2 == -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
        } else {
            if (!iVersionableHandle.hasStateId() && l != -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (l2 != -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (lineDelimiter != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (string2 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (uUID != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (uUID2 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (l3 != -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (string4 != null) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (l4 != -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (l5 != -1L) {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        if (uUID == null) {
            Assert.isTrue((uUID2 == null ? 1 : 0) != 0);
            Assert.isTrue((l3 == -1L ? 1 : 0) != 0);
            Assert.isTrue((string4 == null ? 1 : 0) != 0);
            Assert.isTrue((l4 == -1L ? 1 : 0) != 0);
            Assert.isTrue((l5 == -1L ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)iVersionableHandle.hasStateId());
            Assert.isTrue((!(iVersionableHandle instanceof IFolderHandle) ? 1 : 0) != 0);
            Assert.isTrue((lineDelimiter != null ? 1 : 0) != 0);
            Assert.isTrue((l3 != -1L ? 1 : 0) != 0);
            Assert.isTrue((string2 != null ? 1 : 0) != 0);
            Assert.isTrue((l4 != -1L ? 1 : 0) != 0);
        }
        this.handle = iVersionableHandle;
        this.parent = iFolderHandle;
        this.name = string;
        this.lastModification = l;
        this.hash = hashCode;
        this.contentLength = l2;
        this.lineDelimiter = lineDelimiter2;
        this.originalLineDelimiter = lineDelimiter;
        this.originalContentType = string2;
        this.contentType = string3;
        this.contentId = uUID;
        this.deltaPredecessor = uUID2;
        this.sizeInRepo = l3;
        this.encoding = string4;
        this.checksum = l4;
        this.numLineDelimiters = l5;
        this.executable = bl;
        this.originalExecutable = bl2;
    }

    public FileItemInfo(IFolderHandle iFolderHandle, IFolderHandle iFolderHandle2, String string) {
        this.validateFileItemInfo((IVersionableHandle)iFolderHandle, iFolderHandle2, string);
        this.handle = (IVersionableHandle)iFolderHandle;
        this.parent = iFolderHandle2;
        this.name = string;
        this.lastModification = -1L;
        this.contentLength = -1L;
        this.originalLineDelimiter = null;
        this.lineDelimiter = null;
        this.hash = null;
        this.originalContentType = null;
        this.contentType = null;
        this.contentId = null;
        this.deltaPredecessor = null;
        this.sizeInRepo = -1L;
        this.encoding = null;
        this.checksum = -1L;
        this.numLineDelimiters = -1L;
        this.originalExecutable = false;
        this.executable = false;
    }

    private void validateFileItemInfo(IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle, String string) {
        Assert.isNotNull((Object)iVersionableHandle);
        Assert.isTrue((!iVersionableHandle.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((iFolderHandle == null || !iFolderHandle.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((iFolderHandle == null == (string == null) ? 1 : 0) != 0);
        Assert.isTrue((iFolderHandle == null || iVersionableHandle.hasStateId() ? 1 : 0) != 0);
        Assert.isTrue((iFolderHandle != null || !iVersionableHandle.hasStateId() || iVersionableHandle instanceof IFolderHandle ? 1 : 0) != 0);
    }

    public IVersionableHandle getVersionableHandle() {
        return this.handle;
    }

    public boolean isFolder() {
        return this.handle instanceof IFolderHandle;
    }

    public long getLastModification() {
        return this.lastModification;
    }

    public IFolderHandle getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public HashCode getHash() {
        return this.hash;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public LineDelimiter getOriginalLineDelimiter() {
        return this.originalLineDelimiter;
    }

    public LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getOriginalContentType() {
        return this.originalContentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public UUID getStoredDeltaPredecessor() {
        return this.deltaPredecessor;
    }

    public UUID getStoredContentId() {
        return this.contentId;
    }

    public long getStoredSize() {
        return this.sizeInRepo;
    }

    public String getStoredEncoding() {
        return this.encoding;
    }

    public long getStoredChecksum() {
        return this.checksum;
    }

    public long getStoredNumLineDelimiters() {
        return this.numLineDelimiters;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isOriginalExecutable() {
        return this.originalExecutable;
    }
}

