/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;

public class FileNode
extends BufferedContent
implements IEncodedStreamContentAccessor,
IStructureComparator,
ITypedElement,
IEditableContent,
IModificationDate {
    private File fFile;
    private ArrayList fChildren;

    public FileNode(File file) {
        this.fFile = file;
        Assert.isNotNull((Object)file);
    }

    public File getFile() {
        return this.fFile;
    }

    public InputStream getContents() throws CoreException {
        if (this.fFile.isFile()) {
            try {
                return new FileInputStream(this.fFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    public long getModificationDate() {
        return this.fFile.lastModified();
    }

    public String getName() {
        if (this.fFile != null) {
            return this.fFile.getName();
        }
        return null;
    }

    public String getType() {
        if (this.fFile.isDirectory()) {
            return "FOLDER";
        }
        String s = new Path(this.fFile.getName()).getFileExtension();
        if (s != null) {
            return s;
        }
        return "???";
    }

    public Image getImage() {
        if (this.fFile.isDirectory()) {
            return CompareUI.getImage((String)"FOLDER");
        }
        Path path = new Path(this.fFile.getName());
        if (path.getFileExtension() == null) {
            return null;
        }
        return CompareUI.getImage((String)path.getFileExtension());
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
            if (this.fFile.isDirectory()) {
                File[] members = this.fFile.listFiles();
                int i = 0;
                while (i < members.length) {
                    IStructureComparator child = this.createChild(members[i]);
                    if (child != null) {
                        this.fChildren.add(child);
                    }
                    ++i;
                }
            }
        }
        return this.fChildren.toArray();
    }

    protected IStructureComparator createChild(File child) {
        return new FileNode(child);
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return child;
    }

    public String getCharset() {
        return null;
    }

    protected InputStream createStream() throws CoreException {
        return null;
    }
}

