/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.ICompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainFileCompareEditorInput;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainPerspective;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainWorkbenchAdvisor;
import com.ibm.team.filesystem.client.daemon.IJSONReceiver;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.rest.LifecycleRestClient;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.LocalFileCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.SimpleConflictCompareEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.File;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareRestClient
implements ICompareRestClient,
IJSONReceiver {
    private static final int WAIT_INCR = 100;
    private static final int MAX_WAIT = 600;
    private JSONHandler jsonHandler;
    private static final Object displayThreadLock = new Object();
    private static WorkbenchJob displayThread = null;
    private static Object lock = new Object();
    static IWorkbenchWindow compareWindow;
    CoreException exception;
    private IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow arg0) {
        }

        public void windowDeactivated(IWorkbenchWindow arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(IWorkbenchWindow window) {
            Object object = lock;
            synchronized (object) {
                if (window == compareWindow) {
                    compareWindow = null;
                }
                PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            }
        }

        public void windowActivated(IWorkbenchWindow arg0) {
        }
    };

    private void showInput(final CompareEditorInput input) throws TeamRepositoryException {
        this.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IEditorPart editor;
                    Object object = lock;
                    synchronized (object) {
                        if (compareWindow == null) {
                            PlatformUI.getWorkbench().addWindowListener(CompareRestClient.this.windowListener);
                            compareWindow = PlatformUI.getWorkbench().openWorkbenchWindow(PlainPerspective.ID, null);
                        }
                    }
                    if (input instanceof SimpleConflictCompareEditorInput) {
                        SimpleConflictCompareEditorInput si = (SimpleConflictCompareEditorInput)input;
                        si.setPage(CompareRestClient.this.getCompareWindowPage());
                    }
                    if ((editor = CompareRestClient.this.findMatchingEditor(input)) == null) {
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)CompareRestClient.this.getCompareWindowPage());
                    } else {
                        CompareRestClient.this.getCompareWindowPage().activate((IWorkbenchPart)editor);
                    }
                    compareWindow.getShell().forceActive();
                }
                catch (WorkbenchException e) {
                    CompareRestClient.this.exception = e;
                }
            }
        });
    }

    private IEditorPart findMatchingEditor(CompareEditorInput input) {
        IEditorReference[] editorRefs = compareWindow.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private void checkState() throws TeamRepositoryException {
        if (this.exception != null) {
            TeamRepositoryException e = new TeamRepositoryException(Messages.CompareRestClient_0, (Throwable)this.exception);
            this.exception = null;
            throw e;
        }
    }

    @Override
    public void postShowFileCompare(ICompareRestClient.ParmsShowFileCompare parms) throws TeamRepositoryException {
        this.checkState();
        File leftFile = new File(parms.left);
        File rightFile = new File(parms.right);
        File baseFile = null;
        if (parms.base != null) {
            baseFile = new File(parms.base);
        }
        PlainFileCompareEditorInput input = new PlainFileCompareEditorInput(new CompareConfiguration(), leftFile, baseFile, rightFile);
        this.showInput(input);
    }

    @Override
    public void postShowConflictCompare(ParmsSyncDescription parms) throws TeamRepositoryException {
        this.checkState();
        parms.validate("postShowConflictCompare");
        Object element = SyncViewDTOUtil.find((Object)ComponentSyncModel.getInstance(), (int)parms.id);
        if (!(element instanceof IConflictItem)) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_2, (Object[])new Object[]{parms.id}));
        }
        SimpleConflictCompareEditorInput input = new SimpleConflictCompareEditorInput((IConflictItem)element);
        this.showInput((CompareEditorInput)input);
    }

    @Override
    public void postShowFileItemCompare(ICompareRestClient.ParmsShowFileItemCompare parms) throws TeamRepositoryException {
        this.checkState();
        parms.validate("postShowFileItemCompare");
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_3, (Object[])new Object[]{parms.repositoryUrl}));
        }
        StateId beforeState = parms.beforeStateId == null ? new StateId(IFileItem.ITEM_TYPE, UUID.valueOf((String)parms.fileItemId), StateId.STATE_DELETED) : new StateId(IFileItem.ITEM_TYPE, UUID.valueOf((String)parms.fileItemId), UUID.valueOf((String)parms.beforeStateId));
        StateId afterState = parms.afterStateId == null ? new StateId(IFileItem.ITEM_TYPE, UUID.valueOf((String)parms.fileItemId), StateId.STATE_DELETED) : new StateId(IFileItem.ITEM_TYPE, UUID.valueOf((String)parms.fileItemId), UUID.valueOf((String)parms.afterStateId));
        Path beforePath = parms.beforePathHint == null ? new Path(null, parms.afterPathHint) : new Path(null, parms.beforePathHint);
        Path afterPath = parms.afterPathHint == null ? beforePath : new Path(null, parms.afterPathHint);
        FileChangeEditorInput input = FileChangeEditorInput.createFrom((ITeamRepository)repo, (StateId)afterState, (IPath)afterPath, (StateId)beforeState, (IPath)beforePath);
        this.showInput((CompareEditorInput)input);
    }

    @Override
    public void postShowLocalFileChangeCompare(ICompareRestClient.ParmsShowLocalFileChangeCompare parms) throws TeamRepositoryException {
        LocalFileCompareEditorInput input;
        this.checkState();
        parms.validate("postShowLocalFileChangeCompare");
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_4, (Object[])new Object[]{parms.repositoryUrl}));
        }
        IFile local = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(null, parms.filePath));
        if (parms.fileItemId == null || parms.fileStateId == null) {
            input = new LocalFileCompareEditorInput(local, FileState.getDeletedState());
        } else {
            StateId remote = new StateId(IFileItem.ITEM_TYPE, UUID.valueOf((String)parms.fileItemId), UUID.valueOf((String)parms.fileStateId));
            input = this.createInputFor(repo, local, (StateId<IFileItem>)remote);
        }
        this.showInput((CompareEditorInput)input);
    }

    private CompareEditorInput createInputFor(ITeamRepository repo, IFile local, StateId<IFileItem> remote) {
        FileStateComputer comp = new FileStateComputer(repo, remote);
        return new LocalFileCompareEditorInput(local, comp.getLeft());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbenchWindow getCompareWindow() {
        Object object = lock;
        synchronized (object) {
            return compareWindow;
        }
    }

    private IWorkbenchPage getCompareWindowPage() {
        return compareWindow.getActivePage();
    }

    public void setController(IServerController controller, JSONHandler handler) {
        this.jsonHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Display getDisplay() throws TeamRepositoryException {
        Object object = displayThreadLock;
        synchronized (object) {
            IJobManager jobManager = Job.getJobManager();
            jobManager.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getJob() instanceof WorkbenchJob && !event.getResult().isOK()) {
                        CompareRestClient.this.exception = new CoreException(event.getResult());
                    }
                }
            });
            if (displayThread == null) {
                displayThread = new WorkbenchJob("Compare Editor");
                displayThread.schedule();
            }
        }
        int count = 0;
        while (!this.isWorkbenchReady()) {
            try {
                ++count;
                Thread.sleep(100L);
                if (this.exception != null) {
                    CoreException e = this.exception;
                    this.exception = null;
                    if (!e.getStatus().isMultiStatus() && e.getStatus().getException() != null) {
                        throw new TeamRepositoryException(e.getStatus().getException());
                    }
                    throw new TeamRepositoryException((Throwable)e);
                }
                if (count < 600) continue;
                throw new TeamRepositoryException(Messages.CompareRestClient_1);
            }
            catch (InterruptedException interruptedException) {}
        }
        return PlatformUI.getWorkbench().getDisplay();
    }

    private boolean isWorkbenchReady() {
        return PlatformUI.isWorkbenchRunning() && !((Workbench)PlatformUI.getWorkbench()).isStarting();
    }

    private class WorkbenchJob
    extends Job {
        WorkbenchJob(String name) {
            super(name);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final Display display = Display.getDefault();
            if (!PlatformUI.isWorkbenchRunning()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        LifecycleRestClient client = WorkbenchJob.this.findClient();
                        LifecycleRestClient.TimeoutBlocker blocker = new LifecycleRestClient.TimeoutBlocker(){

                            public boolean mayShutdownDueToTimeout() {
                                return compareWindow == null;
                            }
                        };
                        try {
                            client.addTimeoutBlocker(blocker);
                            PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new PlainWorkbenchAdvisor());
                        }
                        finally {
                            client.removeTimeoutBlocker(blocker);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }

        protected LifecycleRestClient findClient() {
            JSONMethod method = CompareRestClient.this.jsonHandler.getMethod(HttpMethod.POST, new String[]{"service", ILifecycleRestClient.class.getName(), "Timeout"});
            return (LifecycleRestClient)method.getReceiver();
        }
    }
}

