/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.patches.PatchConflictException;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.IPrefSerializable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatchOp
implements IPrefSerializable {
    public abstract void autoResolve(MovableResource var1, IProgressMonitor var2) throws FileSystemClientException, PatchConflictException;

    public abstract IStatus verify(MovableResource var1, IProgressMonitor var2);

    public IInputStreamProvider getAfterStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public IInputStreamProvider getBeforeStream(IProgressMonitor monitor) throws FileSystemClientException {
        return EmptyInputStreamProvider.getDefault();
    }

    public boolean isCreate() {
        return false;
    }

    public boolean isDelete() {
        return false;
    }

    public abstract void dispose();

    public boolean isModify() {
        return false;
    }

    public static List<PatchOp> copyOps(List<PatchOp> toClone) {
        ArrayList<PatchOp> result = new ArrayList<PatchOp>();
        for (PatchOp next : toClone) {
            result.add(next.copy());
        }
        return result;
    }

    public abstract PatchOp copy();

    public static void disposeOps(Collection<PatchOp> toDispose) {
        for (PatchOp next : toDispose) {
            next.dispose();
        }
    }

    public int getStartLine(IProgressMonitor monitor) throws FileSystemClientException {
        return 0;
    }

    public StateId getBeforeState() {
        return ParsedFilePatch.UNKNOWN_STATE;
    }

    public StateId getAfterState() {
        return ParsedFilePatch.UNKNOWN_STATE;
    }
}

