/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.rcp.core.internal.resources.EclipseWorkspaceMutator;
import com.ibm.team.filesystem.rcp.core.operations.IDownloadMonitor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWorkspaceUpdateOperation
extends UpdateOperation {
    private Set<UUID> ignoreList = new HashSet<UUID>();
    private final IDownloadMonitor downloadMonitor;

    public EclipseWorkspaceUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, int updatesToProcess, UpdateDilemmaHandler problemHandler, IDownloadMonitor dlMon) {
        this(connection, updateReports, Collections.EMPTY_LIST, updatesToProcess, problemHandler, dlMon);
    }

    public EclipseWorkspaceUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, int updatesToProcess, UpdateDilemmaHandler problemHandler) {
        this(connection, updateReports, updatesToProcess, problemHandler, null);
    }

    public EclipseWorkspaceUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, Collection<IComponentHandle> excludedComponents, int updatesToProcess, UpdateDilemmaHandler problemHandler, IDownloadMonitor dlMon) {
        super(connection, updateReports, excludedComponents, updatesToProcess, problemHandler);
        this.downloadMonitor = dlMon;
    }

    public EclipseWorkspaceUpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, Collection<IComponentHandle> excludedComponents, int updatesToProcess, UpdateDilemmaHandler problemHandler) {
        this(connection, updateReports, excludedComponents, updatesToProcess, problemHandler, null);
    }

    protected void execute(IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
        final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
        IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    EclipseWorkspaceUpdateOperation.super.execute(monitor);
                }
                catch (FileSystemClientException e) {
                    fileSystemException[0] = e;
                }
                catch (TeamRepositoryException e) {
                    teamRepoException[0] = e;
                }
            }
        };
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireRead((Collection)this.getAffectedConfigurations());
        try {
            try {
                ResourcesPlugin.getWorkspace().run(workspaceOp, reporter);
            }
            catch (FileSystemClientException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
        if (teamRepoException[0] != null) {
            throw teamRepoException[0];
        }
        if (fileSystemException[0] != null) {
            throw fileSystemException[0];
        }
    }

    public void setIgnoreList(Set<UUID> toIgnore) {
        this.ignoreList = toIgnore;
    }

    protected void loadFileArea(IWorkspaceConnection connection, Collection componentStatesBefore, Collection componentStatesAfter, FileAreaUpdateReport updates, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        EclipseWorkspaceMutator mutator = new EclipseWorkspaceMutator((IConnection)connection, componentStatesBefore, componentStatesAfter, updates, this.getDilemmaHandler(), this.downloadMonitor);
        mutator.setSkipStoreContent(this.ignoreList);
        mutator.run(progress);
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getDefaultCopyFileArea();
    }
}

