/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.MoveDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EclipseWorkspaceMoveOperation
extends FileSystemOperation {
    private ArrayList<MoveToDo> movesToDo = new ArrayList();
    private MoveDilemmaHandler moveProblemHandler;

    public EclipseWorkspaceMoveOperation(MoveDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)dilemmaHandler);
        this.moveProblemHandler = dilemmaHandler == null ? MoveDilemmaHandler.getDefault() : dilemmaHandler;
    }

    public void move(IWorkspaceConnection workspaceConnection, IComponentHandle currentComponent, IVersionableHandle itemToMove, IFolderHandle newParent, ILogicalConflictReport optionalConflictReport) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (currentComponent == null) {
            throw new IllegalArgumentException();
        }
        if (itemToMove == null) {
            throw new IllegalArgumentException();
        }
        if (newParent == null) {
            throw new IllegalArgumentException();
        }
        this.movesToDo.add(new MoveToDo(workspaceConnection, currentComponent, itemToMove, currentComponent, newParent, optionalConflictReport));
    }

    public void move(IWorkspaceConnection workspaceConnection, IComponentHandle currentComponent, IVersionableHandle itemToMove, IFolderHandle newParent, String newName, ILogicalConflictReport optionalConflictReport) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (currentComponent == null) {
            throw new IllegalArgumentException();
        }
        if (itemToMove == null) {
            throw new IllegalArgumentException();
        }
        if (newParent == null) {
            throw new IllegalArgumentException();
        }
        if (newName == null) {
            throw new IllegalArgumentException();
        }
        this.movesToDo.add(new MoveToDo(workspaceConnection, currentComponent, itemToMove, currentComponent, newParent, newName, optionalConflictReport));
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + this.movesToDo.size() * 4));
        if (this.verifyInSyncEnabled() && !this.moveProblemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.moveProblemHandler);
            for (MoveToDo move : this.movesToDo) {
                verifyOp.addToVerify((IConnection)move.workspaceConnection, move.currentComponent);
                if (move.currentComponent.sameItemId((IItemHandle)move.newComponent)) continue;
                verifyOp.addToVerify((IConnection)move.workspaceConnection, move.newComponent);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(1));
        }
        this.checkCancelled((IProgressMonitor)progress);
        for (MoveToDo move : this.movesToDo) {
            Collection ops;
            IConfiguration config = move.workspaceConnection.configuration(move.currentComponent);
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)move.workspaceConnection.teamRepository()).versionableManager();
            IVersionable versionable = move.itemToMove.hasStateId() ? versionableManager.fetchCompleteState(move.itemToMove, (IProgressMonitor)progress.newChild(1)) : config.fetchCompleteItem(move.itemToMove, (IProgressMonitor)progress.newChild(1));
            versionable = (IVersionable)versionable.getWorkingCopy();
            versionable.setParent(move.newParent);
            if (move.newName != null) {
                versionable.setName(move.newName);
            }
            IWorkspaceConnection.ISaveOp saveOp = move.workspaceConnection.configurationOpFactory().save(versionable);
            IChangeSetHandle cs = this.getBestCs(move.workspaceConnection, move.currentComponent, versionable, (IProgressMonitor)progress.newChild(1));
            if (this.shouldRemoveConflict(move.itemToMove, move.currentComponent, move.conflictReport)) {
                IItemConflictReport itemConflict = this.findConflictReport(move.itemToMove, move.currentComponent, move.conflictReport);
                ops = Collections.singleton(move.workspaceConnection.configurationOpFactory().merge((IWorkspaceConnection.IMergeResultOp)saveOp, itemConflict.getSelectedContributorState(), itemConflict.getProposedContributorState()));
            } else {
                ops = Collections.singleton(saveOp);
            }
            IUpdateReport updateReport = move.workspaceConnection.commit(cs, ops, (IProgressMonitor)progress.newChild(1));
            EclipseWorkspaceUpdateOperation updateOp = new EclipseWorkspaceUpdateOperation(move.workspaceConnection, Collections.singletonList(updateReport), 3, this.moveProblemHandler);
            this.disableVerifyInSync((IFileSystemOperation)updateOp);
            updateOp.run((IProgressMonitor)progress.newChild(1));
        }
    }

    private IItemConflictReport findConflictReport(IVersionableHandle itemToMove, IComponentHandle component, ILogicalConflictReport conflictReport) {
        if (conflictReport != null) {
            for (IItemConflictReport report : conflictReport.conflictReport().getConflictsForComponent(component)) {
                if (!report.item().sameItemId((IItemHandle)itemToMove)) continue;
                return report;
            }
        }
        return null;
    }

    private boolean shouldRemoveConflict(IVersionableHandle versionableHandle, IComponentHandle component, ILogicalConflictReport conflictReport) {
        if (conflictReport == null) {
            return false;
        }
        Collection changes = conflictReport.getChange(component, versionableHandle);
        if (changes.isEmpty()) {
            return false;
        }
        ILogicalChange change = (ILogicalChange)changes.iterator().next();
        changes.remove(change);
        if (change.kind() != 1) {
            return true;
        }
        ILogicalConflict conflict = (ILogicalConflict)change;
        if (conflict.conflictType() == 1) {
            if (conflict.item() instanceof IFolderHandle) {
                return true;
            }
            for (IVersionableHandle conflictingItem : conflict.conflictingItems()) {
                if (!conflictingItem.sameItemId((IItemHandle)conflict.item())) continue;
                return false;
            }
            return true;
        }
        if (conflict.conflictType() == 2) {
            if (conflict.item() instanceof IFolderHandle) {
                return true;
            }
            for (ILogicalChange otherChange : changes) {
                ILogicalConflict otherConflict;
                if (otherChange.kind() != 1 || (otherConflict = (ILogicalConflict)otherChange).conflictType() != 1) continue;
                return false;
            }
            return true;
        }
        if (conflict.isChangeType(2)) {
            return false;
        }
        if (conflict.conflictType() == 10) {
            return true;
        }
        if (conflict.conflictType() == 9) {
            return false;
        }
        if (conflict.conflictType() == 7) {
            for (ILogicalChange otherChange : changes) {
                ILogicalConflict otherConflict;
                if (otherChange.kind() != 1 || (otherConflict = (ILogicalConflict)otherChange).conflictType() != 9) continue;
                return false;
            }
            return true;
        }
        if (conflict.conflictType() == 8) {
            for (ILogicalChange otherChange : changes) {
                ILogicalConflict otherConflict;
                if (otherChange.kind() != 1 || (otherConflict = (ILogicalConflict)otherChange).conflictType() != 9) continue;
                return false;
            }
            return true;
        }
        if (conflict.conflictType() == 6) {
            for (ILogicalChange otherChange : changes) {
                ILogicalConflict otherConflict;
                if (otherChange.kind() != 1 || (otherConflict = (ILogicalConflict)otherChange).conflictType() != 9) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private IChangeSetHandle getBestCs(IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionable versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSetHandle changeSet2;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        List changesetHandles = workspaceConnection.activeChangeSets(component);
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changesetHandles, 0, (IProgressMonitor)progress.newChild(1));
        for (IChangeSetHandle changeSet2 : changeSets) {
            for (IChange change : changeSet2.changes()) {
                IVersionableHandle item = change.item();
                if (!versionable.sameItemId((IItemHandle)item)) continue;
                return changeSet2;
            }
        }
        changeSet2 = workspaceConnection.getCurrentChangeSet(component);
        if (changeSet2 == null) {
            changeSet2 = workspaceConnection.createChangeSet(component, "", true, (IProgressMonitor)progress.newChild(1));
        }
        return changeSet2;
    }

    public static boolean candidateForMove(ILogicalChange change) {
        if (change.kind() == 2) {
            return false;
        }
        if (change.kind() == 3) {
            if (!change.isChangeType(2) && change.isChangeType(20) && !change.isChangeType(8)) {
                return false;
            }
        } else {
            if (change.isChangeType(2)) {
                return false;
            }
            if (((ILogicalConflict)change).conflictType() == 9) {
                return false;
            }
            if (((ILogicalConflict)change).conflictType() == 1) {
                for (IVersionableHandle conflictingItem : ((ILogicalConflict)change).conflictingItems()) {
                    if (!conflictingItem.sameItemId((IItemHandle)change.item())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static class MoveToDo {
        public final IWorkspaceConnection workspaceConnection;
        public final IComponentHandle currentComponent;
        public final IVersionableHandle itemToMove;
        public final IComponentHandle newComponent;
        public final IFolderHandle newParent;
        public final String newName;
        public final ILogicalConflictReport conflictReport;

        public MoveToDo(IWorkspaceConnection workspaceConnection, IComponentHandle currentComponent, IVersionableHandle itemToMove, IComponentHandle newComponent, IFolderHandle newParent, ILogicalConflictReport optionalConflictReport) {
            this(workspaceConnection, currentComponent, itemToMove, newComponent, newParent, null, optionalConflictReport);
        }

        public MoveToDo(IWorkspaceConnection workspaceConnection, IComponentHandle currentComponent, IVersionableHandle itemToMove, IComponentHandle newComponent, IFolderHandle newParent, String newName, ILogicalConflictReport optionalConflictReport) {
            this.workspaceConnection = workspaceConnection;
            this.currentComponent = currentComponent;
            this.itemToMove = itemToMove;
            this.newComponent = newComponent;
            this.newParent = newParent;
            this.newName = newName;
            this.conflictReport = optionalConflictReport;
            if (!currentComponent.sameItemId((IItemHandle)newComponent)) {
                throw new UnsupportedOperationException("Move between components not supported yet");
            }
        }
    }
}

