/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceUpdateOperation;
import com.ibm.team.filesystem.rcp.core.operations.EclipseWorkspaceVerifySharesOperation;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardOperation
extends ChangeHistoryChangeSetsOperation {
    private final IWorkspaceConnection workspaceConnection;
    private final List<IChangeSetHandle> changeSetHandles;
    private final DiscardDilemmaHandler problemHandler;

    public DiscardOperation(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSetsToDiscard, DiscardDilemmaHandler dilemmaHandler) {
        super((ChangeHistoryChangeSetsDilemmaHandler)(dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler));
        DiscardDilemmaHandler discardDilemmaHandler = this.problemHandler = dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changeSetsToDiscard == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceConnection = workspace;
        this.changeSetHandles = new ArrayList<IChangeSetHandle>(changeSetsToDiscard.size());
        HashSet<UUID> duplicateCheck = new HashSet<UUID>();
        for (IChangeSetHandle iChangeSetHandle : changeSetsToDiscard) {
            if (iChangeSetHandle == null) {
                throw new IllegalArgumentException();
            }
            if (!duplicateCheck.add(iChangeSetHandle.getItemId())) {
                throw new IllegalArgumentException();
            }
            this.changeSetHandles.add(iChangeSetHandle);
        }
        if (this.changeSetHandles.isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(5));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants);
        try {
            try {
                final TeamRepositoryException[] teamRepoException = new TeamRepositoryException[1];
                final FileSystemClientException[] fileSystemException = new FileSystemClientException[1];
                IWorkspaceRunnable workspaceOp = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            DiscardOperation.this.discard(affectedConfigurations, monitor);
                        }
                        catch (FileSystemClientException e) {
                            fileSystemException[0] = e;
                        }
                        catch (TeamRepositoryException e) {
                            teamRepoException[0] = e;
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceOp, (IProgressMonitor)progress.newChild(95));
                if (teamRepoException[0] != null) {
                    throw teamRepoException[0];
                }
                if (fileSystemException[0] != null) {
                    throw fileSystemException[0];
                }
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)workspaceLock);
        }
    }

    private void discard(Collection<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)(3 * this.changeSetHandles.size() + 2));
        if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            EclipseWorkspaceVerifySharesOperation verifyOp = new EclipseWorkspaceVerifySharesOperation((OutOfSyncDilemmaHandler)this.problemHandler);
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)this.workspaceConnection, configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(1));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, (IProgressMonitor)progress.newChild(1));
        this.workspaceConnection.ensureClosed(this.changeSetHandles, (IProgressMonitor)progress.newChild(this.changeSetHandles.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IUpdateReport report = this.workspaceConnection.discardChangeSets(false, this.changeSetHandles, (IProgressMonitor)progress.newChild(this.changeSetHandles.size()));
        EclipseWorkspaceUpdateOperation updateOperation = new EclipseWorkspaceUpdateOperation(this.workspaceConnection, Collections.singletonList(report), 3, (UpdateDilemmaHandler)this.problemHandler);
        this.disableVerifyInSync((IFileSystemOperation)updateOperation);
        updateOperation.run((IProgressMonitor)progress.newChild(this.changeSetHandles.size()));
    }

    private Collection<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        List changeSets = this.workspaceConnection.teamRepository().itemManager().fetchCompleteItems(this.changeSetHandles, 0, monitor);
        determinants.addAll(changeSets);
        for (IChangeSet changeSet : changeSets) {
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)this.workspaceConnection, changeSet.getComponent()));
        }
        return affectedConfigurations;
    }

    public IFileSystemOperation getCheckInOperation(IWorkspaceConnection connection, IComponentHandle componentHandle, ILocalChange[] changes, String comment, CommitDilemmaHandler commitDilemmaHandler) {
        return new NewCheckInOperation(connection, componentHandle, changes, comment, commitDilemmaHandler);
    }
}

