/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyOutOfSyncUtil {
    public static OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler(ParmsOutOfSyncInstructions outOfSyncInstructions, final List<ShareDTO> sharesOutOfSyncReported) {
        if (outOfSyncInstructions == null) {
            return OutOfSyncDilemmaHandler.getDefault();
        }
        final int noPendingChangesInstruction = VerifyOutOfSyncUtil.getInstruction(outOfSyncInstructions.outOfSyncNoPendingChanges);
        final int withPendingChangesInstruction = VerifyOutOfSyncUtil.getInstruction(outOfSyncInstructions.outOfSyncWithPendingChanges);
        final boolean removedSharesInstruction = outOfSyncInstructions.deleteRemovedShares == null ? false : outOfSyncInstructions.deleteRemovedShares;
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                if (sharesOutOfSyncReported != null) {
                    for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                        sharesOutOfSyncReported.add(CoreUtil.translateShare(shareOutOfSync.getShare()));
                    }
                }
                IShare[] shares = new IShare[sharesOutOfSync.size()];
                int i = 0;
                for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                    shares[i] = shareOutOfSync.getShare();
                    ++i;
                }
                ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(shares);
                if (changes.length == 0) {
                    return noPendingChangesInstruction;
                }
                return withPendingChangesInstruction;
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return sharesOutOfSyncReported == null && noPendingChangesInstruction == 0 && withPendingChangesInstruction == 0;
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() == 1) {
                        collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                        continue;
                    }
                    return 2;
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(removedSharesInstruction);
                }
                return 0;
            }
        };
        return outOfSyncDilemmaHandler;
    }

    private static int getInstruction(String instruction) {
        if ("load".equals(instruction)) {
            return 100;
        }
        if ("cancel".equals(instruction)) {
            return 1;
        }
        if ("continue".equals(instruction)) {
            return 0;
        }
        return 2;
    }
}

