/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraSyncReport;
import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSetsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveChangeSet;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ItemIdDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkItemSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IMultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ConflictResolutionUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.HistoryBin;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LabelsUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.Pair;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.common.collection.IFilter;
import com.ibm.team.repository.rcp.core.preferences.TempFileStore;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SyncViewDTOUtil {
    public static void startSyncViewRefreshNotification(final IServerNotificationChannel notifier) {
        IListener listener = new IListener(){

            public void handleEvents(List events) {
                notifier.queueNotification("SyncViewDTORefreshNotification", IFilesystemRestClient.SyncViewDTORefreshEvent.TYPE, (IParameterWrapper)new IFilesystemRestClient.SyncViewDTORefreshEvent());
            }
        };
        IComponentSyncModel csm = ComponentSyncModel.getInstance();
        csm.addGenericListener("currentActivity", listener);
        csm.addGenericListener("loggedIn", listener);
        csm.addGenericListener("refreshedRemoteCompleted", listener);
        csm.addGenericListener("refreshedRemoteProgress", listener);
        csm.addGenericListener("shareablesChangedRefreshed", listener);
        csm.addGenericListener("loadedComponents", listener);
        csm.addGenericListener("refreshedUnresolvedCompleted", listener);
        csm.addGenericListener("workspaceSyncContexts", listener);
        csm.addGenericListener("componentSyncContexts", listener);
    }

    public static SyncViewDTO getSyncView(IComponentSyncModel csm) {
        SyncViewDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createSyncViewDTO();
        result.setId(csm.hashCode());
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = SyncViewDTOUtil.sortByName(csm.getWorkspaceSyncContexts());
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext wsc = iWorkspaceSyncContextArray[n2];
            result.getWorkspaces().add(SyncViewDTOUtil.getWorkspaceSyncDTO(wsc));
            ++n2;
        }
        return result;
    }

    public static Object find(Object element, int id) {
        if (element instanceof Collection) {
            for (Object object : (Collection)element) {
                Object result = SyncViewDTOUtil.find(object, id);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        if (element.hashCode() == id) {
            return element;
        }
        if (element instanceof IComponentSyncModel) {
            return SyncViewDTOUtil.find(Arrays.asList(((IComponentSyncModel)element).getWorkspaceSyncContexts()), id);
        }
        if (element instanceof IWorkspaceSyncContext) {
            return SyncViewDTOUtil.find(Arrays.asList(((IWorkspaceSyncContext)element).getComponentSyncContexts()), id);
        }
        if (element instanceof IComponentSyncContext) {
            IComponentSyncContext csc = (IComponentSyncContext)element;
            ArrayList<Object> children = new ArrayList<Object>();
            children.add(csc.getActivitySources());
            children.add(csc.getUnresolvedSource());
            return SyncViewDTOUtil.find(children, id);
        }
        if (element instanceof IActivitySource) {
            IActivitySource source = (IActivitySource)element;
            ArrayList<List> children = new ArrayList<List>();
            children.add(source.getActivities());
            children.add(source.getBaselines());
            return SyncViewDTOUtil.find(children, id);
        }
        if (element instanceof IUnresolvedSource) {
            IUnresolvedSource source = (IUnresolvedSource)element;
            return SyncViewDTOUtil.find(source.getFolders(), id);
        }
        if (element instanceof IUnresolvedFolder) {
            IUnresolvedFolder folder = (IUnresolvedFolder)element;
            return SyncViewDTOUtil.find(folder.getItems(), id);
        }
        if (element instanceof IUnresolvedItem) {
            IUnresolvedItem item = (IUnresolvedItem)element;
            ArrayList<Collection<IConflictItem>> children = new ArrayList<Collection<IConflictItem>>();
            children.add(item.getConflictItems());
            children.add(item.getLocalChanges());
            return SyncViewDTOUtil.find(children, id);
        }
        if (element instanceof IBaselineGroup) {
            return SyncViewDTOUtil.find(((IBaselineGroup)element).getActivities(), id);
        }
        if (element instanceof IRemoteActivity) {
            IRemoteActivity activity = (IRemoteActivity)element;
            ArrayList<List<IFileSystemWorkItem>> children = new ArrayList<List<IFileSystemWorkItem>>();
            children.add(activity.getFolders());
            children.add(activity.getWorkItems());
            return SyncViewDTOUtil.find(children, id);
        }
        if (element instanceof IActivityFolder) {
            IActivityFolder folder = (IActivityFolder)element;
            return SyncViewDTOUtil.find(folder.getActivity().getChanges(folder), id);
        }
        return null;
    }

    static WorkspaceSyncDTO getWorkspaceSyncDTO(IWorkspaceSyncContext wsc) {
        WorkspaceSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createWorkspaceSyncDTO();
        result.setId(wsc.hashCode());
        result.setRepositoryUrl(wsc.teamRepository().getRepositoryURI());
        result.setRepositoryLoggedIn(wsc.teamRepository().loggedIn());
        result.setWorkspaceName(wsc.getLocal().getName());
        result.setWorkspaceItemId(wsc.getLocal().getResolvedWorkspace().getItemId().getUuidValue());
        IWorkspace targetWorkspace = ((IWorkspaceConnection)wsc.getRemote()).getResolvedWorkspace();
        result.setTargetWorkspaceName(targetWorkspace.getName());
        result.setTargetRepositoryUrl(wsc.getRemote().teamRepository().getRepositoryURI());
        result.setTargetRepositoryLoggedIn(wsc.getRemote().teamRepository().loggedIn());
        result.setTargetWorkspaceItemId(targetWorkspace.getItemId().getUuidValue());
        IComponentSyncContext[] iComponentSyncContextArray = SyncViewDTOUtil.sortByName(wsc.getComponentSyncContexts());
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext csc = iComponentSyncContextArray[n2];
            result.getComponents().add(SyncViewDTOUtil.getComponentSyncDTO(csc));
            ++n2;
        }
        return result;
    }

    static ComponentSyncDTO getComponentSyncDTO(IComponentSyncContext csc) {
        ChangeSetSyncDTO changeSetSyncDTO;
        ComponentSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createComponentSyncDTO();
        result.setId(csc.hashCode());
        result.setComponentName(csc.getComponent().getName());
        result.setComponentItemId(csc.getComponent().getItemId().getUuidValue());
        result.setPrivateType(csc.getType() == 1);
        result.setBothType(csc.getType() == 2);
        result.setLocalAddedType(csc.getType() == 3);
        result.setLocalRemovedType(csc.getType() == 4);
        result.setTargetAddedType(csc.getType() == 5);
        result.setTargetRemovedType(csc.getType() == 6);
        result.setReplaced(ComponentSyncUtil.isReplaced(csc));
        result.setLoaded(!ComponentSyncUtil.isDisconnected(csc));
        IWorkspace targetWorkspace = csc.getIncomingTeamPlace().getResolvedWorkspace();
        result.setTargetWorkspaceName(targetWorkspace.getName());
        result.setTargetRepositoryUrl(csc.getIncomingTeamPlace().teamRepository().getRepositoryURI());
        result.setTargetRepositoryLoggedIn(csc.getIncomingTeamPlace().teamRepository().loggedIn());
        result.setTargetWorkspaceItemId(targetWorkspace.getItemId().getUuidValue());
        for (IRemoteActivity activity : csc.getOutgoingActivitySource().getActivities()) {
            changeSetSyncDTO = SyncViewDTOUtil.getChangeSetSyncDTO(activity);
            if (changeSetSyncDTO == null) continue;
            result.getOutgoingChangeSetsAfterBasis().add(changeSetSyncDTO);
        }
        for (IBaselineGroup group : csc.getOutgoingActivitySource().getBaselines()) {
            result.getOutgoingBaselines().add(SyncViewDTOUtil.getBaselineSyncDTO(group));
        }
        for (IRemoteActivity activity : csc.getIncomingActivitySource().getActivities()) {
            changeSetSyncDTO = SyncViewDTOUtil.getChangeSetSyncDTO(activity);
            if (changeSetSyncDTO == null) continue;
            result.getIncomingChangeSetsAfterBasis().add(changeSetSyncDTO);
        }
        for (IBaselineGroup group : csc.getIncomingActivitySource().getBaselines()) {
            result.getIncomingBaselines().add(SyncViewDTOUtil.getBaselineSyncDTO(group));
        }
        for (IRemoteActivity activity : csc.getSuspendedActivitySource().getActivities()) {
            changeSetSyncDTO = SyncViewDTOUtil.getChangeSetSyncDTO(activity);
            if (changeSetSyncDTO == null) continue;
            result.getSuspended().add(changeSetSyncDTO);
        }
        IUnresolvedFolder[] iUnresolvedFolderArray = SyncViewDTOUtil.sortByName(csc.getUnresolvedSource().getFolders());
        int n = iUnresolvedFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUnresolvedFolder folder = iUnresolvedFolderArray[n2];
            result.getUnresolved().add(SyncViewDTOUtil.getUnresolvedFolderSyncDTO(folder));
            ++n2;
        }
        IChangeSetHandle current = csc.getOutgoingTeamPlace().getCurrentChangeSet((IComponentHandle)csc.getComponent());
        if (current != null) {
            result.setCurrentOutgoingChangeSetItemId(current.getItemId().getUuidValue());
        }
        return result;
    }

    static BaselineSyncDTO getBaselineSyncDTO(IBaselineGroup group) {
        BaselineSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createBaselineSyncDTO();
        result.setId(group.hashCode());
        result.setBaselineName(group.getBaseline().getName());
        result.setBaselineItemId(group.getBaseline().getItemId().getUuidValue());
        result.setPreviousBaselineName(group.getAncestor().getName());
        result.setPreviousBaselineItemId(group.getAncestor().getItemId().getUuidValue());
        List activities = null;
        result.setChangeSetsResolved(false);
        result.setCreationDate(HistoryBin.formatDif(group.getBaseline().getCreationDate(), true, true));
        if (group.getResolve()) {
            activities = group.getActivities();
            for (IRemoteActivity activity : activities) {
                ChangeSetSyncDTO changeSetSyncDTO = SyncViewDTOUtil.getChangeSetSyncDTO(activity);
                if (changeSetSyncDTO == null) continue;
                result.getChangeSets().add(changeSetSyncDTO);
            }
            result.setChangeSetsResolved(true);
        }
        return result;
    }

    static ChangeSetSyncDTO getChangeSetSyncDTO(IRemoteActivity activity) {
        IChangeSet changeSet = activity.getChangeSet();
        if (changeSet == null) {
            return null;
        }
        ChangeSetSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeSetSyncDTO();
        result.setId(activity.hashCode());
        result.setChangeSetComment(changeSet.getComment());
        result.setChangeSetItemId(changeSet.getItemId().getUuidValue());
        if (changeSet.getOrigin() instanceof ITeamRepository) {
            result.setRepositoryUrl(((ITeamRepository)changeSet.getOrigin()).getRepositoryURI());
        }
        result.setHiddenChanges(activity.errorChanges() ? changeSet.changes().size() : 0);
        result.setIsActive(changeSet.isActive());
        result.setAuthorContributorItemId(changeSet.getAuthor().getItemId().getUuidValue());
        result.setModified(HistoryBin.formatDif(activity.getModified(), true, true));
        IContributor contributor = activity.getModifiedBy();
        if (contributor != null) {
            result.setAuthorContributorName(contributor.getName());
        }
        for (IFileSystemWorkItem wi : activity.getWorkItems()) {
            result.getWorkItems().add(SyncViewDTOUtil.getWorkItemSyncDTO(wi));
        }
        for (IActivityFolder folder : activity.getFolders()) {
            result.getChanges().add(SyncViewDTOUtil.getChangeFolderSyncDTO(folder));
        }
        return result;
    }

    static WorkItemSyncDTO getWorkItemSyncDTO(IFileSystemWorkItem wi) {
        WorkItemSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createWorkItemSyncDTO();
        result.setId(wi.hashCode());
        ITeamRepository repo = wi.getActivity().getActivitySource().getModel().teamRepository();
        ClientProviderFactory providerFactory = new ClientProviderFactory(repo);
        try {
            List items = providerFactory.getItemProvider().fetchItems(Collections.singletonList(wi.getWorkItemHandle()), null);
            String label = XMLString.createFromXMLText((String)ChangeSetLinks.summarizeItems((ProviderFactory)providerFactory, (List)items, null)).getPlainText();
            result.setLabel(label);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        result.setWorkItemItemId(wi.getWorkItemHandle().getItemId().getUuidValue());
        return result;
    }

    static ChangeFolderSyncDTO getChangeFolderSyncDTO(IActivityFolder folder) {
        ChangeFolderSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeFolderSyncDTO();
        result.setId(folder.hashCode());
        result.setPath(folder.getPath());
        for (IRemoteChangeSummary rcs : folder.getActivity().getChanges(folder)) {
            result.getChanges().add(SyncViewDTOUtil.getChangeSyncDTO(rcs));
        }
        return result;
    }

    static ChangeSyncDTO getChangeSyncDTO(IRemoteChangeSummary rcs) {
        IComponentSyncContext context;
        ChangeSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeSyncDTO();
        result.setId(rcs.hashCode());
        result.setVersionableName(rcs.getResourceName());
        result.setVersionableItemId(rcs.getItem().getItemId().getUuidValue());
        result.setFile(rcs.getItem() instanceof IFileItemHandle);
        IChangeSummary changeSummary = rcs.getChangeSummary();
        result.setAddType(changeSummary.isChangeType(1));
        result.setDeleteType(changeSummary.isChangeType(2));
        result.setModifyType(changeSummary.isChangeType(4));
        result.setMoveType(changeSummary.isChangeType(8));
        result.setNoopType(changeSummary.isChangeType(16));
        result.setPathHint(ComponentSyncUtil.toString(changeSummary.getPathHint(), false));
        String[] newPathHint = changeSummary.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ComponentSyncUtil.toString(newPathHint, false));
        }
        if (rcs.getChange() != null) {
            IVersionableHandle lastMergeState;
            IChange change = rcs.getChange();
            if (change.beforeState() != null) {
                result.setBeforeStateId(change.beforeState().getStateId().getUuidValue());
            }
            if (change.afterState() != null) {
                result.setAfterStateId(change.afterState().getStateId().getUuidValue());
            }
            if (change.mergeStates().size() > 0 && (lastMergeState = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1)) != null && lastMergeState.getStateId() != null) {
                result.setLastMergeState(lastMergeState.getStateId().getUuidValue());
            }
        }
        result.setPotentialConflict(!(context = rcs.getActivity().getActivitySource().getModel()).hasConflict(rcs).isEmpty());
        return result;
    }

    static UnresolvedFolderSyncDTO getUnresolvedFolderSyncDTO(IUnresolvedFolder folder) {
        UnresolvedFolderSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createUnresolvedFolderSyncDTO();
        result.setId(folder.hashCode());
        result.setPath(folder.getPath());
        IUnresolvedItem[] iUnresolvedItemArray = SyncViewDTOUtil.sortByName(folder.getItems());
        int n = iUnresolvedItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUnresolvedItem ui = iUnresolvedItemArray[n2];
            IConflictItem[] iConflictItemArray = SyncViewDTOUtil.sortByName(ui.getConflictItems());
            int n3 = iConflictItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConflictItem ci = iConflictItemArray[n4];
                result.getConflicts().add(SyncViewDTOUtil.getConflictSyncDTO(ci));
                ++n4;
            }
            iConflictItemArray = SyncViewDTOUtil.sortByName(ui.getLocalChanges());
            n3 = iConflictItemArray.length;
            n4 = 0;
            while (n4 < n3) {
                IConflictItem lc = iConflictItemArray[n4];
                result.getLocalChanges().add(SyncViewDTOUtil.getLocalChangeSyncDTO((ILocalChange)lc));
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    static ConflictSyncDTO getConflictSyncDTO(IConflictItem ci) {
        ConflictSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createConflictSyncDTO();
        result.setId(ci.hashCode());
        result.setName(ci.getName(true));
        ILogicalChange logicalChange = ci.getLogicalChange();
        result.setPathHint(ComponentSyncUtil.toString(logicalChange.getPathHint(), false));
        String[] newPathHint = logicalChange.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ComponentSyncUtil.toString(newPathHint, false));
        }
        result.setConflictTypeOutgoing(LabelsUtil.getConflictInformation(logicalChange, true, false));
        result.setConflictTypeProposed(LabelsUtil.getConflictInformation(logicalChange, false, false));
        result.setVersionableItemId(ci.getItem().getItemId().getUuidValue());
        result.setFile(ci.getItem() instanceof IFileItemHandle);
        result.setKind(ConflictResolutionUtil.getKind(logicalChange));
        result.setConflictType(ConflictResolutionUtil.getConflictType(logicalChange));
        IItemConflictReport icr = ci.getItemConflictReport();
        if (icr.getProposedContributorState() != null) {
            result.setProposedContributorVersionableStateId(icr.getProposedContributorState().getStateId().getUuidValue());
        }
        if (icr.getCommonAncestorState() != null) {
            result.setCommonAncestorVersionableStateId(icr.getCommonAncestorState().getStateId().getUuidValue());
        }
        if (icr.getOriginalSelectedContributorState() != null) {
            result.setOriginalSelectedContributorVersionableStateId(icr.getOriginalSelectedContributorState().getStateId().getUuidValue());
        }
        if (icr.getSelectedContributorState() != null) {
            result.setSelectedContributorVersionableStateId(icr.getSelectedContributorState().getStateId().getUuidValue());
        }
        return result;
    }

    static LocalChangeSyncDTO getLocalChangeSyncDTO(ILocalChange lc) {
        LocalChangeSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createLocalChangeSyncDTO();
        result.setId(lc.hashCode());
        result.setAdditionType(lc.isType(2));
        result.setAttributesType(lc.isType(32));
        result.setContentType(lc.isType(1));
        result.setDeletionType(lc.isType(4));
        result.setName(lc.getPath().lastSegment());
        result.setTargetVersionableItemId(lc.getTarget().getItemId().getUuidValue());
        result.setFile(lc.getTarget() instanceof IFileItemHandle);
        InverseFileItemInfo fii = CopyFileAreaStore.getDefaultCopyFileArea().getItemInfo(lc.getTarget(), lc.getComponent(), lc.getConnection());
        if (fii != null && fii.getVersionableHandle() != null && fii.getVersionableHandle().getStateId() != null) {
            result.setTargetVersionableStateId(fii.getVersionableHandle().getStateId().getUuidValue());
        }
        if (lc.getOriginalPath() != null) {
            result.setOriginalPath(lc.getOriginalPath().toString());
        }
        result.setPath(lc.getPath().toString());
        if (lc.getResultingPath() != null) {
            result.setResultingPath(lc.getResultingPath().toString());
        }
        return result;
    }

    static IWorkspaceSyncContext[] sortByName(IWorkspaceSyncContext[] wscs) {
        Arrays.sort(wscs, new Comparator<IWorkspaceSyncContext>(){

            @Override
            public int compare(IWorkspaceSyncContext o1, IWorkspaceSyncContext o2) {
                IWorkspaceConnection wc1 = o1.getLocal();
                IWorkspaceConnection wc2 = o2.getLocal();
                int compare = wc1.getName().compareToIgnoreCase(wc2.getName());
                return compare != 0 ? compare : o1.getRemote().getName().compareToIgnoreCase(o2.getRemote().getName());
            }
        });
        return wscs;
    }

    static IComponentSyncContext[] sortByName(IComponentSyncContext[] cscs) {
        Arrays.sort(cscs, new Comparator<IComponentSyncContext>(){

            @Override
            public int compare(IComponentSyncContext o1, IComponentSyncContext o2) {
                IComponent component1 = o1.getComponent();
                IComponent component2 = o2.getComponent();
                int compareComponent = component1.getName().compareToIgnoreCase(component2.getName());
                return compareComponent != 0 ? compareComponent : o1.getIncomingConnection().getName().compareToIgnoreCase(o2.getIncomingConnection().getName());
            }
        });
        return cscs;
    }

    static IUnresolvedFolder[] sortByName(Collection<IUnresolvedFolder> ufs) {
        IUnresolvedFolder[] result = ufs.toArray(new IUnresolvedFolder[ufs.size()]);
        Arrays.sort(result, new Comparator<IUnresolvedFolder>(){

            @Override
            public int compare(IUnresolvedFolder o1, IUnresolvedFolder o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return result;
    }

    static IUnresolvedItem[] sortByName(Collection<IUnresolvedItem> uis) {
        IUnresolvedItem[] result = uis.toArray(new IUnresolvedItem[uis.size()]);
        Arrays.sort(result, new Comparator<IUnresolvedItem>(){

            @Override
            public int compare(IUnresolvedItem o1, IUnresolvedItem o2) {
                return o1.getResourceName().compareTo(o2.getResourceName());
            }
        });
        return result;
    }

    static IConflictItem[] sortByName(Collection<IConflictItem> cis) {
        IConflictItem[] result = cis.toArray(new IConflictItem[cis.size()]);
        Arrays.sort(result, new Comparator<IConflictItem>(){

            @Override
            public int compare(IConflictItem o1, IConflictItem o2) {
                return o1.getName(true).compareTo(o2.getName(true));
            }
        });
        return result;
    }

    static ILocalChange[] sortByName(Collection<ILocalChange> lcs) {
        ILocalChange[] result = lcs.toArray(new ILocalChange[lcs.size()]);
        Arrays.sort(result, new Comparator<ILocalChange>(){

            @Override
            public int compare(ILocalChange o1, ILocalChange o2) {
                return o1.getPath().lastSegment().compareTo(o2.getPath().lastSegment());
            }
        });
        return result;
    }

    public static BaselineSyncDTO getChangeSetsBaseline(IComponentSyncModel model, ParmsChangeSetsBaseline parms, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        BaselineSyncDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createBaselineSyncDTO();
        IMultiComponentSyncContext wscResult = null;
        IWorkspaceSyncContext[] iWorkspaceSyncContextArray = model.getWorkspaceSyncContexts();
        int n = iWorkspaceSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceSyncContext wsc = iWorkspaceSyncContextArray[n2];
            if (parms.activeWorkspace.workspaceItemId.equals(wsc.getLocal().getResolvedWorkspace().getItemId().getUuidValue())) {
                wscResult = wsc;
                break;
            }
            ++n2;
        }
        IComponentSyncContext cscResult = null;
        if (wscResult != null) {
            IComponentSyncContext[] iComponentSyncContextArray = wscResult.getComponentSyncContexts();
            int n3 = iComponentSyncContextArray.length;
            n = 0;
            while (n < n3) {
                IComponentSyncContext csc = iComponentSyncContextArray[n];
                if (parms.componentItemId.equals(csc.getComponent().getItemId().getUuidValue()) && parms.targetWorkspace.workspaceItemId.equals(csc.getIncomingTeamPlace().getResolvedWorkspace().getItemId().getUuidValue())) {
                    cscResult = csc;
                    break;
                }
                ++n;
            }
        }
        IBaselineGroup bgResult = null;
        if (cscResult != null) {
            for (IBaselineGroup bg : cscResult.getIncomingActivitySource().getBaselines()) {
                if (!parms.baseline.baselineItemId.equals(bg.getBaseline().getItemId().getUuidValue())) continue;
                bgResult = bg;
                break;
            }
            for (IBaselineGroup bg : cscResult.getOutgoingActivitySource().getBaselines()) {
                if (!parms.baseline.baselineItemId.equals(bg.getBaseline().getItemId().getUuidValue())) continue;
                bgResult = bg;
                break;
            }
        }
        if (bgResult != null) {
            if (!bgResult.getResolve()) {
                ComponentBaselineUtil.syncResolve(bgResult);
                cscResult.refresh(true, monitor);
            }
            result = SyncViewDTOUtil.getBaselineSyncDTO(bgResult);
        }
        return result;
    }

    public static List<ChangeSetSyncDTO> createChangeSetDTOsFromChangeSets(ITeamRepository repo, List<ItemId<IChangeSet>> itemIds, ParmsResolveChangeSet settings, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map fetchedChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, itemIds, (IProgressMonitor)progress.newChild(20));
        Map fetchedChanges = ClientConfigurationChangeFactory.createChanges((ITeamRepository)repo, fetchedChangeSets.values(), (IProgressMonitor)progress.newChild(20));
        Map<ItemId<IChangeSet>, ChangeDescription> fetchedDescriptions = ConfigurationChangeFactory.getDescriptions(repo, fetchedChangeSets.values(), (IProgressMonitor)progress.newChild(20));
        ArrayList<Pair<ConfigurationChange, ChangeDescription>> toCompute = new ArrayList<Pair<ConfigurationChange, ChangeDescription>>();
        for (ItemId<IChangeSet> next : itemIds) {
            ConfigurationChange change = (ConfigurationChange)fetchedChanges.get(next);
            ChangeDescription description = fetchedDescriptions.get(next);
            toCompute.add(Pair.create(change, description));
        }
        return SyncViewDTOUtil.createChangeSetDTOs(repo, toCompute, settings, (IProgressMonitor)progress.newChild(40));
    }

    public static List<ChangeSetSyncDTO> createChangeSetDTOsFromPatches(ITeamRepository repo, Map<UUID, ParsedPatch> changes, ParmsResolveChangeSet settings, IProgressMonitor monitor) throws TeamRepositoryException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean includeChanges = settings.includeChanges == null ? false : settings.includeChanges;
        boolean includeFoldersTwice = settings.includeFoldersInChangeLists == null ? false : settings.includeFoldersInChangeLists;
        boolean includeFileStates = settings.fileStatesPath != null;
        TempFileStore fileStore = null;
        if (includeFileStates) {
            fileStore = new TempFileStore((IPath)new Path(settings.fileStatesPath));
        }
        HashSet<ItemId> toFetch = new HashSet<ItemId>();
        for (Map.Entry<UUID, ParsedPatch> nextEntry : changes.entrySet()) {
            ParsedPatch next = nextEntry.getValue();
            ChangeDescription description = next.getDescription();
            ItemId component = ItemId.upcast((ItemId)description.getComponent());
            toFetch.add(component);
            toFetch.addAll(description.getWorkItems());
            if (description.getAuthors().size() == 1) {
                ItemId authorId = ItemId.upcast((ItemId)((ItemId)description.getAuthors().iterator().next()));
                toFetch.add(authorId);
            }
            if (description.getChangeSets().size() != 1) continue;
            ItemId changeSet = ItemId.upcast((ItemId)((ItemId)description.getChangeSets().iterator().next()));
            toFetch.add(changeSet);
        }
        Map fetchedItems = RepoFetcher.fetchCurrents((ITeamRepository)repo, toFetch, (IProgressMonitor)progress.newChild(20));
        progress.setWorkRemaining(40);
        ArrayList<ChangeSetSyncDTO> result = new ArrayList<ChangeSetSyncDTO>();
        SubMonitor loopProgress = progress.newChild(40).setWorkRemaining(changes.size());
        for (Map.Entry<UUID, ParsedPatch> nextEntry : changes.entrySet()) {
            ItemId changeSetId;
            IChangeSet changeSet;
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            ParsedPatch next = nextEntry.getValue();
            ChangeDescription description = next.getDescription();
            ChangeSetSyncDTO nextDTO = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeSetSyncDTO();
            if (description.getAuthors().size() == 1) {
                ItemId authorId = (ItemId)description.getAuthors().iterator().next();
                nextDTO.setAuthorContributorItemId(authorId.getItemUUID().getUuidValue());
                IContributor author = (IContributor)fetchedItems.get(authorId);
                if (author != null) {
                    nextDTO.setAuthorContributorName(author.getName());
                }
            }
            nextDTO.setChangeSetComment(description.getComment());
            nextDTO.setChangeSetItemId(nextEntry.getKey().getUuidValue());
            nextDTO.setRepositoryUrl(repo.getRepositoryURI());
            ItemId componentId = description.getComponent();
            if (!componentId.isNull()) {
                nextDTO.setComponentItemId(componentId.getItemUUID().getUuidValue());
                IComponent component = (IComponent)fetchedItems.get(componentId);
                if (component != null) {
                    nextDTO.setComponentName(component.getName());
                }
            }
            if (description.getChangeSets().size() == 1 && (changeSet = (IChangeSet)fetchedItems.get(changeSetId = (ItemId)description.getChangeSets().iterator().next())) != null) {
                nextDTO.setIsActive(changeSet.isActive());
            }
            nextDTO.setLastChangeDate(description.getDate().getTime());
            ClientProviderFactory providerFactory = new ClientProviderFactory(repo);
            Collection nextWorkItems = description.getWorkItems();
            if (nextWorkItems == null) {
                nextWorkItems = Collections.emptyList();
            }
            for (ItemId nextWorkItem : nextWorkItems) {
                IAuditable wi = (IAuditable)fetchedItems.get(nextWorkItem);
                if (!(wi instanceof IManagedItem)) continue;
                IAuditable mi = wi;
                String label = XMLString.createFromXMLText((String)ChangeSetLinks.summarizeItems((ProviderFactory)providerFactory, Collections.singletonList(mi), null)).getPlainText();
                WorkItemSyncDTO wiDto = FilesystemRestClientDTOsyncFactory.eINSTANCE.createWorkItemSyncDTO();
                wiDto.setLabel(label);
                wiDto.setWorkItemItemId(mi.getItemId().getUuidValue());
                nextDTO.getWorkItems().add(wiDto);
            }
            if (includeChanges) {
                HashMap<ItemId, List<ChangeSyncDTO>> mapParentIdOntoChildChanges = new HashMap<ItemId, List<ChangeSyncDTO>>();
                SubMonitor filePatchProgress = iterationProgress.newChild(1).setWorkRemaining(next.getFilePatchSet().size());
                for (ParsedFilePatch change : next.getFilePatchSet()) {
                    SubMonitor changeProgress = filePatchProgress.newChild(1);
                    List<PatchOp> ops = change.getAllOps(null);
                    LinkedList<MoveFileOp> moves = new LinkedList<MoveFileOp>();
                    LinkedList<PatchOp> mods = new LinkedList<PatchOp>();
                    for (PatchOp nextOp : ops) {
                        if (nextOp instanceof MoveFileOp) {
                            MoveFileOp move = (MoveFileOp)nextOp;
                            moves.add(move);
                            continue;
                        }
                        mods.add(nextOp);
                    }
                    changeProgress.setWorkRemaining(Math.max(moves.size(), mods.size()));
                    while (!moves.isEmpty() || !mods.isEmpty()) {
                        VersionablePath beforePath;
                        SubMonitor hunkProgress = changeProgress.newChild(1).setWorkRemaining(100);
                        MoveFileOp nextMove = moves.isEmpty() ? null : (MoveFileOp)moves.removeFirst();
                        PatchOp nextMod = mods.isEmpty() ? null : (PatchOp)mods.removeFirst();
                        VersionablePath vp = change.getVersionablePath();
                        SiloedItemId sid = vp.getSiloedItemId();
                        ItemId parentId = vp.segment(vp.segmentCount() - 1).getParent();
                        ChangeSyncDTO changeSync = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeSyncDTO();
                        VersionablePath afterPath = beforePath = change.getVersionablePath();
                        if (nextMove != null) {
                            afterPath = nextMove.getTargetVersionablePath();
                        }
                        boolean isNoOp = false;
                        if (nextMod != null) {
                            StateId mergeState;
                            StateId beforeState = mergeState = nextMod.getBeforeState();
                            StateId afterState = nextMod.getAfterState();
                            if (mergeState != ParsedFilePatch.UNKNOWN_STATE) {
                                changeSync.setLastMergeState(mergeState.getItemUUID().getUuidValue());
                            }
                            if (afterState != ParsedFilePatch.UNKNOWN_STATE) {
                                changeSync.setAfterStateId(afterState.getStateUUID().getUuidValue());
                            }
                            if (beforeState != ParsedFilePatch.UNKNOWN_STATE) {
                                changeSync.setBeforeStateId(beforeState.getStateUUID().getUuidValue());
                                isNoOp = beforeState.equals((Object)afterState);
                            }
                            changeSync.setAddType(nextMod.isCreate());
                            changeSync.setDeleteType(nextMod.isDelete());
                            if (includeFileStates) {
                                IInputStreamProvider beforeStream = nextMod.getBeforeStream((IProgressMonitor)hunkProgress.newChild(20));
                                changeSync.setBeforeStreamId(fileStore.saveStream(beforeStream, (IProgressMonitor)hunkProgress.newChild(20)));
                                IInputStreamProvider afterStream = nextMod.getAfterStream((IProgressMonitor)hunkProgress.newChild(20));
                                changeSync.setAfterStreamId(fileStore.saveStream(afterStream, (IProgressMonitor)hunkProgress.newChild(20)));
                                changeSync.setStartLine(nextMod.getStartLine((IProgressMonitor)hunkProgress.newChild(20)));
                            }
                        }
                        changeSync.setVersionableItemId(sid.getItemUUID().getUuidValue());
                        changeSync.setFile(sid.getItemId().toHandle() instanceof IFileItemHandle);
                        changeSync.setPotentialConflict(false);
                        boolean isMove = !beforePath.equals((Object)afterPath);
                        boolean isModify = !isMove && !isNoOp;
                        changeSync.setModifyType(isModify);
                        changeSync.setMoveType(isMove);
                        changeSync.setNoopType(isNoOp);
                        changeSync.setVersionableName(beforePath.getFileName());
                        if (isMove) {
                            changeSync.setPathHint(beforePath.toString());
                            changeSync.setNewPathHint(afterPath.toString());
                        } else {
                            changeSync.setPathHint(afterPath.toString());
                        }
                        CollectionUtil.addToMapOfLists(mapParentIdOntoChildChanges, (Object)parentId, (Object)changeSync);
                    }
                }
                List<ChangeFolderSyncDTO> folders = SyncViewDTOUtil.groupIntoFolders(mapParentIdOntoChildChanges, includeFoldersTwice);
                nextDTO.getChanges().addAll(folders);
            }
            result.add(nextDTO);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<ChangeSetSyncDTO> createChangeSetDTOs(ITeamRepository repo, List<Pair<ConfigurationChange, ChangeDescription>> changes, ParmsResolveChangeSet settings, IProgressMonitor monitor) throws TeamRepositoryException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        snapshot = SyncViewDTOUtil.getSnapshotId(repo, settings.context);
        pr = snapshot == null ? null : SnapshotPathResolver.create(snapshot);
        patches = new HashMap<UUID, ParsedPatch>();
        try {
            loopProgress = progress.newChild(20).setWorkRemaining(changes.size());
            for (Pair<ConfigurationChange, ChangeDescription> nextChange : changes) {
                description = nextChange.getSecond();
                id = description.getChangeSets().size() == 1 ? ((ItemId)description.getChangeSets().iterator().next()).getItemUUID() : UUID.generate();
                patches.put(id, ParsedPatch.createFromConfigurationChange(nextChange.getSecond(), nextChange.getFirst(), pr, false, (IProgressMonitor)loopProgress.newChild(1)));
            }
            var14_15 = SyncViewDTOUtil.createChangeSetDTOsFromPatches(repo, patches, settings, (IProgressMonitor)progress.newChild(80));
            return var14_15;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (CoreException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        finally {
            ** for (next : patches.values())
        }
lbl-1000:
        // 1 sources

        {
            next.dispose();
            continue;
        }
lbl23:
        // 1 sources

        throw var13_20;
    }

    public static ItemIdDTO createItemIdDto(ItemId id) {
        ItemIdDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createItemIdDTO();
        result.setId(id.getItemUUID().getUuidValue());
        result.setItemType(id.getItemType().getName());
        result.setNamespace(id.getItemType().getNamespaceURI());
        return result;
    }

    public static ItemIdDTO createItemIdDto(IItemHandle handle) {
        return SyncViewDTOUtil.createItemIdDto(ItemId.create((IItemHandle)handle));
    }

    private static List<ChangeFolderSyncDTO> groupIntoFolders(Map<ItemId, List<ChangeSyncDTO>> mapParentIdOntoChildChanges, boolean includeFoldersTwice) {
        HashMap<String, ChangeSyncDTO> mapItemIdOntoChange = new HashMap<String, ChangeSyncDTO>();
        for (Map.Entry<ItemId, List<ChangeSyncDTO>> next : mapParentIdOntoChildChanges.entrySet()) {
            for (ChangeSyncDTO nextSync : next.getValue()) {
                mapItemIdOntoChange.put(nextSync.getVersionableItemId(), nextSync);
            }
        }
        ArrayList<ChangeFolderSyncDTO> result = new ArrayList<ChangeFolderSyncDTO>();
        for (Map.Entry<ItemId, List<ChangeSyncDTO>> next : mapParentIdOntoChildChanges.entrySet()) {
            String path;
            ItemId itemId = next.getKey();
            String itemIdString = itemId.getItemUUID().getUuidValue();
            ChangeSyncDTO folderChange = (ChangeSyncDTO)mapItemIdOntoChange.get(itemIdString);
            if (folderChange == null) {
                folderChange = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeSyncDTO();
                folderChange.setNoopType(true);
                String pathHint = next.getValue().iterator().next().getPathHint();
                path = new Path(pathHint).removeLastSegments(1);
                folderChange.setPathHint(path.toString());
                folderChange.setVersionableItemId(itemIdString);
                folderChange.setFile(itemId.toHandle() instanceof IFileItemHandle);
                folderChange.setVersionableName(path.lastSegment());
            }
            ChangeFolderSyncDTO folderDTO = FilesystemRestClientDTOsyncFactory.eINSTANCE.createChangeFolderSyncDTO();
            folderDTO.setFolderChange((ChangeSyncDTO)EcoreUtil.copy((EObject)((EObject)folderChange)));
            path = folderChange.isSetNewPathHint() ? folderChange.getNewPathHint() : folderChange.getPathHint();
            folderDTO.setPath(path);
            if (includeFoldersTwice) {
                folderDTO.getChanges().addAll((Collection)next.getValue());
            } else {
                for (ChangeSyncDTO nextChange : next.getValue()) {
                    if (!nextChange.isFile()) continue;
                    folderDTO.getChanges().add(nextChange);
                }
            }
            result.add(folderDTO);
        }
        return result;
    }

    private static FallbackPathResolver getPathResolver(IPathResolver optionalBackupPathResolver) {
        ArrayList<IPathResolver> pathResolvers = new ArrayList<IPathResolver>();
        pathResolvers.add(CopyFileAreaPathResolver.create());
        if (optionalBackupPathResolver != null) {
            pathResolvers.add(optionalBackupPathResolver);
        }
        FallbackPathResolver fpr = new FallbackPathResolver(pathResolvers);
        return fpr;
    }

    private static ItemId<IFolder> getParent(IVersionable before) {
        if (before == null) {
            return ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        }
        return ItemUtil.getParent((IVersionable)before);
    }

    public static String computeComparisonName(SnapshotId snapshot1, SnapshotId snapshot2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISnapshot s1 = snapshot1.getSnapshot((IProgressMonitor)progress.newChild(50));
        ISnapshot s2 = snapshot2.getSnapshot((IProgressMonitor)progress.newChild(50));
        return SyncViewDTOUtil.computeComparisonName(s1, s2);
    }

    public static String computeComparisonName(ISnapshot s1, ISnapshot s2) {
        return NLS.bind((String)Messages.SyncViewDTOUtil_0, (Object)s1.getName(), (Object)s2.getName());
    }

    public static String computeChangeSetInputDescription(List<ItemId<IChangeSet>> changeSets, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets.size() == 1) {
            IChangeSet changeSet = (IChangeSet)RepoFetcher.fetchCurrent((ITeamRepository)repo, changeSets.iterator().next(), (IProgressMonitor)monitor);
            return ChangeSetLocationFactory.getFullContextLabel((IChangeSet)changeSet);
        }
        return NLS.bind((String)Messages.SyncViewDTOUtil_1, (Object)("" + changeSets.size()));
    }

    public static List<ItemId<IChangeSet>> fetchDifferentChangeSets(ITeamRepository repo, ItemId<IBaseline> current, ItemId<IBaseline> previous, final Set<ItemId<IChangeSet>> permittedChangeSets, SubMonitor progress) throws TeamRepositoryException {
        BaselineNamespace currentNamespace = BaselineNamespace.create((ITeamRepository)repo, current);
        BaselineNamespace previousNamespace = BaselineNamespace.create((ITeamRepository)repo, previous);
        IItemContext currentContext = currentNamespace.getContext((IProgressMonitor)progress.newChild(15));
        IItemContext previousContext = previousNamespace.getContext((IProgressMonitor)progress.newChild(15));
        EraDescriptor currentEra = currentContext.getChangeSets((IProgressMonitor)progress.newChild(15));
        EraDescriptor previousEra = previousContext.getChangeSets((IProgressMonitor)progress.newChild(15));
        EraSyncReport syncReport = currentEra.compare(previousEra, (IProgressMonitor)progress.newChild(20));
        List changeSets = CollectionUtil.filter((Collection)syncReport.getOutgoingIds(), (IFilter)new IFilter<ItemId<IChangeSet>>(){

            public boolean select(ItemId<IChangeSet> toTest) {
                return permittedChangeSets.contains(toTest);
            }
        });
        return changeSets;
    }

    public static SnapshotId getSnapshotId(ITeamRepository repo, ParmsContext context) {
        if (context == null) {
            return SnapshotId.createEmptyId((ITeamRepository)repo);
        }
        return SnapshotId.getSnapshotId((IItemHandle)context.getContextHandle());
    }

    public static ConfigurationChange getConfigurationChange(ITeamRepository repo, ComponentSyncReportFragment syncReport, boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)40);
        List<IChangeSet> orderedChangeSets = SyncViewDTOUtil.getChangeSets(repo, syncReport, needsRefresh, (IProgressMonitor)progress);
        ConfigurationChange change = ClientConfigurationChangeFactory.createChange((ITeamRepository)repo, orderedChangeSets, (IProgressMonitor)progress.newChild(20));
        return change;
    }

    public static List<IChangeSet> getChangeSets(ITeamRepository repo, ComponentSyncReportFragment syncReport, boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        EraSyncReportFragment oneBigEra = syncReport.computeNetChange(repo, (IProgressMonitor)progress.newChild(10));
        Map changeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)oneBigEra.getChangeSets(), (boolean)needsRefresh, (IProgressMonitor)progress.newChild(10));
        List orderedChangeSets = CollectionUtil.removeNulls((List)CollectionUtil.reorderValues((Map)changeSets, (List)oneBigEra.getChangeSets()));
        return orderedChangeSets;
    }
}

