/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDiscardChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveSuspendedChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResumeChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DiscardResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ResumeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.SuspendResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.rcp.core.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.DiscardOperation;
import com.ibm.team.filesystem.rcp.core.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.ResumeOperation;
import com.ibm.team.filesystem.rcp.core.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.SuspendOperation;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendResumeDiscardChangeSetUtil {
    public static final ResumeResultDTO resume(ParmsResumeChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postResume");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        List changeSets = parms.getChangeSets();
        ResumeResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createResumeResultDTO();
        ResumeDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getResumeDilemmaHandler(result.getOutOfSyncShares(), result.getLineDelimiterFailures(), result.getConfigurationsWithUnCheckedInChanges(), parms);
        ResumeOperation op = new ResumeOperation(wc, changeSets, dilemmaHandler);
        try {
            try {
                op.run((IProgressMonitor)monitor.newChild(80));
            }
            catch (ActiveChangeSetsOverlapException e) {
                SuspendResumeDiscardChangeSetUtil.handleActiveChangeSets(wc, changeSets, dilemmaHandler, parms.activeChangeSetsOverlapDirection, result.getActiveChangeSetsOverlap(), e, (IProgressMonitor)monitor.newChild(10));
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static void handleActiveChangeSets(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsToResume, ResumeDilemmaHandler dilemmaHandler, String activeChangeSetsOverlapDirection, List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, ActiveChangeSetsOverlapException exception, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List activeChangeSets = Collections.EMPTY_LIST;
        if ("continue".equals(activeChangeSetsOverlapDirection) || activeChangeSetsOverlapEncountered != null) {
            activeChangeSets = workspace.teamRepository().itemManager().fetchCompleteItems(changeSetsToResume, 0, (IProgressMonitor)progress.newChild(20));
            Iterator iCs = activeChangeSets.iterator();
            while (iCs.hasNext()) {
                IChangeSet cs = (IChangeSet)iCs.next();
                if (cs.isActive()) continue;
                iCs.remove();
            }
            if (activeChangeSetsOverlapEncountered != null) {
                activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
            }
        }
        if ("cancel".equals(activeChangeSetsOverlapDirection)) {
            throw new OperationCanceledException();
        }
        if (!"continue".equals(activeChangeSetsOverlapDirection)) {
            throw exception;
        }
        workspace.closeChangeSets((Collection)activeChangeSets, (IProgressMonitor)progress.newChild(10));
        ResumeOperation op = new ResumeOperation(workspace, changeSetsToResume, dilemmaHandler);
        op.run((IProgressMonitor)progress.newChild(80));
    }

    private static ResumeDilemmaHandler getResumeDilemmaHandler(List outOfSyncShares, List lineDelimiterErrors, final List configurationsWithPendingChanges, ParmsResumeChangeSets parms) throws TeamRepositoryException {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterErrors);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        ResumeDilemmaHandler dilemmaHandler = new ResumeDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                SuspendResumeDiscardChangeSetUtil.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return uncheckedInChangesInstruction;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return outOfSyncDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return outOfSyncDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return outOfSyncDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    public static final SuspendResultDTO suspend(ParmsSuspendChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postSuspendChangeSets");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        List changeSets = parms.getChangeSets();
        SuspendResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createSuspendResultDTO();
        SuspendDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getSuspendDilemmaHandler(result.getOutOfSyncShares(), result.getLineDelimiterFailures(), result.getConfigurationsWithUnCheckedInChanges(), parms);
        SuspendOperation op = new SuspendOperation(wc, changeSets, dilemmaHandler);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static SuspendDilemmaHandler getSuspendDilemmaHandler(List outOfSyncShares, List lineDelimiterErrors, final List configurationsWithPendingChanges, ParmsSuspendChangeSets parms) throws TeamRepositoryException {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterErrors);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        SuspendDilemmaHandler dilemmaHandler = new SuspendDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                SuspendResumeDiscardChangeSetUtil.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return uncheckedInChangesInstruction;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return outOfSyncDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return outOfSyncDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return outOfSyncDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    public static final DiscardResultDTO discard(ParmsDiscardChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postDiscard");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        List changeSets = parms.getChangeSets();
        DiscardResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDiscardResultDTO();
        DiscardDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getDiscardDilemmaHandler(result.getOutOfSyncShares(), result.getLineDelimiterFailures(), result.getConfigurationsWithUnCheckedInChanges(), parms);
        DiscardOperation op = new DiscardOperation(wc, changeSets, dilemmaHandler);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static DiscardDilemmaHandler getDiscardDilemmaHandler(List outOfSyncShares, List lineDelimiterErrors, final List configurationsWithPendingChanges, ParmsDiscardChangeSets parms) throws TeamRepositoryException {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterErrors);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        DiscardDilemmaHandler dilemmaHandler = new DiscardDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                SuspendResumeDiscardChangeSetUtil.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return uncheckedInChangesInstruction;
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return outOfSyncDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return outOfSyncDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return outOfSyncDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return outOfSyncDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
        if (configurationDescriptorDTOs != null) {
            for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
    }

    public static final void removeSuspended(ParmsRemoveSuspendedChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postRemoveSuspendedChangeSets");
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        List changeSets = CommonUtil.createHandles((IItemType)IChangeSet.ITEM_TYPE, (String)parms.workspace.repositoryUrl, (String[])parms.changeSetItemIds);
        wc.removeSuspended((Collection)changeSets, (IProgressMonitor)monitor.newChild(90));
    }
}

