/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IFailedUpload;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSummary;
import com.ibm.team.filesystem.client.rest.parameters.ParmsEclipseWorkspacePaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOSPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ChangeSummaryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EclipseWorkspacePathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.IgnoreReasonDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.OSPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ShareableResource;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.rcp.core.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.rcp.core.operations.IChangePropertiesRequest;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    private static final String GET_RESOURCE_PROPERTIES = "getResourceProperties";
    private static final String POST_RESOURCE_PROPERTIES = "postResourceProperties";
    private static final String GET_ECLIPSE_WORKSPACE_PATHS = "getEclipseWorkspacePaths";
    private static final String GET_OS_PATHS = "getOSPaths";

    public static ResourcesDTO getResourceProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        boolean computeFully;
        parms.validate(GET_RESOURCE_PROPERTIES);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.resourcePaths.length);
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        boolean bl = computeFully = parms.computeFully != null && parms.computeFully != false;
        if (computeFully) {
            monitor.setWorkRemaining(parms.resourcePaths.length * 2);
        }
        HashMap<ConfigurationDescriptor, ArrayList<ResourcePropertiesDTO>> sharePaths = new HashMap<ConfigurationDescriptor, ArrayList<ResourcePropertiesDTO>>();
        ResourcesDTO resources = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcesDTO();
        String[] stringArray = parms.resourcePaths;
        int n = parms.resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceStringPath = stringArray[n2];
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            ResourcePropertiesDTO resourceProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertiesDTO();
            resources.getResourceProperties().add(resourceProperties);
            resourceProperties.setLocalPath(CoreUtil.translatePath(resourceStringPath));
            Path resourcePath = new Path(resourceStringPath);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)resourcePath);
            if (resource != null && resource.exists()) {
                resourceProperties.setLocal(true);
                ShareableResource shareable = new ShareableResource(resource);
                if (shareable == null) {
                    resourceProperties.setShared(false);
                    resourceProperties.setRemote(false);
                } else {
                    IShare share = shareable.getShare();
                    resourceProperties.setShared(share != null);
                    if (resourceProperties.isShared()) {
                        IVersionableHandle versionable;
                        assert (share != null);
                        resourceProperties.setShare(CoreUtil.translateShare(share));
                        resourceProperties.setIgnored(shareable.shouldBeIgnored());
                        if (computeFully && resourceProperties.isIgnored()) {
                            ResourceUtil.getResourceIgnoreProperties((IShareable)shareable, resourceProperties, resourceMonitor.newChild(50));
                        }
                        if ((versionable = shareable.getVersionable()) == null) {
                            resourceProperties.setRemote(false);
                        } else {
                            resourceProperties.setItemId(versionable.getItemId().getUuidValue());
                            if (versionable.hasStateId()) {
                                resourceProperties.setStateId(versionable.getStateId().getUuidValue());
                                resourceProperties.setRemote(true);
                                if (computeFully) {
                                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                                    ConfigurationDescriptor configDescriptor = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent());
                                    ArrayList<ResourcePropertiesDTO> properties = (ArrayList<ResourcePropertiesDTO>)sharePaths.get(configDescriptor);
                                    if (properties == null) {
                                        properties = new ArrayList<ResourcePropertiesDTO>();
                                        sharePaths.put(configDescriptor, properties);
                                    }
                                    properties.add(resourceProperties);
                                }
                            } else {
                                resourceProperties.setRemote(false);
                            }
                        }
                        int state = shareable.getState();
                        resourceProperties.setDirty((state & 4) == 4);
                        if (!((Shareable)shareable).getFileStorage().isFolder()) {
                            resourceProperties.setFolderVersionable(false);
                            FileItemInfo info = ((SharingManager)sharingManager).getItemInfo((IShareable)shareable);
                            if (info != null) {
                                FilePropertiesDTO fileProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createFilePropertiesDTO();
                                fileProperties.setContentType(info.getContentType());
                                if (info.getLineDelimiter() != null) {
                                    fileProperties.setLineDelimiter(info.getLineDelimiter().toString());
                                }
                                fileProperties.setOriginalContentType(info.getOriginalContentType());
                                if (info.getOriginalLineDelimiter() != null) {
                                    fileProperties.setOriginalLineDelimiter(info.getOriginalLineDelimiter().toString());
                                }
                                fileProperties.setExecutable(shareable.isExecutable());
                                fileProperties.setOriginalExecutable(info.isOriginalExecutable());
                                resourceProperties.setFileProperties(fileProperties);
                            }
                        } else {
                            resourceProperties.setFolderVersionable(true);
                        }
                    }
                }
            } else {
                IPath parentPath = resourcePath.removeLastSegments(1);
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember(parentPath);
                while (!(resource != null && resource.exists() || parentPath.segmentCount() <= 1)) {
                    resource = ResourcesPlugin.getWorkspace().getRoot().findMember(parentPath);
                    parentPath = parentPath.removeLastSegments(1);
                }
                if (resource != null && resource.exists() && resource.getType() != 8) {
                    ShareableResource parentShareable = new ShareableResource(resource);
                    resourceProperties.setLocal(false);
                    resourceProperties.setRemote(false);
                    IShare parentShare = parentShareable.getShare();
                    resourceProperties.setShared(parentShare != null);
                    if (resourceProperties.isShared()) {
                        resourceProperties.setShare(CoreUtil.translateShare(parentShare));
                    }
                } else {
                    resourceProperties.setLocal(false);
                    resourceProperties.setShared(false);
                }
            }
            resourceMonitor.done();
            ++n2;
        }
        if (computeFully) {
            monitor = monitor.setWorkRemaining(sharePaths.size() * 30);
            for (Map.Entry entry : sharePaths.entrySet()) {
                IConfiguration configuration = ((ConfigurationDescriptor)entry.getKey()).getConfiguration((IProgressMonitor)monitor.newChild(10));
                List properties = (List)entry.getValue();
                ArrayList<Object> versionables = new ArrayList<Object>(properties.size());
                for (ResourcePropertiesDTO resourceProperties : properties) {
                    if (resourceProperties.isFolderVersionable()) {
                        versionables.add((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)resourceProperties.getItemId()), null));
                        continue;
                    }
                    versionables.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)resourceProperties.getItemId()), null));
                }
                List ancestors = configuration.locateAncestors(versionables, (IProgressMonitor)monitor.newChild(20));
                int i = 0;
                for (IAncestorReport report : ancestors) {
                    ResourcePropertiesDTO resourceProperties = (ResourcePropertiesDTO)properties.get(i);
                    ++i;
                    if (report.getNameItemPairs().isEmpty()) continue;
                    resourceProperties.setRemotePath(CoreUtil.translatePath(report));
                }
            }
        }
        return resources;
    }

    private static void getResourceIgnoreProperties(IShareable shareable, ResourcePropertiesDTO resourceProperties, SubMonitor monitor) {
        IIgnoreManager.IIgnoreReason reasons;
        try {
            reasons = IgnoreManager.getInstance().findIgnoreReasons(shareable, (IProgressMonitor)monitor);
        }
        catch (FileSystemClientException fileSystemClientException) {
            return;
        }
        if (reasons == null) {
            return;
        }
        IgnoreReasonDTO reasonDTO = FilesystemRestClientDTOresourceFactory.eINSTANCE.createIgnoreReasonDTO();
        PathDTO inheritPath = null;
        if (reasons.inherited()) {
            inheritPath = CoreUtil.translatePath(reasons.inheritsFrom().getLocalFullPath());
        }
        reasonDTO.setInheritsFrom(inheritPath);
        for (IIgnoreProvider.IIgnoreRule rule : reasons.getRules()) {
            reasonDTO.getRules().add(IgnoresUtil.translateRule(rule));
        }
        resourceProperties.setIgnoreReason(reasonDTO);
    }

    public static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, ParmsOutOfSyncInstructions outOfSyncDilemmaHandler, List<ShareDTO> sharesOutOfSync) {
        final LineDelimiterErrorHandler lineDelimiterErrorHandler = new LineDelimiterErrorHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        final OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(outOfSyncDilemmaHandler, sharesOutOfSync);
        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters) {
                return lineDelimiterErrorHandler.inconsistentLineDelimiters(inconsistentDelimiters);
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return oosDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return oosDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return oosDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return oosDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return oosDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return oosDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }
        };
        return dilemmaHandler;
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(IShareable shareable, LineDelimiter incompatibleLineDelimiterSetting) {
        LineDelimiterErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createLineDelimiterErrorDTO();
        failedUpload.setFileName(CoreUtil.translatePath(shareable.getLocalFullPath()));
        failedUpload.setShare(CoreUtil.translateShare(shareable.getShare()));
        if (incompatibleLineDelimiterSetting != null) {
            failedUpload.setLineDelimiter(ResourceUtil.getLineDelimiter(incompatibleLineDelimiterSetting));
        }
        return failedUpload;
    }

    public static ResourcePropertyChangeResultDTO postResourceProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(POST_RESOURCE_PROPERTIES);
        ResourcePropertyChangeResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertyChangeResultDTO();
        ChangePropertiesDilemmaHandler dilemmaHandler = ResourceUtil.getChangePropertiesDilemmaHandler(parms.lineDelimiterDilemmaHandler, result.getLineDelimiterFailures(), parms.outOfSyncInstructions, result.getOutOfSyncShares());
        IChangeFilePropertiesOperation op = ResourceUtil.prepareChangePropertyOperation(parms, dilemmaHandler, monitor.newChild(10));
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IChangeFilePropertiesOperation prepareChangePropertyOperation(ParmsResourcePropertyUpdates parms, ChangePropertiesDilemmaHandler dilemmaHandler, SubMonitor newChild) throws TeamRepositoryException {
        IChangeFilePropertiesOperation op = IEclipseFileSystemManager.instance.getChangeFilePropertiesOperation(dilemmaHandler);
        ParmsResourcePropertyChange[] parmsResourcePropertyChangeArray = parms.resourcePropertyChanges;
        int n = parms.resourcePropertyChanges.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsResourcePropertyChange propertyChangeRequest = parmsResourcePropertyChangeArray[n2];
            IShareable shareable = ResourceUtil.findShareableFor(propertyChangeRequest.filePath);
            if (propertyChangeRequest.lineDelimiter != null && propertyChangeRequest.lineDelimiter.length() > 0) {
                LineDelimiter lineDelimiter = ResourceUtil.getLineDelimiter(propertyChangeRequest.lineDelimiter);
                op.setLineDelimiter(shareable, lineDelimiter);
            }
            if (propertyChangeRequest.mimeType != null && propertyChangeRequest.mimeType.length() > 0) {
                op.setContentType(shareable, propertyChangeRequest.mimeType);
            }
            ++n2;
        }
        return op;
    }

    private static LineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        if ("lf".equals(lineDelimiterSetting)) {
            return LineDelimiter.LINE_DELIMITER_LF;
        }
        if ("cr".equals(lineDelimiterSetting)) {
            return LineDelimiter.LINE_DELIMITER_CR;
        }
        if ("crlf".equals(lineDelimiterSetting)) {
            return LineDelimiter.LINE_DELIMITER_CRLF;
        }
        if ("platform".equals(lineDelimiterSetting)) {
            return LineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if ("none".equals(lineDelimiterSetting)) {
            return LineDelimiter.LINE_DELIMITER_NONE;
        }
        throw new IllegalArgumentException(NLS.bind((String)"{0} has value {1} which is not one of {2}, {3}, {4}, {5}, {6}", (Object[])new Object[]{"lineDelimiter", lineDelimiterSetting, "lf", "cr", "crlf", "platform", "none"}));
    }

    private static String getLineDelimiter(LineDelimiter lineDelimiterSetting) {
        if (lineDelimiterSetting == null) {
            return "";
        }
        switch (lineDelimiterSetting) {
            case LINE_DELIMITER_PLATFORM: {
                return "platform";
            }
            case LINE_DELIMITER_CRLF: {
                return "crlf";
            }
            case LINE_DELIMITER_LF: {
                return "lf";
            }
            case LINE_DELIMITER_CR: {
                return "cr";
            }
            case LINE_DELIMITER_NONE: {
                return "none";
            }
        }
        return "";
    }

    public static IShareable findShareableFor(String path) throws TeamRepositoryException {
        Path resourcePath = new Path(path);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)resourcePath);
        if (resource == null || !resource.exists()) {
            throw new TeamRepositoryException("Resource does not exist: " + path);
        }
        return new ShareableResource(resource);
    }

    public static IResource findResourceFor(String path) {
        Path resourcePath = new Path(path);
        return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)resourcePath);
    }

    public static EclipseWorkspacePathsResultDTO getEclipseWorkspacePaths(ParmsEclipseWorkspacePaths parms, IProgressMonitor progress) {
        parms.validate(GET_ECLIPSE_WORKSPACE_PATHS);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.pathsToResolve.length);
        EclipseWorkspacePathsResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createEclipseWorkspacePathsResultDTO();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = parms.pathsToResolve;
        int n = parms.pathsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            String completePath = stringArray[n2];
            Path path = new Path(completePath);
            File file = path.toFile();
            try {
                path = new Path(file.getCanonicalPath());
            }
            catch (IOException iOException) {}
            Object resource = file.isDirectory() ? workspaceRoot.getContainerForLocation((IPath)path) : workspaceRoot.getFileForLocation((IPath)path);
            if (resource == null) {
                result.getResourcePaths().add(FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO());
            } else {
                result.getResourcePaths().add(CoreUtil.translatePath(resource.getFullPath()));
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return result;
    }

    public static OSPathsResultDTO getOSPaths(ParmsOSPaths parms, IProgressMonitor progress) {
        parms.validate(GET_OS_PATHS);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.pathsToResolve.length);
        OSPathsResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createOSPathsResultDTO();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = parms.pathsToResolve;
        int n = parms.pathsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            String workspacePath = stringArray[n2];
            String osPath = "";
            Path path = new Path(workspacePath);
            IResource resource = workspaceRoot.findMember((IPath)path);
            if (resource != null && (location = resource.getLocation()) != null) {
                osPath = location.toOSString();
            }
            result.getOSPaths().add(osPath);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return result;
    }

    public static ChangeSummaryDTO getChangeSummary(ParmsChangeSummary parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("getResourceChange");
        ChangeSummaryDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createChangeSummaryDTO();
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ITeamRepository repo = wc.teamRepository();
        IChangeSetHandle handle = CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)parms.changeSetItemId);
        IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)monitor.newChild(10));
        IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)repo).getFileSystemView((IConnection)wc);
        IPath copyFileAreaRoot = FileSystemCore.getSharingManager().getDefaultCFARoot();
        List summaries = fsv.interpretChanges(copyFileAreaRoot, Collections.singletonList(changeSet), (IProgressMonitor)monitor.newChild(80));
        IChangeSetSummary summary = (IChangeSetSummary)summaries.get(0);
        IChangeSummary changeSummary = null;
        for (IChangeSummary cs : summary.changes()) {
            if (!cs.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            changeSummary = cs;
            break;
        }
        if (changeSummary == null) {
            throw new TeamRepositoryException("Resource not found in given change set");
        }
        if (changeSummary.afterState() != null) {
            result.setAfterStateId(changeSummary.afterState().getStateId().getUuidValue());
        }
        if (changeSummary.beforeState() != null) {
            result.setBeforeStateId(changeSummary.beforeState().getStateId().getUuidValue());
        }
        for (IChange change : changeSet.changes()) {
            IVersionableHandle lastMergeState;
            if (!change.item().getItemId().equals((Object)parms.versionableItemId)) continue;
            if (change.mergeStates().size() <= 0 || (lastMergeState = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1)) == null || lastMergeState.getStateId() == null) break;
            result.setLastMergeState(lastMergeState.getStateId().getUuidValue());
            break;
        }
        result.setPathHint(ComponentSyncUtil.toString(changeSummary.getPathHint(), false));
        String[] newPathHint = changeSummary.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ComponentSyncUtil.toString(newPathHint, false));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineDelimiterErrorHandler {
        private final Map<String, Boolean> lineDelimiterInstructions;
        private final int generalLineDelimiterDirection;
        private final List<LineDelimiterErrorDTO> lineDelimiterErrorsReported;

        public LineDelimiterErrorHandler(ParmsLineDelimiterDilemmaHandler parmsLineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
            if (parmsLineDelimiterDilemmaHandler == null) {
                this.generalLineDelimiterDirection = 2;
                this.lineDelimiterInstructions = Collections.EMPTY_MAP;
            } else {
                this.generalLineDelimiterDirection = this.getDirection(parmsLineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction);
                this.lineDelimiterInstructions = this.initializeLineDelimiterInstructions(parmsLineDelimiterDilemmaHandler.lineDelimiterErrorInstructions);
            }
            this.lineDelimiterErrorsReported = lineDelimiterErrorsReported;
        }

        private HashMap<String, Boolean> initializeLineDelimiterInstructions(ParmsLineDelimiterErrorInstructions[] lineDelimiterErrorInstructions) {
            HashMap<String, Boolean> instructions = new HashMap<String, Boolean>();
            if (lineDelimiterErrorInstructions != null) {
                int i = 0;
                while (i < lineDelimiterErrorInstructions.length) {
                    ParmsLineDelimiterErrorInstructions instruction = lineDelimiterErrorInstructions[i];
                    Path path = new Path(instruction.filePath);
                    instructions.put(PathUtils.getString((String[])path.segments()), instruction.forceConsistentDelimiters);
                    ++i;
                }
            }
            return instructions;
        }

        private int getDirection(String direction) {
            if ("cancel".equals(direction)) {
                return 1;
            }
            if ("continue".equals(direction)) {
                return 0;
            }
            return 2;
        }

        public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters) {
            if (this.lineDelimiterErrorsReported != null) {
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(request.getShareableToChange(), request.getLineDelimiter()));
                }
            }
            boolean followGeneralInstruction = false;
            for (IChangePropertiesRequest request : inconsistentDelimiters) {
                Boolean instruction = this.lineDelimiterInstructions.get(PathUtils.getString((String[])request.getShareableToChange().getLocalFullPath().segments()));
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        request.setForceLineDelimiterConversion(false);
                    }
                    followGeneralInstruction = true;
                    continue;
                }
                request.setForceLineDelimiterConversion(instruction);
            }
            if (followGeneralInstruction) {
                return this.generalLineDelimiterDirection;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(IFailedUpload failedFile) {
            Boolean instruction;
            if (this.lineDelimiterErrorsReported != null) {
                List<LineDelimiterErrorDTO> list = this.lineDelimiterErrorsReported;
                synchronized (list) {
                    this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(failedFile.getShareable(), failedFile.getShareable().getLineDelimiter()));
                }
            }
            if ((instruction = this.lineDelimiterInstructions.get(PathUtils.getString((String[])failedFile.getShareable().getLocalFullPath().segments()))) == null) {
                if (this.generalLineDelimiterDirection == 0) {
                    failedFile.setForceConsistentDelimiters(false);
                }
                return this.generalLineDelimiterDirection;
            }
            failedFile.setForceConsistentDelimiters(instruction.booleanValue());
            return 0;
        }
    }
}

