/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRefreshEclipseWorkspace;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshUtil {
    public static void refreshEclipseWorkspace(ParmsRefreshEclipseWorkspace parm, IProgressMonitor progress) throws TeamRepositoryException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            parm.validate("getRefreshEclipseWorkspace");
            IWorkspace eclipseWorkspace = ResourcesPlugin.getWorkspace();
            if (parm.paths == null || parm.paths.length == 0) {
                eclipseWorkspace.getRoot().refreshLocal(2, (IProgressMonitor)monitor);
            } else {
                SubMonitor loopProgress = monitor.newChild(100).setWorkRemaining(parm.paths.length);
                int i = 0;
                while (i < parm.paths.length) {
                    Path projectPath;
                    String path = parm.paths[i];
                    IResource resource = eclipseWorkspace.getRoot().findMember((IPath)new Path(path));
                    if (resource != null && resource.exists()) {
                        resource.refreshLocal(2, (IProgressMonitor)loopProgress.newChild(1));
                    } else if (parm.openNamedEclipseProjects && (projectPath = new Path(path)).segmentCount() == 1) {
                        IProject project = eclipseWorkspace.getRoot().getProject(path);
                        assert (!project.exists());
                        SubMonitor projProgress = loopProgress.newChild(1);
                        projProgress.beginTask(NLS.bind((String)Messages.FilesystemRestClient_REFRESH_ROOT_DIRECTORY, (Object)project.getName()), 11);
                        File projectAsFile = new File(RefreshUtil.getCopyFileAreaRoot((IProgressMonitor)loopProgress.newChild(1)), project.getName());
                        if (projectAsFile.exists()) {
                            project.create((IProgressMonitor)projProgress.newChild(1));
                            project.open((IProgressMonitor)projProgress.newChild(9));
                            projProgress.done();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            throw new TeamRepositoryException("Failed to refresh eclipse workspace", (Throwable)e);
        }
    }

    public static String getCopyFileAreaRoot(IProgressMonitor progress) {
        IPath path = SharingManager.getInstance().getDefaultCFARoot();
        if (path == null) {
            return null;
        }
        return path.toOSString();
    }
}

